/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TxImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.SubordinateAtomicAction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
import java.io.IOException;
import java.util.Stack;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XATerminatorImple
implements XATerminator {
    private boolean _recoveryStarted = false;

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            TransactionImple tx = TxImporter.getImportedTransaction(xid);
            if (tx == null) {
                throw new XAException(-5);
            }
            if (((com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple)tx).activated()) {
                if (onePhase) {
                    tx.doOnePhaseCommit();
                } else {
                    tx.doCommit();
                }
            } else {
                throw new XAException(4);
            }
            TxImporter.removeImportedTransaction(xid);
        }
        catch (RollbackException e) {
            TxImporter.removeImportedTransaction(xid);
            XAException xaException = new XAException(100);
            xaException.initCause(e);
            throw xaException;
        }
        catch (XAException ex) {
            if (ex.errorCode != 4) {
                TxImporter.removeImportedTransaction(xid);
            }
            throw ex;
        }
        catch (HeuristicRollbackException ex) {
            throw new XAException(6);
        }
        catch (HeuristicMixedException ex) {
            throw new XAException(5);
        }
        catch (SystemException ex) {
            TxImporter.removeImportedTransaction(xid);
            throw new XAException(-3);
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            TransactionImple tx = TxImporter.getImportedTransaction(xid);
            if (tx == null) {
                throw new XAException(-5);
            }
            tx.doForget();
        }
        catch (Exception ex) {
            throw new XAException(-3);
        }
        finally {
            TxImporter.removeImportedTransaction(xid);
        }
    }

    public int prepare(Xid xid) throws XAException {
        TransactionImple tx = TxImporter.getImportedTransaction(xid);
        if (tx == null) {
            throw new XAException(-5);
        }
        switch (tx.doPrepare()) {
            case 2: {
                TxImporter.removeImportedTransaction(xid);
                return 3;
            }
            case 1: {
                Throwable initCause = null;
                int xaExceptionCode = 100;
                try {
                    tx.doRollback();
                }
                catch (HeuristicCommitException e) {
                    initCause = e;
                    xaExceptionCode = -3;
                }
                catch (HeuristicMixedException e) {
                    initCause = e;
                    xaExceptionCode = -3;
                }
                catch (SystemException e) {
                    initCause = e;
                    xaExceptionCode = -3;
                }
                TxImporter.removeImportedTransaction(xid);
                XAException xaException = new XAException(xaExceptionCode);
                if (initCause != null) {
                    xaException.initCause(initCause);
                }
                throw xaException;
            }
            case 0: {
                return 0;
            }
        }
        throw new XAException(104);
    }

    public Xid[] recover(int flag) throws XAException {
        Xid[] indoubt;
        block15: {
            switch (flag) {
                case 0x1000000: {
                    if (this._recoveryStarted) {
                        throw new XAException(-6);
                    }
                    this._recoveryStarted = true;
                    break;
                }
                case 0x800000: {
                    if (!this._recoveryStarted) {
                        throw new XAException(-6);
                    }
                    this._recoveryStarted = false;
                    return null;
                }
                case 0: {
                    if (this._recoveryStarted) break;
                }
                default: {
                    throw new XAException(-6);
                }
            }
            indoubt = null;
            try {
                TransactionImple tx;
                ObjectStore objStore = new ObjectStore(TxControl.getActionStoreType());
                InputObjectState states = new InputObjectState();
                if (!objStore.allObjUids(SubordinateAtomicAction.getType(), states) || !states.notempty()) break block15;
                Stack<TransactionImple> values = new Stack<TransactionImple>();
                boolean finished = false;
                do {
                    Uid uid = new Uid(Uid.nullUid());
                    try {
                        uid.unpack(states);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        finished = true;
                    }
                    if (uid.notEquals(Uid.nullUid())) {
                        tx = TxImporter.recoverTransaction(uid);
                        if (tx == null) continue;
                        values.push(tx);
                        continue;
                    }
                    finished = true;
                } while (!finished);
                if (values.size() > 0) {
                    int index = 0;
                    indoubt = new Xid[values.size()];
                    while (!values.empty()) {
                        tx = (TransactionImple)values.pop();
                        indoubt[index] = tx.baseXid();
                        ++index;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return indoubt;
    }

    public void rollback(Xid xid) throws XAException {
        try {
            TransactionImple tx = TxImporter.getImportedTransaction(xid);
            if (tx == null) {
                throw new XAException(-5);
            }
            if (!((com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple)tx).activated()) {
                throw new XAException(4);
            }
            tx.doRollback();
            TxImporter.removeImportedTransaction(xid);
        }
        catch (XAException ex) {
            if (ex.errorCode != 4) {
                TxImporter.removeImportedTransaction(xid);
            }
            throw ex;
        }
        catch (HeuristicCommitException ex) {
            throw new XAException(7);
        }
        catch (HeuristicMixedException ex) {
            throw new XAException(5);
        }
        catch (SystemException ex) {
            TxImporter.removeImportedTransaction(xid);
            throw new XAException(-3);
        }
    }
}

