/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

final class MAuditParser {
    private static final String AUDIT_PATTERN = "(?:file:)?(.+):(\\d+)\\s*:\\s+(.*)";
    private final RegexpMatcher matcher = new RegexpMatcherFactory().newRegexpMatcher();

    MAuditParser() {
        this.matcher.setPattern(AUDIT_PATTERN);
    }

    Violation parseLine(String line) {
        Vector matches = this.matcher.getGroups(line);
        if (matches == null) {
            return null;
        }
        String file = (String)matches.elementAt(1);
        Violation violation = new Violation();
        violation.file = file;
        violation.line = (String)matches.elementAt(2);
        violation.error = (String)matches.elementAt(3);
        int pos = file.lastIndexOf(File.separatorChar);
        if (pos != -1 && pos != file.length() - 1) {
            String filename = file.substring(pos + 1);
            violation.error = StringUtils.replace((String)violation.error, (String)("file:" + file), (String)filename);
        }
        return violation;
    }

    static {
        AUDIT_PATTERN = AUDIT_PATTERN;
    }

    static final class Violation {
        String file;
        String line;
        String error;

        Violation() {
        }
    }
}

