/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.util.StringTokenizer;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.debug.DebugParser;
import org.antlr.tool.GrammarReport;

public class Profiler
implements DebugEventListener {
    public static final String Version = "1";
    public static final String RUNTIME_STATS_FILENAME = "runtime.stats";
    public static final int NUM_RUNTIME_STATS = 20;
    public DebugParser parser = null;
    protected int level = 0;
    protected boolean inDecision = false;
    protected int maxLookaheadInDecision = 0;
    protected CommonToken lastTokenConsumed = null;
    public int numRuleInvocations = 0;
    public int maxRuleInvocationDepth = 0;
    public int numFixedDecisions = 0;
    public int numCyclicDecisions = 0;
    public int[] decisionMaxFixedLookaheads = new int[200];
    public int[] decisionMaxCyclicLookaheads = new int[200];
    public int numHiddenTokens = 0;
    public int numCharsMatched = 0;
    public int numHiddenCharsMatched = 0;
    public int numSemanticPredicates = 0;
    protected int numberReportedErrors = 0;

    public Profiler() {
    }

    public Profiler(DebugParser debugParser) {
        this.parser = debugParser;
    }

    public void enterRule(String string) {
        ++this.level;
        ++this.numRuleInvocations;
        if (this.level > this.maxRuleInvocationDepth) {
            this.maxRuleInvocationDepth = this.level;
        }
    }

    public void exitRule(String string) {
        --this.level;
    }

    public void enterAlt(int n) {
    }

    public void enterSubRule(int n) {
    }

    public void exitSubRule(int n) {
    }

    public void enterDecision(int n) {
        this.inDecision = true;
    }

    public void exitDecision(int n) {
        if (this.parser.isCyclicDecision) {
            ++this.numCyclicDecisions;
        } else {
            ++this.numFixedDecisions;
        }
        this.inDecision = false;
        if (this.parser.isCyclicDecision) {
            ++this.maxLookaheadInDecision;
            if (this.numCyclicDecisions >= this.decisionMaxCyclicLookaheads.length) {
                int[] nArray = new int[this.decisionMaxCyclicLookaheads.length * 2];
                System.arraycopy(this.decisionMaxCyclicLookaheads, 0, nArray, 0, this.decisionMaxCyclicLookaheads.length);
                this.decisionMaxCyclicLookaheads = nArray;
            }
            this.decisionMaxCyclicLookaheads[this.numCyclicDecisions - 1] = this.maxLookaheadInDecision;
        } else {
            if (this.numFixedDecisions >= this.decisionMaxFixedLookaheads.length) {
                int[] nArray = new int[this.decisionMaxFixedLookaheads.length * 2];
                System.arraycopy(this.decisionMaxFixedLookaheads, 0, nArray, 0, this.decisionMaxFixedLookaheads.length);
                this.decisionMaxFixedLookaheads = nArray;
            }
            this.decisionMaxFixedLookaheads[this.numFixedDecisions - 1] = this.maxLookaheadInDecision;
        }
        this.parser.isCyclicDecision = false;
        this.maxLookaheadInDecision = 0;
    }

    public void location(int n, int n2) {
    }

    public void consumeToken(Token token) {
        if (this.inDecision && this.parser.isCyclicDecision) {
            ++this.maxLookaheadInDecision;
        }
        this.lastTokenConsumed = (CommonToken)token;
    }

    public void consumeHiddenToken(Token token) {
        this.lastTokenConsumed = (CommonToken)token;
    }

    public void LT(int n, Token token) {
        if (this.inDecision && !this.parser.isCyclicDecision && n > this.maxLookaheadInDecision) {
            this.maxLookaheadInDecision = n;
        }
    }

    public void mark(int n) {
    }

    public void rewind(int n) {
    }

    public void recognitionException(RecognitionException recognitionException) {
        ++this.numberReportedErrors;
    }

    public void beginResync() {
    }

    public void endResync() {
    }

    public void semanticPredicate(boolean bl, String string) {
        ++this.numSemanticPredicates;
    }

    public void commence() {
    }

    public void terminate() {
        GrammarReport.writeReport(RUNTIME_STATS_FILENAME, this.toNotifyString());
    }

    public void setParser(DebugParser debugParser) {
        this.parser = debugParser;
    }

    public String toNotifyString() {
        TokenStream tokenStream = this.parser.getTokenStream();
        for (int i = 0; i < tokenStream.size() && i <= this.lastTokenConsumed.getTokenIndex(); ++i) {
            Token token = tokenStream.get(i);
            if (token.getChannel() == 0) continue;
            ++this.numHiddenTokens;
            this.numHiddenCharsMatched += token.getText().length();
        }
        this.numCharsMatched = this.lastTokenConsumed.getStopIndex() + 1;
        this.decisionMaxFixedLookaheads = this.trim(this.decisionMaxFixedLookaheads, this.numFixedDecisions);
        this.decisionMaxCyclicLookaheads = this.trim(this.decisionMaxCyclicLookaheads, this.numCyclicDecisions);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Version);
        stringBuffer.append('\t');
        stringBuffer.append(this.parser.getClass().getName());
        stringBuffer.append('\t');
        stringBuffer.append(this.numRuleInvocations);
        stringBuffer.append('\t');
        stringBuffer.append(this.maxRuleInvocationDepth);
        stringBuffer.append('\t');
        stringBuffer.append(this.numFixedDecisions);
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.min(this.decisionMaxFixedLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.max(this.decisionMaxFixedLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.avg(this.decisionMaxFixedLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.stddev(this.decisionMaxFixedLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(this.numCyclicDecisions);
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.min(this.decisionMaxCyclicLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.max(this.decisionMaxCyclicLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.avg(this.decisionMaxCyclicLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.stddev(this.decisionMaxCyclicLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(this.numSemanticPredicates);
        stringBuffer.append('\t');
        stringBuffer.append(this.parser.getTokenStream().size());
        stringBuffer.append('\t');
        stringBuffer.append(this.numHiddenTokens);
        stringBuffer.append('\t');
        stringBuffer.append(this.numCharsMatched);
        stringBuffer.append('\t');
        stringBuffer.append(this.numHiddenCharsMatched);
        stringBuffer.append('\t');
        stringBuffer.append(this.numberReportedErrors);
        return stringBuffer.toString();
    }

    public String toString() {
        return Profiler.toString(this.toNotifyString());
    }

    protected static String[] decodeReportData(String string) {
        String[] stringArray = new String[20];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        if (n != 20) {
            return null;
        }
        return stringArray;
    }

    public static String toString(String string) {
        String[] stringArray = Profiler.decodeReportData(string);
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ANTLR Runtime Report; Profile Version ");
        stringBuffer.append(stringArray[0]);
        stringBuffer.append('\n');
        stringBuffer.append("parser name ");
        stringBuffer.append(stringArray[1]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of rule invocations ");
        stringBuffer.append(stringArray[2]);
        stringBuffer.append('\n');
        stringBuffer.append("max rule invocation nesting depth ");
        stringBuffer.append(stringArray[3]);
        stringBuffer.append('\n');
        stringBuffer.append("number of fixed lookahead decisions ");
        stringBuffer.append(stringArray[4]);
        stringBuffer.append('\n');
        stringBuffer.append("min lookahead used in a fixed lookahead decision ");
        stringBuffer.append(stringArray[5]);
        stringBuffer.append('\n');
        stringBuffer.append("max lookahead used in a fixed lookahead decision ");
        stringBuffer.append(stringArray[6]);
        stringBuffer.append('\n');
        stringBuffer.append("average lookahead depth used in fixed lookahead decisions ");
        stringBuffer.append(stringArray[7]);
        stringBuffer.append('\n');
        stringBuffer.append("standard deviation of depth used in fixed lookahead decisions ");
        stringBuffer.append(stringArray[8]);
        stringBuffer.append('\n');
        stringBuffer.append("number of arbitrary lookahead decisions ");
        stringBuffer.append(stringArray[9]);
        stringBuffer.append('\n');
        stringBuffer.append("min lookahead used in an arbitrary lookahead decision ");
        stringBuffer.append(stringArray[10]);
        stringBuffer.append('\n');
        stringBuffer.append("max lookahead used in an arbitrary lookahead decision ");
        stringBuffer.append(stringArray[11]);
        stringBuffer.append('\n');
        stringBuffer.append("average lookahead depth used in arbitrary lookahead decisions ");
        stringBuffer.append(stringArray[12]);
        stringBuffer.append('\n');
        stringBuffer.append("standard deviation of depth used in arbitrary lookahead decisions ");
        stringBuffer.append(stringArray[13]);
        stringBuffer.append('\n');
        stringBuffer.append("number of evaluated semantic predicates ");
        stringBuffer.append(stringArray[14]);
        stringBuffer.append('\n');
        stringBuffer.append("number of tokens ");
        stringBuffer.append(stringArray[15]);
        stringBuffer.append('\n');
        stringBuffer.append("number of hidden tokens ");
        stringBuffer.append(stringArray[16]);
        stringBuffer.append('\n');
        stringBuffer.append("number of char ");
        stringBuffer.append(stringArray[17]);
        stringBuffer.append('\n');
        stringBuffer.append("number of hidden char ");
        stringBuffer.append(stringArray[18]);
        stringBuffer.append('\n');
        stringBuffer.append("number of syntax errors ");
        stringBuffer.append(stringArray[19]);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    protected int[] trim(int[] nArray, int n) {
        if (n < nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }
}

