/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.xml.security.utils.XMLUtils;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.Token;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UsernameToken
implements Token {
    private String username;
    private String password;
    private boolean digest;
    private String nonce;
    private String created;
    private Document doc;
    private String id;
    private Element cachedElement;

    public UsernameToken(String username, String password, Document doc, boolean digest, String nonce, String created) {
        this.username = username;
        this.password = password;
        this.doc = doc;
        this.digest = digest;
        this.nonce = nonce;
        this.created = created;
    }

    public UsernameToken(Element element) throws WSSecurityException {
        Iterator itCreated;
        Element child;
        this.doc = element.getOwnerDocument();
        String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id != null && id.length() > 0) {
            this.setId(id);
        }
        if ((child = Util.getFirstChildElement(element)) == null || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI()) || !"Username".equals(child.getLocalName())) {
            throw new WSSecurityException("Username child expected in UsernameToken element");
        }
        this.username = XMLUtils.getFullTextChildrenFromElement((Element)child);
        if ((child = Util.getNextSiblingElement(child)) == null || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI()) || !"Password".equals(child.getLocalName())) {
            throw new WSSecurityException("Password child expected in UsernameToken element");
        }
        this.password = XMLUtils.getFullTextChildrenFromElement((Element)child);
        String passwordType = child.getAttribute("Type");
        this.digest = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd#PasswordDigest".equals(passwordType);
        Iterator itNonce = DOMUtils.getChildElements((Node)element, (QName)new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Nonce"));
        if (itNonce != null && itNonce.hasNext()) {
            Element elem = (Element)itNonce.next();
            String encodingType = elem.getAttribute("EncodingType");
            if (encodingType != null && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary".equalsIgnoreCase(encodingType)) {
                throw new WSSecurityException("Unsupported nonce encoding type: " + encodingType);
            }
            this.nonce = XMLUtils.getFullTextChildrenFromElement((Element)elem);
        }
        if ((itCreated = DOMUtils.getChildElements((Node)element, (QName)new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Created"))) != null && itCreated.hasNext()) {
            this.created = XMLUtils.getFullTextChildrenFromElement((Element)((Element)itCreated.next()));
        }
    }

    public String getId() {
        if (this.id == null) {
            this.id = Util.generateId("token");
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Element getElement() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:UsernameToken");
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", this.getId());
        Element child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Username");
        child.appendChild(this.doc.createTextNode(this.username));
        element.appendChild(child);
        child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Password");
        child.appendChild(this.doc.createTextNode(this.password));
        child.setAttribute("Type", this.digest ? "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd#PasswordDigest" : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd#PasswordText");
        element.appendChild(child);
        if (this.digest) {
            if (this.nonce != null) {
                child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Nonce");
                child.appendChild(this.doc.createTextNode(this.nonce));
                child.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
                element.appendChild(child);
            }
            if (this.created != null) {
                child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Created");
                child.appendChild(this.doc.createTextNode(this.created));
                element.appendChild(child);
            }
        }
        this.cachedElement = element;
        return this.cachedElement;
    }

    public Object getUniqueContent() {
        return null;
    }

    public boolean isDigest() {
        return this.digest;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getCreated() {
        return this.created;
    }
}

