/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.Text;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.core.soap.AttrImpl;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.NodeImpl;
import org.jboss.ws.core.soap.NodeListImpl;
import org.jboss.ws.core.soap.SAAJVisitable;
import org.jboss.ws.core.soap.SAAJVisitor;
import org.jboss.ws.core.soap.TextImpl;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class SOAPElementImpl
extends NodeImpl
implements SOAPElement,
SAAJVisitable {
    private static Logger log = Logger.getLogger(SOAPElementImpl.class);
    private Element element;
    private Name elementName;

    public SOAPElementImpl(String localPart) {
        super(DOMUtils.createElement((String)localPart, null, null));
        this.element = (Element)this.domNode;
        log.trace((Object)("new SOAPElementImpl: " + this.getElementName()));
    }

    public SOAPElementImpl(String localPart, String prefix, String nsURI) {
        super(DOMUtils.createElement((String)localPart, (String)prefix, (String)nsURI));
        this.element = (Element)this.domNode;
        log.trace((Object)("new SOAPElementImpl: " + this.getElementName()));
    }

    public SOAPElementImpl(Name name) {
        this(name.getLocalName(), name.getPrefix(), name.getURI());
    }

    public SOAPElementImpl(QName qname) {
        this(qname.getLocalPart(), qname.getPrefix(), qname.getNamespaceURI());
    }

    protected SOAPElementImpl(SOAPElementImpl element) {
        super(element);
        this.element = (Element)this.domNode;
        log.trace((Object)("new SOAPElementImpl: " + this.getElementName()));
    }

    public SOAPEnvelope getSOAPEnvelope() {
        SOAPElementImpl soapElement;
        for (soapElement = this; soapElement != null && !(soapElement instanceof SOAPEnvelope); soapElement = soapElement.getParentElement()) {
        }
        return (SOAPEnvelope)soapElement;
    }

    public QName getElementQName() {
        return ((NameImpl)this.getElementName()).toQName();
    }

    public SOAPElement setElementQName(QName qname) throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equals(this.getNamespaceURI())) {
            throw new SOAPException("Changing the name of this SOAP Element is not allowed: " + this.getLocalName());
        }
        return this.setElementQNameInternal(qname);
    }

    public SOAPElement setElementQNameInternal(QName qname) throws SOAPException {
        this.elementName = new NameImpl(qname);
        Document owner = this.domNode.getOwnerDocument();
        this.domNode = owner.renameNode(this.domNode, this.elementName.getURI(), this.elementName.getQualifiedName());
        this.element = (Element)this.domNode;
        return this.completeNamespaceDeclaration();
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        if ("xml".equals(name.getPrefix())) {
            this.setAttribute(name.getQualifiedName(), value);
        } else {
            this.setAttributeNS(name.getURI(), name.getQualifiedName(), value);
        }
        return this;
    }

    public SOAPElement addAttribute(QName qname, String value) throws SOAPException {
        return this.addAttribute(new NameImpl(qname), value);
    }

    public SOAPElement addChildElement(String name) throws SOAPException {
        SOAPElementImpl soapElement = new SOAPElementImpl(name);
        soapElement = this.addChildElement(soapElement);
        return soapElement;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String nsURI = this.getNamespaceURI(prefix);
        if (nsURI == null) {
            throw new IllegalArgumentException("Cannot obtain namespace URI for prefix: " + prefix);
        }
        SOAPElementImpl soapElement = new SOAPElementImpl(localName, prefix, nsURI);
        soapElement = this.addChildElement(soapElement);
        return soapElement;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        SOAPElementImpl soapElement = new SOAPElementImpl(localName, prefix, uri);
        soapElement = this.addChildElement(soapElement);
        return soapElement;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        SOAPElementImpl soapElement = new SOAPElementImpl(name);
        soapElement = this.addChildElement(soapElement);
        return soapElement;
    }

    public SOAPElement addChildElement(QName qname) throws SOAPException {
        return this.addChildElement(new NameImpl(qname));
    }

    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        log.trace((Object)("addChildElement: " + this.getElementName() + " -> " + child.getElementName()));
        SOAPElementImpl soapElement = (SOAPElementImpl)child;
        soapElement = (SOAPElementImpl)((Object)this.appendChild((org.w3c.dom.Node)((Object)soapElement)));
        return soapElement.completeNamespaceDeclaration();
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException("Invalid 'null' namespace URI");
        }
        if (nsURI.length() == 0) {
            throw new IllegalArgumentException("Invalid empty namespace URI");
        }
        String qualifiedName = "xmlns";
        if (prefix != null && prefix.length() > 0) {
            qualifiedName = qualifiedName + ":" + prefix;
        }
        log.trace((Object)("addNamespaceDeclaration: " + qualifiedName + "='" + nsURI + "'"));
        this.element.setAttributeNS("http://www.w3.org/2000/xmlns/", qualifiedName, nsURI);
        return this;
    }

    private SOAPElement completeNamespaceDeclaration() {
        String prevNS;
        String prefix = this.getPrefix();
        String nsURI = this.getNamespaceURI();
        if (prefix != null && nsURI != null && !nsURI.equals(prevNS = this.getNamespaceURI(prefix))) {
            this.addNamespaceDeclaration(prefix, nsURI);
        }
        return this;
    }

    public SOAPElement addTextNode(String value) throws SOAPException {
        CharacterData domNode;
        log.trace((Object)("addTextNode: " + value));
        if (value.startsWith("<!--") && value.endsWith("-->")) {
            value = value.substring(4, value.length() - 3);
            domNode = this.element.getOwnerDocument().createComment(value);
        } else {
            domNode = this.element.getOwnerDocument().createTextNode(value);
        }
        TextImpl soapText = new TextImpl(domNode);
        this.appendChild((org.w3c.dom.Node)((Object)soapText));
        return this;
    }

    public Iterator getAllAttributes() {
        ArrayList<NameImpl> list = new ArrayList<NameImpl>();
        NamedNodeMap nnm = this.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            org.w3c.dom.Node node = nnm.item(i);
            String local = node.getLocalName();
            String prefix = node.getPrefix();
            String uri = node.getNamespaceURI();
            if ("xmlns".equals(prefix)) continue;
            NameImpl name = uri != null && uri.length() > 0 ? new NameImpl(local, prefix, uri) : new NameImpl(local);
            list.add(name);
        }
        return list.iterator();
    }

    public Iterator getAllAttributesAsQNames() {
        ArrayList<QName> list = new ArrayList<QName>();
        NamedNodeMap nnm = this.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            org.w3c.dom.Node node = nnm.item(i);
            String local = node.getLocalName();
            String prefix = node.getPrefix();
            String uri = node.getNamespaceURI();
            if ("xmlns".equals(prefix)) continue;
            QName qname = uri != null && uri.length() > 0 ? new QName(uri, local, prefix) : new QName(local);
            list.add(qname);
        }
        return list.iterator();
    }

    public String getAttributeValue(Name name) {
        Attr attr = this.getAttributeNode(name);
        return attr != null ? attr.getValue() : null;
    }

    public String getAttributeValue(QName qname) {
        return this.getAttributeValue(new NameImpl(qname));
    }

    private Attr getAttributeNode(Name name) {
        Attr attr = null;
        String nsURI = name.getURI();
        attr = nsURI.length() > 0 ? this.element.getAttributeNodeNS(nsURI, name.getLocalName()) : this.element.getAttributeNode(name.getLocalName());
        return attr;
    }

    public QName createQName(String localName, String prefix) throws SOAPException {
        String nsURI = this.getNamespaceURI(prefix);
        if (nsURI == null) {
            throw new SOAPException("CAnnot obtain namespace URI for prefix: " + prefix);
        }
        return new QName(nsURI, localName, prefix);
    }

    public Iterator getChildElements() {
        ArrayList<org.w3c.dom.Node> list = new ArrayList<org.w3c.dom.Node>();
        NodeList nodeList = this.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node = nodeList.item(i);
            if (node instanceof SOAPElement) {
                list.add(node);
                continue;
            }
            if (!(node instanceof Text)) continue;
            list.add(node);
        }
        return list.iterator();
    }

    public Iterator getChildElements(Name name) {
        return this.getChildElements(((NameImpl)name).toQName());
    }

    public Iterator getChildElements(QName qname) {
        ArrayList<SOAPElement> list = new ArrayList<SOAPElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPElement el;
            Object elementOrTextNode = it.next();
            if (!(elementOrTextNode instanceof SOAPElement) || !(el = (SOAPElement)elementOrTextNode).getElementQName().equals(qname)) continue;
            list.add(el);
        }
        return list.iterator();
    }

    public Name getElementName() {
        if (this.elementName == null) {
            String nsURI = this.element.getNamespaceURI();
            if (nsURI != null && nsURI.length() > 0) {
                String prefix = this.element.getPrefix();
                String localName = this.element.getLocalName();
                this.elementName = new NameImpl(localName, prefix, nsURI);
            } else {
                String nodeName = this.element.getNodeName();
                this.elementName = new NameImpl(nodeName);
            }
        }
        return this.elementName;
    }

    public Iterator getNamespacePrefixes() {
        ArrayList list = this.getNamespacePrefixList();
        return list.iterator();
    }

    private ArrayList getNamespacePrefixList() {
        ArrayList<String> list = new ArrayList<String>();
        NamedNodeMap attrMap = this.element.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Attr attr = (Attr)attrMap.item(i);
            String attrName = attr.getNodeName();
            if (!attrName.startsWith("xmlns:")) continue;
            list.add(attrName.substring(6));
        }
        return list;
    }

    public String getNamespaceURI(String prefix) {
        String nsURI = this.element.getAttribute("xmlns:" + prefix);
        if (nsURI.length() == 0 && this.getParentElement() != null) {
            return this.getParentElement().getNamespaceURI(prefix);
        }
        return nsURI.length() > 0 ? nsURI : null;
    }

    public Iterator getVisibleNamespacePrefixes() {
        ArrayList list = this.getNamespacePrefixList();
        for (SOAPElementImpl parent = (SOAPElementImpl)this.getParentElement(); parent != null; parent = (SOAPElementImpl)parent.getParentElement()) {
            list.addAll(parent.getNamespacePrefixList());
        }
        return list.iterator();
    }

    public boolean removeAttribute(Name name) {
        Attr attr = this.getAttributeNode(name);
        if (attr != null) {
            this.element.removeAttributeNode(attr);
            return true;
        }
        return false;
    }

    public boolean removeAttribute(QName qname) {
        return this.removeAttribute(new NameImpl(qname));
    }

    public void removeContents() {
        log.trace((Object)"removeContents");
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Node el = (Node)it.next();
            el.detachNode();
        }
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        boolean ret = this.getAttributeNode("xmlns:" + prefix) != null;
        this.removeAttribute("xmlns:" + prefix);
        return ret;
    }

    public String getEncodingStyle() {
        String encodingStyle = this.getAttribute("env:encodingStyle");
        return encodingStyle.length() > 0 ? encodingStyle : null;
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        String namespaceURI = this.getNamespaceURI("env");
        NameImpl name = new NameImpl("encodingStyle", "env", namespaceURI);
        this.addAttribute(name, encodingStyle);
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public void removeAttribute(String name) throws DOMException {
        this.element.removeAttribute(name);
    }

    public boolean hasAttribute(String name) {
        return this.element.hasAttribute(name);
    }

    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.element.removeAttributeNS(namespaceURI, localName);
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.element.setAttribute(name, value);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.element.hasAttributeNS(namespaceURI, localName);
    }

    public Attr getAttributeNode(String name) {
        Attr attr = this.element.getAttributeNode(name);
        return attr == null ? null : new AttrImpl(this, attr);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return this.element.removeAttributeNode(oldAttr);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return this.element.setAttributeNode(newAttr);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.element.setAttributeNodeNS(newAttr);
    }

    public NodeList getElementsByTagName(String name) {
        Iterator nodes = DOMUtils.getChildElements((org.w3c.dom.Node)((Object)this), (QName)null, (boolean)true);
        LinkedList<Element> filtered = new LinkedList<Element>();
        while (nodes.hasNext()) {
            Element current = (Element)nodes.next();
            if (!current.getTagName().equals(name)) continue;
            filtered.add(current);
        }
        return new NodeListImpl(filtered.iterator());
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return this.element.getAttributeNS(namespaceURI, localName);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.element.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        Attr attr = this.element.getAttributeNodeNS(namespaceURI, localName);
        return attr == null ? null : new AttrImpl(this, attr);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        Iterator nodes = DOMUtils.getChildElements((org.w3c.dom.Node)((Object)this), (QName)null, (boolean)true);
        LinkedList<Element> filtered = new LinkedList<Element>();
        while (nodes.hasNext()) {
            Element current = (Element)nodes.next();
            boolean namespaceMatch = false;
            boolean localNameMatch = false;
            if ("*".equals(namespaceURI) || namespaceURI != null && namespaceURI.equals(current.getNamespaceURI())) {
                namespaceMatch = true;
            }
            if ("*".equals(localName) || localName != null && localName.equals(current.getLocalName())) {
                localNameMatch = true;
            }
            if (!namespaceMatch || !localNameMatch) continue;
            filtered.add(current);
        }
        return new NodeListImpl(filtered.iterator());
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new NotImplementedException("getSchemaTypeInfo");
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new NotImplementedException("setIdAttribute");
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new NotImplementedException("setIdAttributeNode");
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new NotImplementedException("setIdAttributeNS");
    }

    public void accept(SAAJVisitor visitor) {
        visitor.visitSOAPElement(this);
    }

    public void setPrefix(String prefix) throws DOMException {
        super.setPrefix(prefix);
        this.elementName = null;
    }

    public void writeElement(Writer writer) throws IOException {
        String qualName = this.getElementName().getQualifiedName();
        writer.write("<" + qualName);
        Iterator nsPrefixes = this.getNamespacePrefixes();
        while (nsPrefixes.hasNext()) {
            String prefix = (String)nsPrefixes.next();
            writer.write(" xmlns:" + prefix + "='" + this.getNamespaceURI(prefix) + "'");
        }
        Iterator attNames = this.getAllAttributes();
        while (attNames.hasNext()) {
            NameImpl name = (NameImpl)attNames.next();
            String attPrefix = name.getPrefix() != null ? name.getPrefix() : "";
            String attFqn = attPrefix.length() > 0 ? attPrefix + ":" + name.getLocalName() : name.getLocalName();
            writer.write(" " + attFqn + "='" + this.getAttributeValue(name) + "'");
        }
        writer.write(">");
        this.writeElementContent(writer);
        writer.write("</" + qualName + ">");
    }

    protected void writeElementContent(Writer out) throws IOException {
        Iterator it = this.getChildElements();
        if (it.hasNext()) {
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (node instanceof SOAPElementImpl) {
                    ((SOAPElementImpl)node).writeElement(out);
                    continue;
                }
                if (node instanceof TextImpl) {
                    ((TextImpl)node).writeNode(out);
                    continue;
                }
                throw new WSException("Unhandled soap node: " + node.getClass().getName());
            }
        } else {
            String value = this.getValue();
            if (value != null) {
                out.write(value);
            }
        }
    }
}

