/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.handler;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxws.handler.GenericHandler;
import org.jboss.ws.core.jaxws.handler.GenericSOAPHandler;
import org.jboss.ws.metadata.umdm.EndpointConfigMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerResolverImpl
implements HandlerResolver {
    private static Logger log = Logger.getLogger(HandlerResolverImpl.class);
    private static final Map<String, String> protocolMap = new HashMap<String, String>();
    private final List<ScopedHandler> preHandlers;
    private final List<ScopedHandler> jaxwsHandlers;
    private final List<ScopedHandler> postHandlers;
    private final Set<QName> headers;

    public HandlerResolverImpl() {
        this.preHandlers = new ArrayList<ScopedHandler>();
        this.jaxwsHandlers = new ArrayList<ScopedHandler>();
        this.postHandlers = new ArrayList<ScopedHandler>();
        this.headers = new HashSet<QName>();
    }

    public HandlerResolverImpl(HandlerResolverImpl parent) {
        this.preHandlers = new ArrayList<ScopedHandler>(parent.preHandlers);
        this.jaxwsHandlers = new ArrayList<ScopedHandler>(parent.jaxwsHandlers);
        this.postHandlers = new ArrayList<ScopedHandler>(parent.postHandlers);
        this.headers = new HashSet<QName>(parent.headers);
    }

    public Set<QName> getHeaders() {
        return this.headers;
    }

    public List<Handler> getHandlerChain(PortInfo info) {
        return this.getHandlerChain(info, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
    }

    public List<Handler> getHandlerChain(PortInfo info, UnifiedHandlerMetaData.HandlerType type) {
        log.debug((Object)("getHandlerChain: [type=" + type + ",info=" + info + "]"));
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        for (ScopedHandler scopedHandler : this.getHandlerMap(type)) {
            if (!scopedHandler.matches(info)) continue;
            handlers.add(scopedHandler.handler);
        }
        return handlers;
    }

    public void initServiceHandlerChain(ServiceMetaData serviceMetaData) {
        log.debug((Object)("initServiceHandlerChain: " + serviceMetaData.getServiceName()));
        List<ScopedHandler> handlerMap = this.getHandlerMap(UnifiedHandlerMetaData.HandlerType.ENDPOINT);
        handlerMap.clear();
        ClassLoader classLoader = serviceMetaData.getUnifiedMetaData().getClassLoader();
        for (HandlerMetaDataJAXWS handlerMetaData : serviceMetaData.getHandlerMetaData()) {
            this.addHandler(classLoader, UnifiedHandlerMetaData.HandlerType.ENDPOINT, handlerMetaData);
        }
    }

    public void initHandlerChain(EndpointConfigMetaData epConfigMetaData, UnifiedHandlerMetaData.HandlerType type, boolean clearExistingHandlers) {
        log.debug((Object)("initHandlerChain: " + type));
        List<ScopedHandler> handlerMap = this.getHandlerMap(type);
        if (clearExistingHandlers) {
            handlerMap.clear();
        }
        ClassLoader classLoader = epConfigMetaData.getEndpointMetaData().getClassLoader();
        for (HandlerMetaData handlerMetaData : epConfigMetaData.getHandlerMetaData(type)) {
            this.addHandler(classLoader, type, handlerMetaData);
        }
    }

    private void addHandler(ClassLoader classLoader, UnifiedHandlerMetaData.HandlerType type, HandlerMetaData handlerMetaData) {
        HandlerMetaDataJAXWS jaxwsMetaData = (HandlerMetaDataJAXWS)handlerMetaData;
        String handlerName = jaxwsMetaData.getHandlerName();
        String className = jaxwsMetaData.getHandlerClassName();
        Set<QName> soapHeaders = jaxwsMetaData.getSoapHeaders();
        try {
            Class<?> hClass = classLoader.loadClass(className);
            Handler handler = (Handler)hClass.newInstance();
            if (handler instanceof GenericHandler) {
                ((GenericHandler)handler).setHandlerName(handlerName);
            }
            if (handler instanceof GenericSOAPHandler) {
                ((GenericSOAPHandler)handler).setHeaders(soapHeaders);
            }
            this.injectResources(handler);
            this.callPostConstruct(handler);
            this.addHandler(jaxwsMetaData, handler, type);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot load handler: " + className, ex);
        }
    }

    private void injectResources(Handler handler) {
        Class<?> handlerClass = handler.getClass();
        for (Field field : handlerClass.getFields()) {
            if (!field.isAnnotationPresent(Resource.class)) continue;
            throw new NotImplementedException("@Resource not implemented for handler: " + handlerClass.getName());
        }
        for (AccessibleObject accessibleObject : handlerClass.getMethods()) {
            if (!accessibleObject.isAnnotationPresent(Resource.class)) continue;
            throw new NotImplementedException("@Resource not implemented for handler: " + handlerClass.getName());
        }
    }

    private void callPostConstruct(Handler handler) throws Exception {
        Class<?> handlerClass = handler.getClass();
        for (Method method : handlerClass.getMethods()) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            method.invoke((Object)handler, new Object[0]);
        }
    }

    private boolean addHandler(HandlerMetaDataJAXWS hmd, Handler handler, UnifiedHandlerMetaData.HandlerType type) {
        Set handlerHeaders;
        log.debug((Object)("addHandler: " + hmd));
        List<ScopedHandler> handlerMap = this.getHandlerMap(type);
        ScopedHandler scopedHandler = new ScopedHandler(handler);
        scopedHandler.servicePattern = hmd.getServiceNamePattern();
        scopedHandler.portPattern = hmd.getPortNamePattern();
        scopedHandler.protocols = hmd.getProtocolBindings();
        handlerMap.add(scopedHandler);
        if (handler instanceof SOAPHandler && (handlerHeaders = ((SOAPHandler)handler).getHeaders()) != null) {
            this.headers.addAll(handlerHeaders);
        }
        return true;
    }

    private List<ScopedHandler> getHandlerMap(UnifiedHandlerMetaData.HandlerType type) {
        List<ScopedHandler> handlers = null;
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            handlers = this.preHandlers;
        } else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
            handlers = this.jaxwsHandlers;
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            handlers = this.postHandlers;
        } else {
            throw new IllegalArgumentException("Illegal handler type: " + type);
        }
        return handlers;
    }

    static {
        protocolMap.put("##SOAP11_HTTP", "http://schemas.xmlsoap.org/wsdl/soap/http");
        protocolMap.put("##SOAP11_HTTP_MTOM", "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        protocolMap.put("##SOAP12_HTTP", "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        protocolMap.put("##SOAP12_HTTP_MTOM", "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        protocolMap.put("##XML_HTTP", "http://www.w3.org/2004/08/wsdl/http");
    }

    private class ScopedHandler {
        Handler handler;
        QName servicePattern;
        QName portPattern;
        String protocols;
        Set<String> bindings;

        ScopedHandler(Handler handler) {
            this.handler = handler;
        }

        boolean matches(PortInfo info) {
            boolean match = true;
            if (this.servicePattern != null) {
                QName serviceName = info.getServiceName();
                match = this.matchQNamePattern(this.servicePattern, serviceName);
            }
            if (match && this.portPattern != null) {
                QName portName = info.getPortName();
                match = this.matchQNamePattern(this.portPattern, portName);
            }
            if (match && this.protocols != null) {
                boolean bindingMatch = false;
                String bindingID = info.getBindingID();
                for (String protocol : this.protocols.split("\\s")) {
                    String aux = (String)protocolMap.get(protocol);
                    if (aux == null || !aux.equals(bindingID)) continue;
                    bindingMatch = true;
                    break;
                }
                match = bindingMatch;
            }
            return match;
        }

        boolean matchQNamePattern(QName pattern, QName qname) {
            boolean match = true;
            String nsURI = pattern.getNamespaceURI();
            String localPart = pattern.getLocalPart();
            if (!localPart.equals("*")) {
                if (localPart.endsWith("*")) {
                    localPart = localPart.substring(0, localPart.length() - 1);
                }
                String qnameStr = qname.toString();
                String patternStr = new QName(nsURI, localPart).toString();
                match = qnameStr.startsWith(patternStr);
            }
            return match;
        }
    }
}

