/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.crypto;

import com.pointbase.crypto.cryptoBlockCipher;
import com.pointbase.crypto.cryptoCbcBlockCipher;
import com.pointbase.crypto.cryptoCipher;
import com.pointbase.crypto.cryptoStreamCipher;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class cryptoEncryptedInputStream
extends FilterInputStream {
    private cryptoBlockCipher m_blockCipher = null;
    private cryptoStreamCipher m_streamCipher = null;
    private cryptoCipher m_cipher;
    private cryptoCbcBlockCipher m_cbcBlockCipher = null;
    private int m_blockSize;
    private int m_cryptoSize;
    private byte[] m_cipherText;
    private byte[] m_clearText;
    private int m_byteCount;
    private int m_bytesRead;
    private boolean inited = false;
    private boolean m_decrypting = true;

    public cryptoEncryptedInputStream(cryptoBlockCipher cryptoBlockCipher2, InputStream inputStream) {
        super(inputStream);
        this.m_blockCipher = cryptoBlockCipher2;
        this.m_blockSize = this.m_blockCipher.blockSize();
        this.m_cbcBlockCipher = new cryptoCbcBlockCipher(this.m_blockCipher);
        this.m_cryptoSize = this.m_blockSize;
        this.m_cipherText = new byte[this.m_blockSize];
        this.m_clearText = new byte[this.m_blockSize];
        this.m_byteCount = 0;
        this.m_bytesRead = 0;
        this.m_cipher = this.m_blockCipher;
    }

    public cryptoEncryptedInputStream(cryptoStreamCipher cryptoStreamCipher2, InputStream inputStream) {
        super(inputStream);
        this.m_streamCipher = cryptoStreamCipher2;
        this.m_cipher = cryptoStreamCipher2;
    }

    private void init() throws IOException {
        if (!this.inited && this.m_blockCipher != null) {
            this.inited = true;
            byte[] byArray = new byte[this.m_blockSize];
            int n = this.read(this.in, byArray, 0, this.m_blockSize);
            if (n == -1 || n != this.m_blockSize) {
                throw new IOException("truncated initialization vector");
            }
            this.m_cbcBlockCipher.setIv(byArray);
        }
    }

    public void setKey(String string) {
        this.m_cipher.setKey(string);
    }

    public void setDecrypting(boolean bl) throws IOException {
        this.m_decrypting = bl;
    }

    private int getBlock() throws IOException {
        int n = this.read(this.in, this.m_cipherText, 0, this.m_blockSize);
        if (n == -1) {
            return -1;
        }
        if (n != this.m_blockSize) {
            throw new IOException("truncated m_ciphertext block");
        }
        this.m_cbcBlockCipher.decrypt(this.m_cipherText, 0, this.m_clearText, 0);
        this.m_byteCount = this.in.read();
        if (this.m_byteCount == -1) {
            throw new IOException("missing m_ciphertext bytecount");
        }
        if (this.m_byteCount == 0 || this.m_byteCount > this.m_cryptoSize) {
            throw new IOException("invalid m_ciphertext bytecount");
        }
        this.m_bytesRead = 0;
        return this.m_byteCount;
    }

    public int read() throws IOException {
        this.init();
        if (this.m_decrypting) {
            if (this.m_blockCipher != null) {
                if (this.m_bytesRead >= this.m_byteCount && this.getBlock() == -1) {
                    return -1;
                }
                return this.m_clearText[this.m_bytesRead++] & 0xFF;
            }
            int n = this.in.read();
            if (n == -1) {
                return -1;
            }
            return (byte)(this.m_streamCipher.decrypt((byte)n) & 0xFF);
        }
        return this.in.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.init();
        if (this.m_decrypting) {
            if (this.m_blockCipher != null) {
                return this.read(this, byArray, n, n2);
            }
            byte[] byArray2 = new byte[n2];
            int n3 = this.read(this.in, byArray2, 0, n2);
            if (n3 == -1) {
                return -1;
            }
            this.m_streamCipher.decrypt(byArray2, 0, byArray, n, n3);
            return n3;
        }
        return this.read(this.in, byArray, n, n2);
    }

    public int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = inputStream.read();
        if (n3 == -1) {
            return -1;
        }
        if (byArray != null) {
            byArray[n] = (byte)n3;
        }
        int n4 = 1;
        while (n4 < n2) {
            n3 = inputStream.read();
            if (n3 == -1) break;
            if (byArray != null) {
                byArray[n + n4] = (byte)n3;
            }
            ++n4;
        }
        return n4;
    }
}

