/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.collxn;

import com.pointbase.collxn.collxnIntToIntHashtableEnum;

public class collxnIntToIntHashtable {
    public static int NOT_FOUND = Integer.MAX_VALUE;
    private static int SEARCH_LIMIT = 12;
    private int[] m_HashArray = null;
    private int m_NumberOfElements = 0;
    private int m_NumberOfPrimarySlots = 0;
    private int m_OldValue = 0;
    private int m_OverflowSize = 0;
    private int m_PrimeIndex = 0;
    private int m_ValueStart = 0;
    private static int[] m_PrimeTable = new int[]{11, 17, 23, 31, 41, 59, 79, 107, 149, 199, 269, 359, 479, 641, 857, 1151, 1543, 2063, 2753, 3671, 4903, 6547, 8731, 11657};

    public collxnIntToIntHashtable() {
        this(11);
    }

    public collxnIntToIntHashtable(int n) {
        int n2 = 0;
        while (true) {
            if (n2 >= m_PrimeTable.length) {
                this.m_NumberOfPrimarySlots = n % 2 == 0 ? n + 1 : n;
                break;
            }
            if (m_PrimeTable[n2] >= n) {
                this.m_NumberOfPrimarySlots = m_PrimeTable[n2];
                ++n2;
                break;
            }
            ++n2;
        }
        this.m_OverflowSize = this.m_NumberOfPrimarySlots / 5;
        if (this.m_OverflowSize % 2 == 0) {
            ++this.m_OverflowSize;
        }
        this.m_ValueStart = this.m_NumberOfPrimarySlots + this.m_OverflowSize;
        this.m_HashArray = new int[this.m_ValueStart * 2];
        int n3 = 0;
        while (n3 < this.m_HashArray.length) {
            this.m_HashArray[n3] = NOT_FOUND;
            ++n3;
        }
    }

    public int capacity() {
        return this.m_NumberOfPrimarySlots;
    }

    public int get(int n) {
        int n2 = this.findKeyIndex(n);
        int n3 = n2 == -1 ? NOT_FOUND : this.m_HashArray[n2 + this.m_ValueStart];
        return n3;
    }

    public int put(int n, int n2) {
        this.put(n, n2, true);
        return this.m_OldValue;
    }

    private boolean put(int n, int n2, boolean bl) {
        int n3 = this.findKeyIndex(n);
        if (n3 == -1) {
            while (this.m_HashArray[n3 = this.getHashKey(n)] != NOT_FOUND) {
                int n4 = this.getOverflowHashKey(n);
                int n5 = 0;
                while (n5 < SEARCH_LIMIT && n5 < this.m_OverflowSize && this.m_HashArray[(n4 + n5) % this.m_OverflowSize + this.m_NumberOfPrimarySlots] != NOT_FOUND) {
                    ++n5;
                }
                if (n5 < SEARCH_LIMIT && n5 < this.m_OverflowSize) {
                    n3 = (n4 + n5) % this.m_OverflowSize + this.m_NumberOfPrimarySlots;
                    break;
                }
                if (bl) {
                    this.rehash();
                    continue;
                }
                return false;
            }
        }
        this.m_OldValue = this.m_HashArray[n3 + this.m_ValueStart];
        if (this.m_OldValue == NOT_FOUND) {
            ++this.m_NumberOfElements;
        }
        this.m_HashArray[n3] = n;
        this.m_HashArray[n3 + this.m_ValueStart] = n2;
        return true;
    }

    public int remove(int n) {
        int n2 = this.findKeyIndex(n);
        if (n2 != -1) {
            int n3 = this.m_HashArray[n2 + this.m_ValueStart];
            this.m_HashArray[n2] = NOT_FOUND;
            this.m_HashArray[n2 + this.m_ValueStart] = NOT_FOUND;
            --this.m_NumberOfElements;
            return n3;
        }
        return NOT_FOUND;
    }

    public int size() {
        return this.m_NumberOfElements;
    }

    int[] getHashArray() {
        return this.m_HashArray;
    }

    public int getNumberOfPrimarySlots() {
        return this.m_NumberOfPrimarySlots;
    }

    int getOverflowSize() {
        return this.m_OverflowSize;
    }

    private int findKeyIndex(int n) {
        int n2 = this.getHashKey(n);
        if (this.m_HashArray[n2] == n) {
            return n2;
        }
        int n3 = this.getOverflowHashKey(n);
        int n4 = 0;
        n4 = 0;
        while (n4 < SEARCH_LIMIT) {
            int n5 = (n3 + n4) % this.m_OverflowSize + this.m_NumberOfPrimarySlots;
            if (this.m_HashArray[n5] == n) {
                return n5;
            }
            ++n4;
        }
        return -1;
    }

    private int getHashKey(int n) {
        return Math.abs(n) % this.m_NumberOfPrimarySlots;
    }

    private int getOverflowHashKey(int n) {
        return Math.abs(n) % this.m_OverflowSize;
    }

    public collxnIntToIntHashtableEnum keys() {
        return new collxnIntToIntHashtableEnum(this.m_HashArray, this.m_NumberOfPrimarySlots + this.m_OverflowSize);
    }

    private void rehash() {
        collxnIntToIntHashtable collxnIntToIntHashtable2 = null;
        int n = this.m_NumberOfPrimarySlots;
        boolean bl = false;
        while (!bl) {
            if (this.m_PrimeIndex >= m_PrimeTable.length) {
                n += n / 3;
            } else {
                n = m_PrimeTable[this.m_PrimeIndex];
                ++this.m_PrimeIndex;
            }
            collxnIntToIntHashtable2 = new collxnIntToIntHashtable(n);
            bl = true;
            collxnIntToIntHashtableEnum collxnIntToIntHashtableEnum2 = this.keys();
            while (bl && collxnIntToIntHashtableEnum2.hasMoreElements()) {
                int n2 = collxnIntToIntHashtableEnum2.nextElement();
                int n3 = this.get(n2);
                bl = collxnIntToIntHashtable2.put(n2, n3, false);
            }
        }
        this.m_HashArray = collxnIntToIntHashtable2.getHashArray();
        this.m_NumberOfPrimarySlots = collxnIntToIntHashtable2.getNumberOfPrimarySlots();
        this.m_OverflowSize = collxnIntToIntHashtable2.getOverflowSize();
        this.m_ValueStart = this.m_NumberOfPrimarySlots + this.m_OverflowSize;
    }
}

