/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RuleBaseConfiguration;
import org.drools.StatefulSession;
import org.drools.StatelessSession;
import org.drools.common.AbstractRuleBase;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.concurrent.CommandExecutor;
import org.drools.concurrent.ExecutorService;
import org.drools.event.RuleBaseEventListener;
import org.drools.reteoo.InitialFactHandle;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooFactHandleFactory;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.reteoo.ReteooStatelessSession;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Rule;
import org.drools.spi.ExecutorServiceFactory;
import org.drools.spi.FactHandleFactory;
import org.drools.spi.PropagationContext;

public class ReteooRuleBase
extends AbstractRuleBase {
    private static final long serialVersionUID = 400L;
    private Rete rete;
    private ReteooBuilder reteooBuilder;

    public ReteooRuleBase() {
    }

    public ReteooRuleBase(String id) {
        this(id, null, new ReteooFactHandleFactory());
    }

    public ReteooRuleBase(String id, FactHandleFactory factHandleFactory) {
        this(id, null, factHandleFactory);
    }

    public ReteooRuleBase(String id, RuleBaseConfiguration config) {
        this(id, config, new ReteooFactHandleFactory());
    }

    public ReteooRuleBase(RuleBaseConfiguration config) {
        this(null, config, new ReteooFactHandleFactory());
    }

    public ReteooRuleBase(String id, RuleBaseConfiguration config, FactHandleFactory factHandleFactory) {
        super(id, config, factHandleFactory);
        this.rete = new Rete(this);
        this.reteooBuilder = new ReteooBuilder(this);
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        Object[] objects = new Object[]{this.rete, this.reteooBuilder};
        this.doWriteExternal(stream, objects);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        Object[] objects = new Object[2];
        this.doReadExternal(stream, objects);
        this.rete = (Rete)objects[0];
        this.reteooBuilder = (ReteooBuilder)objects[1];
    }

    public Rete getRete() {
        return this.rete;
    }

    public ReteooBuilder getReteooBuilder() {
        return this.reteooBuilder;
    }

    public void assertObject(FactHandle handle, Object object, PropagationContext context, InternalWorkingMemory workingMemory) throws FactException {
        this.getRete().assertObject((DefaultFactHandle)handle, context, workingMemory);
    }

    public void retractObject(FactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) throws FactException {
        this.getRete().retractObject((InternalFactHandle)handle, context, workingMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulSession newStatefulSession(boolean keepReference) {
        if (this.config.isSequential()) {
            throw new RuntimeException("Cannot have a stateful rule session, with sequential configuration set to true");
        }
        ReteooStatefulSession session = null;
        Map map = this.pkgs;
        synchronized (map) {
            ExecutorService executor = ExecutorServiceFactory.createExecutorService(this.config.getExecutorService());
            session = new ReteooStatefulSession(this.nextWorkingMemoryCounter(), (InternalRuleBase)this, executor);
            executor.setCommandExecutor(new CommandExecutor(session));
            if (keepReference) {
                super.addStatefulSession(session);
                Iterator it = session.getRuleBaseUpdateListeners().iterator();
                while (it.hasNext()) {
                    this.addEventListener((RuleBaseEventListener)it.next());
                }
            }
            InitialFactHandle handle = new InitialFactHandle(session.getFactHandleFactory().newFactHandle(new InitialFactHandleDummyObject()));
            session.queueWorkingMemoryAction(new ReteooWorkingMemory.WorkingMemoryReteAssertAction(handle, false, true, null, null));
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatelessSession newStatelessSession() {
        if (this.config.isSequential()) {
            this.reteooBuilder.order();
        }
        Map map = this.pkgs;
        synchronized (map) {
            return new ReteooStatelessSession(this);
        }
    }

    protected synchronized void addRule(Rule rule) throws InvalidPatternException {
        this.reteooBuilder.addRule(rule);
    }

    protected synchronized void removeRule(Rule rule) {
        this.reteooBuilder.removeRule(rule);
    }

    public static class InitialFactHandleDummyObject
    implements Serializable {
        private static final long serialVersionUID = 400L;
    }
}

