/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import [Ljava.lang.Object;;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import org.drools.RuntimeDroolsException;
import org.drools.base.evaluators.ArrayFactory;
import org.drools.base.evaluators.BigDecimalFactory;
import org.drools.base.evaluators.BigIntegerFactory;
import org.drools.base.evaluators.BooleanFactory;
import org.drools.base.evaluators.ByteFactory;
import org.drools.base.evaluators.CharacterFactory;
import org.drools.base.evaluators.DateFactory;
import org.drools.base.evaluators.DoubleFactory;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.FloatFactory;
import org.drools.base.evaluators.IntegerFactory;
import org.drools.base.evaluators.LongFactory;
import org.drools.base.evaluators.ObjectFactory;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.ShortFactory;
import org.drools.base.evaluators.StringFactory;
import org.drools.facttemplates.FactTemplate;
import org.drools.spi.Evaluator;

public class ValueType
implements Serializable {
    private static final long serialVersionUID = 400L;
    public static final ValueType NULL_TYPE = new ValueType("null", null, 1, null);
    public static final ValueType CHAR_TYPE = new ValueType("Character", Character.class, 6, CharacterFactory.getInstance());
    public static final ValueType BYTE_TYPE = new ValueType("Byte", Byte.class, 4, ByteFactory.getInstance());
    public static final ValueType SHORT_TYPE = new ValueType("Short", Short.class, 4, ShortFactory.getInstance());
    public static final ValueType INTEGER_TYPE = new ValueType("Integer", Integer.class, 4, IntegerFactory.getInstance());
    public static final ValueType LONG_TYPE = new ValueType("Long", Long.class, 4, LongFactory.getInstance());
    public static final ValueType FLOAT_TYPE = new ValueType("Float", Float.class, 5, FloatFactory.getInstance());
    public static final ValueType DOUBLE_TYPE = new ValueType("Double", Double.class, 5, DoubleFactory.getInstance());
    public static final ValueType BOOLEAN_TYPE = new ValueType("Boolean", Boolean.class, 2, BooleanFactory.getInstance());
    public static final ValueType PCHAR_TYPE = new ValueType("char", Character.TYPE, 6, CharacterFactory.getInstance());
    public static final ValueType PBYTE_TYPE = new ValueType("byte", Byte.TYPE, 4, ByteFactory.getInstance());
    public static final ValueType PSHORT_TYPE = new ValueType("short", Short.TYPE, 4, ShortFactory.getInstance());
    public static final ValueType PINTEGER_TYPE = new ValueType("int", Integer.TYPE, 4, IntegerFactory.getInstance());
    public static final ValueType PLONG_TYPE = new ValueType("long", Long.TYPE, 4, LongFactory.getInstance());
    public static final ValueType PFLOAT_TYPE = new ValueType("float", Float.TYPE, 5, FloatFactory.getInstance());
    public static final ValueType PDOUBLE_TYPE = new ValueType("double", Double.TYPE, 5, DoubleFactory.getInstance());
    public static final ValueType PBOOLEAN_TYPE = new ValueType("boolean", Boolean.TYPE, 2, BooleanFactory.getInstance());
    public static final ValueType DATE_TYPE = new ValueType("Date", java.util.Date.class, 8, DateFactory.getInstance());
    public static final ValueType ARRAY_TYPE = new ValueType("Array", Object;.class, 9, ArrayFactory.getInstance());
    public static final ValueType STRING_TYPE = new ValueType("String", String.class, 7, StringFactory.getInstance());
    public static final ValueType OBJECT_TYPE = new ValueType("Object", Object.class, 10, ObjectFactory.getInstance());
    public static final ValueType FACTTEMPLATE_TYPE = new ValueType("FactTemplate", FactTemplate.class, 0, ObjectFactory.getInstance());
    public static final ValueType BIG_DECIMAL_TYPE = new ValueType("BigDecimal", BigDecimal.class, 10, BigDecimalFactory.getInstance());
    public static final ValueType BIG_INTEGER_TYPE = new ValueType("BigInteger", BigInteger.class, 10, BigIntegerFactory.getInstance());
    private final String name;
    private final Class classType;
    private final EvaluatorFactory evaluatorFactory;
    private final int simpleType;

    private ValueType(String name, Class classType, int simpleType, EvaluatorFactory evaluatorFactory) {
        this.name = name;
        this.classType = classType;
        this.simpleType = simpleType;
        this.evaluatorFactory = evaluatorFactory;
    }

    private Object readResolve() throws ObjectStreamException {
        return ValueType.determineValueType(this.classType);
    }

    public String getName() {
        return this.name;
    }

    public Class getClassType() {
        return this.classType;
    }

    public int getSimpleType() {
        return this.simpleType;
    }

    public Evaluator getEvaluator(Operator operator) {
        return this.evaluatorFactory.getEvaluator(operator);
    }

    public static ValueType determineValueType(Class clazz) {
        if (clazz == null) {
            return NULL_TYPE;
        }
        if (clazz == FactTemplate.class) {
            return FACTTEMPLATE_TYPE;
        }
        if (clazz == Character.TYPE) {
            return PCHAR_TYPE;
        }
        if (clazz == Byte.TYPE) {
            return PBYTE_TYPE;
        }
        if (clazz == Short.TYPE) {
            return PSHORT_TYPE;
        }
        if (clazz == Integer.TYPE) {
            return PINTEGER_TYPE;
        }
        if (clazz == Long.TYPE) {
            return PLONG_TYPE;
        }
        if (clazz == Float.TYPE) {
            return PFLOAT_TYPE;
        }
        if (clazz == Double.TYPE) {
            return PDOUBLE_TYPE;
        }
        if (clazz == Boolean.TYPE) {
            return PBOOLEAN_TYPE;
        }
        if (clazz == Character.class) {
            return CHAR_TYPE;
        }
        if (clazz == Byte.class) {
            return BYTE_TYPE;
        }
        if (clazz == Short.class) {
            return SHORT_TYPE;
        }
        if (clazz == Integer.class) {
            return INTEGER_TYPE;
        }
        if (clazz == Long.class) {
            return LONG_TYPE;
        }
        if (clazz == Float.class) {
            return FLOAT_TYPE;
        }
        if (clazz == Double.class) {
            return DOUBLE_TYPE;
        }
        if (clazz == Boolean.class) {
            return BOOLEAN_TYPE;
        }
        if (clazz == Date.class) {
            return DATE_TYPE;
        }
        if (clazz == java.util.Date.class) {
            return DATE_TYPE;
        }
        if (clazz.isArray()) {
            return ARRAY_TYPE;
        }
        if (clazz == BigDecimal.class) {
            return BIG_DECIMAL_TYPE;
        }
        if (clazz == BigInteger.class) {
            return BIG_INTEGER_TYPE;
        }
        if (clazz == String.class) {
            return STRING_TYPE;
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return OBJECT_TYPE;
        }
        throw new RuntimeDroolsException("unable to determine ValueType for Class [" + clazz + "]");
    }

    public String toString() {
        return "ValueType = '" + this.name + "'";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public boolean isBoolean() {
        return this.classType == Boolean.class || this.classType == Boolean.TYPE;
    }

    public boolean isNumber() {
        return this.simpleType == 4 || this.simpleType == 5 || this.simpleType == 6;
    }

    public boolean isIntegerNumber() {
        return this.simpleType == 4;
    }

    public boolean isFloatNumber() {
        return this.simpleType == 5;
    }

    public boolean isChar() {
        return this.simpleType == 6;
    }
}

