/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.serialization.impl.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.logging.Logger;
import org.jboss.remoting.loading.ObjectInputStreamWithClassLoader;
import org.jboss.remoting.loading.RemotingClassLoader;
import org.jboss.remoting.serialization.IMarshalledValue;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;
import org.jboss.remoting.serialization.impl.jboss.MarshalledValue;
import org.jboss.remoting.serialization.impl.jboss.SmartCloningMarshalledValue;
import org.jboss.serial.io.JBossObjectInputStream;
import org.jboss.serial.io.JBossObjectOutputStream;
import org.jboss.serial.util.StringUtilBuffer;

public class JBossSerializationManager
extends SerializationManager {
    protected static final Logger log = Logger.getLogger((Class)JBossSerializationManager.class);
    private static boolean trace = log.isTraceEnabled();

    public ObjectInputStream createInput(InputStream input, ClassLoader loader) throws IOException {
        if (trace) {
            log.trace((Object)(this + " creating JBossObjectInputStream"));
        }
        return new JBossObjectInputStream(input, loader, new StringUtilBuffer(10024, 10024));
    }

    public ObjectOutputStream createOutput(OutputStream output) throws IOException {
        if (trace) {
            log.trace((Object)(this + " creating JBossObjectOutputStream"));
        }
        return new JBossObjectOutputStream(output, new StringUtilBuffer(10024, 10024));
    }

    public IMarshalledValue createdMarshalledValue(Object source) throws IOException {
        if (source instanceof IMarshalledValue) {
            return (IMarshalledValue)source;
        }
        return new MarshalledValue(source);
    }

    public IMarshalledValue createMarshalledValueForClone(Object original) throws IOException {
        return new SmartCloningMarshalledValue(original);
    }

    public void sendObject(ObjectOutputStream oos, Object dataObject, int version) throws IOException {
        oos.writeObject(dataObject);
        oos.flush();
    }

    public Object receiveObject(InputStream inputStream, ClassLoader customClassLoader, int version) throws IOException, ClassNotFoundException {
        ObjectInputStream objInputStream = null;
        Object obj = null;
        boolean useCurrentThreadClassLoader = false;
        if (inputStream instanceof ObjectInputStreamWithClassLoader) {
            ClassLoader cl = ((ObjectInputStreamWithClassLoader)inputStream).getClassLoader();
            if (cl instanceof RemotingClassLoader) {
                useCurrentThreadClassLoader = ((RemotingClassLoader)cl).isUseCurrentThreadClassLoader();
            }
            if (cl == null || useCurrentThreadClassLoader) {
                ((ObjectInputStreamWithClassLoader)inputStream).setClassLoader(customClassLoader);
            }
            objInputStream = (ObjectInputStream)inputStream;
        } else if (inputStream instanceof JBossObjectInputStream) {
            ClassLoader cl = ((JBossObjectInputStream)inputStream).getClassLoader();
            if (cl instanceof RemotingClassLoader) {
                useCurrentThreadClassLoader = ((RemotingClassLoader)cl).isUseCurrentThreadClassLoader();
            }
            if (cl == null || useCurrentThreadClassLoader) {
                ((JBossObjectInputStream)inputStream).setClassLoader(customClassLoader);
            }
            objInputStream = (ObjectInputStream)inputStream;
        } else {
            objInputStream = inputStream instanceof ObjectInputStream ? (ObjectInputStream)inputStream : (customClassLoader != null ? SerializationStreamFactory.getManagerInstance("jboss").createInput(inputStream, customClassLoader) : SerializationStreamFactory.getManagerInstance("jboss").createRegularInput(inputStream));
        }
        obj = objInputStream.readObject();
        return obj;
    }

    public String toString() {
        return "JBossSerializationManager[" + Integer.toHexString(this.hashCode()) + "]";
    }
}

