/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReflectError;
import bsh.ReflectManager;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.This;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

class Reflect {
    Reflect() {
    }

    public static Object invokeObjectMethod(Object object, String string, Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws ReflectError, EvalError, InvocationTargetException {
        if (object instanceof This && !Reflect.passThisMethod(string)) {
            return ((This)object).invokeMethod(string, objectArray, interpreter, callStack, simpleNode);
        }
        try {
            BshClassManager bshClassManager = callStack.top().getClassManager();
            Class<?> clazz = object.getClass();
            Method method = Reflect.resolveJavaMethod(bshClassManager, clazz, object, string, objectArray, false);
            return Reflect.invokeOnMethod(method, object, objectArray);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(simpleNode, callStack);
        }
    }

    public static Object invokeStaticMethod(BshClassManager bshClassManager, Class clazz, String string, Object[] objectArray) throws ReflectError, UtilEvalError, InvocationTargetException {
        Interpreter.debug("invoke static Method");
        Method method = Reflect.resolveJavaMethod(bshClassManager, clazz, null, string, objectArray, true);
        return Reflect.invokeOnMethod(method, null, objectArray);
    }

    private static Object invokeOnMethod(Method method, Object object, Object[] objectArray) throws ReflectError, InvocationTargetException {
        int n;
        if (Interpreter.DEBUG) {
            Interpreter.debug("Invoking method (entry): " + method + " with args:");
            for (int i = 0; i < objectArray.length; ++i) {
                Interpreter.debug("args[" + i + "] = " + objectArray[i] + " type = " + objectArray[i].getClass());
            }
        }
        Object[] objectArray2 = new Object[objectArray.length];
        Class<?>[] classArray = method.getParameterTypes();
        try {
            for (n = 0; n < objectArray.length; ++n) {
                objectArray2[n] = NameSpace.getAssignableForm(objectArray[n], classArray[n]);
            }
        }
        catch (UtilEvalError utilEvalError) {
            throw new InterpreterError("illegal argument type in method invocation: " + utilEvalError);
        }
        objectArray2 = Reflect.unwrapPrimitives(objectArray2);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Invoking method (after massaging values): " + method + " with tmpArgs:");
            for (n = 0; n < objectArray2.length; ++n) {
                Interpreter.debug("tmpArgs[" + n + "] = " + objectArray2[n] + " type = " + objectArray2[n].getClass());
            }
        }
        try {
            Object object2 = method.invoke(object, objectArray2);
            if (object2 == null) {
                object2 = Primitive.NULL;
            }
            Class<?> clazz = method.getReturnType();
            return Reflect.wrapPrimitive(object2, clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Cannot access method " + StringUtil.methodString(method.getName(), method.getParameterTypes()) + " in '" + method.getDeclaringClass() + "' :" + illegalAccessException);
        }
    }

    private static boolean passThisMethod(String string) {
        return string.equals("getClass") || string.equals("invokeMethod") || string.equals("getInterface") || string.equals("wait") || string.equals("notify") || string.equals("notifyAll");
    }

    public static Object getIndex(Object object, int n) throws ReflectError, UtilTargetError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("getIndex: " + object + ", index=" + n);
        }
        try {
            Object object2 = Array.get(object, n);
            return Reflect.wrapPrimitive(object2, object.getClass().getComponentType());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new UtilTargetError(arrayIndexOutOfBoundsException);
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static void setIndex(Object object, int n, Object object2) throws ReflectError, UtilTargetError {
        try {
            object2 = Primitive.unwrap(object2);
            Array.set(object, n, object2);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new UtilTargetError(arrayStoreException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UtilTargetError(new ArrayStoreException(illegalArgumentException.toString()));
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static Object getStaticField(Class clazz, String string) throws UtilEvalError, ReflectError {
        return Reflect.getFieldValue(clazz, null, string);
    }

    public static Object getObjectField(Object object, String string) throws UtilEvalError, ReflectError {
        if (object instanceof This) {
            return ((This)object).namespace.getVariable(string);
        }
        try {
            return Reflect.getFieldValue(object.getClass(), object, string);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertyGetter(object.getClass(), string)) {
                return Reflect.getObjectProperty(object, string);
            }
            throw reflectError;
        }
    }

    static LHS getLHSStaticField(Class clazz, String string) throws UtilEvalError, ReflectError {
        Field field = Reflect.getField(clazz, string);
        return new LHS(field);
    }

    static LHS getLHSObjectField(Object object, String string) throws UtilEvalError, ReflectError {
        if (object instanceof This) {
            boolean bl = false;
            return new LHS(((This)object).namespace, string, bl);
        }
        try {
            Field field = Reflect.getField(object.getClass(), string);
            return new LHS(object, field);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertySetter(object.getClass(), string)) {
                return new LHS(object, string);
            }
            throw reflectError;
        }
    }

    private static Object getFieldValue(Class clazz, Object object, String string) throws UtilEvalError, ReflectError {
        try {
            Field field = Reflect.getField(clazz, string);
            if (field == null) {
                throw new ReflectError("internal: field not found:" + string);
            }
            Object object2 = field.get(object);
            Class<?> clazz2 = field.getType();
            return Reflect.wrapPrimitive(object2, clazz2);
        }
        catch (NullPointerException nullPointerException) {
            throw new ReflectError("???" + string + " is not a static field.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Can't access field: " + string);
        }
    }

    private static Field getField(Class clazz, String string) throws UtilEvalError, ReflectError {
        try {
            if (Capabilities.haveAccessibility()) {
                return Reflect.findAccessibleField(clazz, string);
            }
            return clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectError("No such field: " + string);
        }
    }

    private static Field findAccessibleField(Class clazz, String string) throws UtilEvalError, NoSuchFieldException {
        try {
            return clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            while (clazz != null) {
                try {
                    Field field = clazz.getDeclaredField(string);
                    if (ReflectManager.RMSetAccessible(field)) {
                        return field;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                    // empty catch block
                }
                clazz = clazz.getSuperclass();
            }
            throw new NoSuchFieldException(string);
        }
    }

    static Method resolveJavaMethod(BshClassManager bshClassManager, Class clazz, Object object, String string, Object[] objectArray, boolean bl) throws ReflectError, UtilEvalError {
        Method method = null;
        if (bshClassManager == null) {
            Interpreter.debug("resolveJavaMethod UNOPTIMIZED lookup");
        } else {
            method = bshClassManager.getResolvedMethod(clazz, string, objectArray, bl);
            if (method != null) {
                return method;
            }
        }
        if (object == Primitive.NULL) {
            throw new UtilTargetError(new NullPointerException("Attempt to invoke method " + string + " on null value"));
        }
        Class[] classArray = Reflect.getTypes(objectArray);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Searching for method: " + StringUtil.methodString(string, classArray) + " in '" + clazz.getName() + "'");
        }
        try {
            method = Reflect.findAccessibleMethod(clazz, string, classArray, bl);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (Interpreter.DEBUG && method != null) {
            Interpreter.debug("findAccessibleMethod found: " + method);
        }
        if (method == null) {
            if (classArray.length == 0) {
                throw new ReflectError("No args " + (bl ? "static " : "") + "method " + StringUtil.methodString(string, classArray) + " not found in class'" + clazz.getName() + "'");
            }
            Method[] methodArray = clazz.getMethods();
            if (bl) {
                methodArray = Reflect.retainStaticMethods(methodArray);
            }
            method = Reflect.findMostSpecificMethod(string, classArray, methodArray);
            if (Interpreter.DEBUG && method != null) {
                Interpreter.debug("findMostSpecificMethod found: " + method);
            }
            if (method == null) {
                method = Reflect.findExtendedMethod(string, objectArray, methodArray);
                if (Interpreter.DEBUG && method != null) {
                    Interpreter.debug("findExtendedMethod found: " + method);
                }
            }
            if (method != null) {
                try {
                    method = Reflect.findAccessibleMethod(clazz, method.getName(), method.getParameterTypes(), bl);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (Interpreter.DEBUG && method == null) {
                    Interpreter.debug("had a method, but it wasn't accessible");
                }
            }
        }
        if (method == null) {
            throw new ReflectError((bl ? "Static method " : "Method ") + StringUtil.methodString(string, classArray) + " not found in class'" + clazz.getName() + "'");
        }
        if (bshClassManager != null) {
            bshClassManager.cacheResolvedMethod(clazz, objectArray, method);
        }
        return method;
    }

    private static Method[] retainStaticMethods(Method[] methodArray) {
        Vector<Method> vector = new Vector<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!Modifier.isStatic(methodArray[i].getModifiers())) continue;
            vector.addElement(methodArray[i]);
        }
        Object[] objectArray = new Method[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static Method findAccessibleMethod(Class clazz, String string, Class[] classArray, boolean bl) throws UtilEvalError {
        Method method = null;
        Method method2 = null;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(clazz);
        Method method3 = null;
        while (vector.size() > 0) {
            Class<?>[] classArray2;
            Class clazz2 = (Class)vector.firstElement();
            vector.removeElementAt(0);
            if (Modifier.isPublic(clazz2.getModifiers()) || Capabilities.haveAccessibility()) {
                try {
                    method = clazz2.getDeclaredMethod(string, classArray);
                    if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(clazz2.getModifiers()) || Capabilities.haveAccessibility() && ReflectManager.RMSetAccessible(method)) {
                        method3 = method;
                        break;
                    }
                    method2 = method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (!clazz2.isInterface() && (classArray2 = clazz2.getSuperclass()) != null) {
                vector.addElement(classArray2);
            }
            classArray2 = clazz2.getInterfaces();
            for (int i = 0; i < classArray2.length; ++i) {
                vector.addElement(classArray2[i]);
            }
        }
        if (method3 != null && (!bl || Modifier.isStatic(method3.getModifiers()))) {
            return method3;
        }
        if (method2 != null) {
            throw new UtilEvalError("Found non-public method: " + method2 + ".  Use setAccessibility(true) to enable access to " + " private and protected members of classes.");
        }
        return null;
    }

    private static Object wrapPrimitive(Object object, Class clazz) throws ReflectError {
        if (object == null) {
            return Primitive.NULL;
        }
        if (clazz == Void.TYPE) {
            return Primitive.VOID;
        }
        if (clazz.isPrimitive()) {
            if (object instanceof Number) {
                return new Primitive((Number)object);
            }
            if (object instanceof Boolean) {
                return new Primitive((Boolean)object);
            }
            if (object instanceof Character) {
                return new Primitive((Character)object);
            }
            throw new ReflectError("Something bad happened");
        }
        return object;
    }

    public static Class[] getTypes(Object[] objectArray) {
        if (objectArray == null) {
            return new Class[0];
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] == null ? null : (objectArray[i] instanceof Primitive ? ((Primitive)objectArray[i]).getType() : objectArray[i].getClass());
        }
        return classArray;
    }

    private static Object[] unwrapPrimitives(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = Primitive.unwrap(objectArray[i]);
        }
        return objectArray2;
    }

    static Object constructObject(Class clazz, Object[] objectArray) throws ReflectError, InvocationTargetException {
        if (clazz.isInterface()) {
            throw new ReflectError("Can't create instance of an interface: " + clazz);
        }
        Object var2_2 = null;
        Class[] classArray = Reflect.getTypes(objectArray);
        Constructor constructor = null;
        Constructor[] constructorArray = clazz.getDeclaredConstructors();
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific constructor: " + clazz);
        }
        if ((constructor = Reflect.findMostSpecificConstructor(classArray, constructorArray)) == null) {
            if (classArray.length == 0) {
                throw new ReflectError("Can't find default constructor for: " + clazz);
            }
            constructor = Reflect.findExtendedConstructor(objectArray, constructorArray);
        }
        if (constructor == null) {
            throw new ReflectError("Can't find constructor: " + StringUtil.methodString(clazz.getName(), classArray) + " in class: " + clazz.getName());
        }
        try {
            objectArray = Reflect.unwrapPrimitives(objectArray);
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectError("the class is abstract ");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("we don't have permission to create an instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectError("the number of arguments was wrong");
        }
        if (var2_2 == null) {
            throw new ReflectError("couldn't construct the object");
        }
        return var2_2;
    }

    static Method findMostSpecificMethod(String string, Class[] classArray, Method[] methodArray) {
        int n;
        Vector<Class<?>[]> vector = new Vector<Class<?>[]>();
        Vector<Method> vector2 = new Vector<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            vector2.addElement(methodArray[i]);
            vector.addElement(methodArray[i].getParameterTypes());
        }
        Class[][] classArray2 = new Class[vector.size()][];
        vector.copyInto((Object[])classArray2);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific method: " + string);
        }
        if ((n = Reflect.findMostSpecificSignature(classArray, classArray2)) == -1) {
            return null;
        }
        return (Method)vector2.elementAt(n);
    }

    static Constructor findMostSpecificConstructor(Class[] classArray, Constructor[] constructorArray) {
        int n;
        Class[][] classArray2 = new Class[constructorArray.length][];
        for (n = 0; n < classArray2.length; ++n) {
            classArray2[n] = constructorArray[n].getParameterTypes();
        }
        n = Reflect.findMostSpecificSignature(classArray, classArray2);
        if (n == -1) {
            return null;
        }
        return constructorArray[n];
    }

    static Method findExtendedMethod(String string, Object[] objectArray, Method[] methodArray) {
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            Class[] classArray = method.getParameterTypes();
            if (!string.equals(method.getName()) || !Reflect.argsAssignable(classArray, objectArray)) continue;
            return method;
        }
        return null;
    }

    static Constructor findExtendedConstructor(Object[] objectArray, Constructor[] constructorArray) {
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor constructor = constructorArray[i];
            Class[] classArray = constructor.getParameterTypes();
            if (!Reflect.argsAssignable(classArray, objectArray)) continue;
            return constructor;
        }
        return null;
    }

    private static boolean argsAssignable(Class[] classArray, Object[] objectArray) {
        if (classArray.length != objectArray.length) {
            return false;
        }
        try {
            for (int i = 0; i < classArray.length; ++i) {
                NameSpace.getAssignableForm(objectArray[i], classArray[i]);
            }
        }
        catch (UtilEvalError utilEvalError) {
            return false;
        }
        return true;
    }

    static int findMostSpecificSignature(Class[] classArray, Class[][] classArray2) {
        Class[] classArray3 = null;
        int n = -1;
        for (int i = 0; i < classArray2.length; ++i) {
            Class[] classArray4 = classArray2[i];
            if (!Reflect.isSignatureAssignable(classArray, classArray4) || classArray3 != null && !Reflect.isSignatureAssignable(classArray4, classArray3)) continue;
            classArray3 = classArray4;
            n = i;
        }
        if (classArray3 != null) {
            return n;
        }
        Interpreter.debug("no match found");
        return -1;
    }

    private static boolean isSignatureAssignable(Class[] classArray, Class[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray2[i] == null || Reflect.isJavaAssignableFrom(classArray2[i], classArray[i])) continue;
            return false;
        }
        return true;
    }

    static boolean isJavaAssignableFrom(Class clazz, Class clazz2) {
        if (clazz2 == null) {
            return !clazz.isPrimitive();
        }
        if (clazz.isPrimitive() && clazz2.isPrimitive()) {
            if (clazz == clazz2) {
                return true;
            }
            if (clazz2 == Byte.TYPE && (clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Short.TYPE && (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Character.TYPE && (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Integer.TYPE && (clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Long.TYPE && (clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Float.TYPE && clazz == Double.TYPE) {
                return true;
            }
        } else if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        return false;
    }

    private static String accessorName(String string, String string2) {
        return string + String.valueOf(Character.toUpperCase(string2.charAt(0))) + string2.substring(1);
    }

    public static boolean hasObjectPropertyGetter(Class clazz, String string) {
        String string2 = Reflect.accessorName("get", string);
        try {
            clazz.getMethod(string2, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string2 = Reflect.accessorName("is", string);
            try {
                Method method = clazz.getMethod(string2, new Class[0]);
                return method.getReturnType() == Boolean.TYPE;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return false;
            }
        }
    }

    public static boolean hasObjectPropertySetter(Class clazz, String string) {
        String string2 = Reflect.accessorName("set", string);
        Class[] classArray = new Class[]{clazz};
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static Object getObjectProperty(Object object, String string) throws UtilEvalError, ReflectError {
        String string2;
        Object[] objectArray = new Object[]{};
        Interpreter.debug("property access: ");
        Method method = null;
        Exception exception = null;
        Exception exception2 = null;
        try {
            string2 = Reflect.accessorName("get", string);
            method = Reflect.resolveJavaMethod(null, object.getClass(), object, string2, objectArray, false);
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        if (method == null) {
            try {
                string2 = Reflect.accessorName("is", string);
                method = Reflect.resolveJavaMethod(null, object.getClass(), object, string2, objectArray, false);
                if (method.getReturnType() != Boolean.TYPE) {
                    method = null;
                }
            }
            catch (Exception exception4) {
                exception2 = exception4;
            }
        }
        if (method == null) {
            throw new ReflectError("Error in property getter: " + exception + (exception2 != null ? " : " + exception2 : ""));
        }
        try {
            return Reflect.invokeOnMethod(method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Property accessor threw exception: " + invocationTargetException.getTargetException());
        }
    }

    public static void setObjectProperty(Object object, String string, Object object2) throws ReflectError, UtilEvalError {
        String string2 = Reflect.accessorName("set", string);
        Object[] objectArray = new Object[]{object2};
        Interpreter.debug("property access: ");
        try {
            Method method = Reflect.resolveJavaMethod(null, object.getClass(), object, string2, objectArray, false);
            Reflect.invokeOnMethod(method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Property accessor threw exception: " + invocationTargetException.getTargetException());
        }
    }

    public static String normalizeClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(Reflect.getArrayBaseType(clazz).getName());
            for (int i = 0; i < Reflect.getArrayDimensions(clazz); ++i) {
                stringBuffer.append("[]");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static int getArrayDimensions(Class clazz) {
        if (!clazz.isArray()) {
            return 0;
        }
        return clazz.getName().lastIndexOf(91) + 1;
    }

    public static Class getArrayBaseType(Class clazz) throws ReflectError {
        if (!clazz.isArray()) {
            throw new ReflectError("The class is not an array.");
        }
        return clazz.getComponentType();
    }

    public static Object invokeCompiledCommand(Class clazz, Object[] objectArray, Interpreter interpreter, CallStack callStack) throws UtilEvalError {
        Object[] objectArray2 = new Object[objectArray.length + 2];
        objectArray2[0] = interpreter;
        objectArray2[1] = callStack;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        BshClassManager bshClassManager = interpreter.getClassManager();
        try {
            return Reflect.invokeStaticMethod(bshClassManager, clazz, "invoke", objectArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Error in compiled command: " + invocationTargetException.getTargetException());
        }
        catch (ReflectError reflectError) {
            throw new UtilEvalError("Error invoking compiled command: " + reflectError);
        }
    }
}

