/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionFixer {
    static Pattern FUNCTION = Pattern.compile("(\\S*\\s*|\\.\\s*)\\b([\\S&&[^\\.\\(\\)]]+)\\s*\\(([^)]*)\\)", 32);
    static final Set KEYWORDS = FunctionFixer.getJavaKeywords();

    public String fix(String string) {
        return this.fix(string, FUNCTION);
    }

    public String fix(String string, Pattern pattern) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        Matcher matcher = pattern.matcher(string);
        while (matcher.find(n2)) {
            String string2;
            int n3 = this.findEndParenthesis(string, matcher);
            if (n3 < 0) {
                n2 = matcher.start(3);
                continue;
            }
            n2 = n3;
            String string3 = matcher.group(3).trim();
            if (n3 > matcher.end()) {
                string3 = string3 + string.substring(matcher.end() - 1, n3 - 1);
            }
            string3 = this.fix(string3, pattern);
            String string4 = null;
            String string5 = matcher.group(1);
            if (matcher.group(1) != null && ((string2 = string5.trim()).endsWith(".") || string2.endsWith("new"))) {
                string4 = string.substring(matcher.start(2), matcher.start(3) - 1);
            }
            if (string4 == null) {
                string4 = matcher.group(2).trim();
                string4 = string4 == null || string4.length() == 0 || KEYWORDS.contains(string4) ? string.substring(matcher.start(2), matcher.start(3) - 1) : this.ucFirst(string4) + "." + string4;
            }
            string2 = string4 + "(" + string3 + ")";
            stringBuffer.append(string.substring(n, matcher.start(2)));
            stringBuffer.append(string2);
            n = n3;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    private String ucFirst(String string) {
        return string.toUpperCase().charAt(0) + string.substring(1);
    }

    private int findEndParenthesis(String string, Matcher matcher) {
        int n = matcher.start(3) - 1;
        int n2 = matcher.end();
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        block5: for (int i = 0; i < string.length(); ++i) {
            if (i > n2 && n3 == n4) {
                if (n5 < 0 || n5 > n) break;
                return -1;
            }
            switch (string.charAt(i)) {
                case '\"': {
                    if (n5 >= 0) {
                        if (n5 <= n && n <= i) {
                            return -1;
                        }
                        n5 = -1;
                        continue block5;
                    }
                    n5 = i;
                    continue block5;
                }
                case '(': {
                    if (n5 >= 0 || i < n) continue block5;
                    ++n3;
                    continue block5;
                }
                case ')': {
                    if (n5 >= 0 || i < n) continue block5;
                    ++n4;
                    if (i < n2) continue block5;
                    n2 = i + 1;
                }
            }
        }
        return n2;
    }

    private static Set getJavaKeywords() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("abstract");
        hashSet.add("continue");
        hashSet.add("for");
        hashSet.add("new");
        hashSet.add("switch");
        hashSet.add("assert");
        hashSet.add("default");
        hashSet.add("goto");
        hashSet.add("package");
        hashSet.add("synchronized");
        hashSet.add("boolean");
        hashSet.add("do");
        hashSet.add("if");
        hashSet.add("private");
        hashSet.add("this");
        hashSet.add("break");
        hashSet.add("double");
        hashSet.add("implements");
        hashSet.add("protected");
        hashSet.add("throw");
        hashSet.add("byte");
        hashSet.add("else");
        hashSet.add("import");
        hashSet.add("public");
        hashSet.add("throws");
        hashSet.add("case");
        hashSet.add("enum");
        hashSet.add("instanceof");
        hashSet.add("return");
        hashSet.add("transient");
        hashSet.add("catch");
        hashSet.add("extends");
        hashSet.add("int");
        hashSet.add("short");
        hashSet.add("try");
        hashSet.add("char");
        hashSet.add("final");
        hashSet.add("interface");
        hashSet.add("static");
        hashSet.add("void");
        hashSet.add("class");
        hashSet.add("finally");
        hashSet.add("long");
        hashSet.add("strictfp");
        hashSet.add("volatile");
        hashSet.add("const");
        hashSet.add("float");
        hashSet.add("native");
        hashSet.add("super");
        hashSet.add("while");
        return hashSet;
    }
}

