/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.work;

import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import org.jboss.logging.Logger;
import org.jboss.resource.work.JBossWorkManager;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.threadpool.BasicTaskWrapper;
import org.jboss.util.threadpool.StartTimeoutException;
import org.jboss.util.threadpool.Task;

public class WorkWrapper
extends BasicTaskWrapper
implements Task {
    private static final Logger log = Logger.getLogger(WorkWrapper.class);
    private boolean trace = log.isTraceEnabled();
    private Work work;
    private ExecutionContext executionContext;
    private WorkListener workListener;
    private long startTimeout;
    private JBossWorkManager workManager;
    private int waitType;
    private long blockedTime;
    private WorkException exception;

    public WorkWrapper(JBossWorkManager workManager, Work work, int waitType, long startTimeout, ExecutionContext executionContext, WorkListener workListener) {
        if (work == null) {
            throw new IllegalArgumentException("Null work");
        }
        if (executionContext == null) {
            throw new IllegalArgumentException("Null execution context");
        }
        if (startTimeout < 0L) {
            throw new IllegalArgumentException("Illegal start timeout: " + startTimeout);
        }
        this.workManager = workManager;
        this.work = work;
        this.waitType = waitType;
        this.startTimeout = startTimeout;
        this.executionContext = executionContext;
        this.workListener = workListener;
        this.setTask(this);
    }

    public JBossWorkManager getWorkManager() {
        return this.workManager;
    }

    public Work getWork() {
        return this.work;
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public long getBlockedElapsed() {
        return this.blockedTime;
    }

    public WorkException getWorkException() {
        return this.exception;
    }

    public int getWaitType() {
        return this.waitType;
    }

    public int getPriority() {
        return 5;
    }

    public long getStartTimeout() {
        return this.startTimeout;
    }

    public long getCompletionTimeout() {
        long timeout = this.executionContext.getTransactionTimeout();
        if (timeout != -1L) {
            timeout *= 1000L;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.trace) {
            log.trace((Object)("Executing work " + (Object)((Object)this)));
        }
        try {
            this.workManager.startWork(this);
        }
        catch (WorkException e) {
            this.taskRejected((RuntimeException)new NestedRuntimeException((Throwable)e));
            return;
        }
        try {
            this.work.run();
        }
        finally {
            this.workManager.endWork(this);
        }
        if (this.trace) {
            log.trace((Object)("Executed work " + (Object)((Object)this)));
        }
    }

    public void stop() {
        if (this.trace) {
            log.trace((Object)("Stopping work " + (Object)((Object)this)));
        }
        this.work.release();
    }

    public void accepted(long time) {
        this.blockedTime = time;
        if (this.trace) {
            log.trace((Object)("Accepted work " + (Object)((Object)this)));
        }
        if (this.workListener != null) {
            WorkEvent event = new WorkEvent((Object)this.workManager, 1, this.work, null);
            this.workListener.workAccepted(event);
        }
    }

    public void rejected(long time, Throwable throwable) {
        this.blockedTime = time;
        if (this.trace) {
            if (throwable != null) {
                log.trace((Object)("Rejecting work " + (Object)((Object)this)), throwable);
            } else {
                log.trace((Object)("Rejecting work " + (Object)((Object)this)));
            }
        }
        if (throwable != null) {
            this.exception = new WorkRejectedException(throwable);
            if (throwable instanceof StartTimeoutException) {
                this.exception.setErrorCode("1");
            }
        }
        this.workManager.cancelWork(this);
        if (this.workListener != null) {
            WorkEvent event = new WorkEvent((Object)this.workManager, 2, this.work, this.exception);
            this.workListener.workRejected(event);
        }
    }

    public void started(long time) {
        if (this.waitType != 0) {
            this.blockedTime = time;
        }
        if (this.workListener != null) {
            WorkEvent event = new WorkEvent((Object)this.workManager, 3, this.work, null);
            this.workListener.workStarted(event);
        }
    }

    public void completed(long time, Throwable throwable) {
        if (this.waitType == 2) {
            this.blockedTime = time;
        }
        if (throwable != null) {
            this.exception = new WorkCompletedException(throwable);
        }
        if (this.trace) {
            log.trace((Object)("Completed work " + (Object)((Object)this)));
        }
        if (this.workListener != null) {
            WorkEvent event = new WorkEvent((Object)this.workManager, 4, this.work, this.exception);
            this.workListener.workCompleted(event);
        }
    }

    public String toString() {
        long completionTimeout;
        JBossStringBuilder buffer = new JBossStringBuilder(100);
        buffer.append("WorkWrapper@").append(Integer.toHexString(System.identityHashCode((Object)this)));
        buffer.append("[workManger=").append((Object)this.workManager);
        buffer.append(" work=").append((Object)this.work);
        buffer.append(" state=").append(this.getStateString());
        if (this.executionContext != null && this.executionContext.getXid() != null) {
            buffer.append(" xid=").append((Object)this.executionContext.getXid());
            buffer.append(" txTimeout=").append(this.executionContext.getTransactionTimeout());
        }
        buffer.append(" waitType=");
        switch (this.waitType) {
            case 0: {
                buffer.append("WAIT_NONE");
                break;
            }
            case 1: {
                buffer.append("WAIT_FOR_START");
                break;
            }
            case 2: {
                buffer.append("WAIT_FOR_COMPLETE");
                break;
            }
            default: {
                buffer.append("???");
            }
        }
        if (this.startTimeout != Long.MAX_VALUE) {
            buffer.append(" startTimeout=").append(this.startTimeout);
        }
        if ((completionTimeout = this.getCompletionTimeout()) != -1L) {
            buffer.append(" completionTimeout=").append(completionTimeout);
        }
        if (this.blockedTime != 0L) {
            buffer.append(" blockTime=").append(this.blockedTime);
        }
        buffer.append(" elapsedTime=").append(this.getElapsedTime());
        if (this.workListener != null) {
            buffer.append(" workListener=").append((Object)this.workListener);
        }
        if (this.exception != null) {
            buffer.append(" exception=").append((Object)this.exception);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

