/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogSource;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.commons.services.Event;
import org.apache.commons.services.LogEvent;
import org.apache.commons.services.Service;

public class LogService
extends Service {
    public static int DEFAULT_LOG_LEVEL = 7;
    protected Log log = null;

    protected void initLog() {
        try {
            LogSource.setLogImplementation((String)"org.apache.commons.logging.impl.SimpleLog");
            this.log = LogSource.makeNewLogInstance((String)"org.apache.commons.service.logging.impl.SimpleLog");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log = LogSource.makeNewLogInstance((String)"org.apache.commons.service.logging.default");
        if (this.log instanceof SimpleLog) {
            ((SimpleLog)this.log).setLevel(DEFAULT_LOG_LEVEL);
        }
    }

    public LogService() {
        this.initLog();
    }

    public void init() {
        super.init();
        if (this.log instanceof SimpleLog) {
            ((SimpleLog)this.log).setLevel(DEFAULT_LOG_LEVEL);
        }
    }

    public void destroy() {
        super.destroy();
        this.log = null;
    }

    public Log getLog() {
        return this.log;
    }

    public Object execute(Event event) {
        if (event instanceof LogEvent) {
            LogEvent logEvent = (LogEvent)event;
            this.log.info((Object)logEvent.getMessage(), logEvent.getError());
        } else {
            this.log.info((Object)event);
            this.log.debug((Object)event);
            this.log.fatal((Object)event);
            this.log.error((Object)event);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)event);
            }
        }
        return null;
    }
}

