/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.entity.ExtendedPersistenceContext;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.logging.Logger;

public class StatefulRemoveInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(StatefulRemoveInterceptor.class);
    protected boolean retainIfException;

    public StatefulRemoveInterceptor(boolean removeOnException) {
        this.retainIfException = removeOnException;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object rtn = null;
        try {
            rtn = invocation.invokeNext();
        }
        catch (Throwable t) {
            if (!this.retainIfException) {
                this.removeSession(invocation);
            }
            throw t;
        }
        this.removeSession(invocation);
        return rtn;
    }

    protected void removeSession(Invocation invocation) {
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        Object id = ejb.getId();
        StatefulContainer container = (StatefulContainer)ejb.getAdvisor();
        StatefulBeanContext ctx = (StatefulBeanContext)ejb.getBeanContext();
        container.getCache().remove(id);
        ExtendedPersistenceContext session = (ExtendedPersistenceContext)ctx.getMetaData().getMetaData((Object)"LONG_LIVED_SESSION", (Object)"LONG_LIVED_SESSION");
        if (session != null) {
            log.debug((Object)"REMOVING EXTENDED PERSISTENCE CONTEXT");
            session.closeExtendedPersistenceContext();
        }
    }
}

