/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.ejb.InvocationContext;
import javax.ejb.PostActivate;
import javax.ejb.PostConstruct;
import javax.ejb.PreDestroy;
import javax.ejb.PrePassivate;
import javax.ejb.TimedObject;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.interceptor.LifecycleInvocationContextImpl;
import org.jboss.util.MethodHashing;

public class LifecycleInterceptorHandler {
    private EJBContainer container;
    private InterceptorInfo[] postConstructs;
    private InterceptorInfo[] postActivates;
    private InterceptorInfo[] prePassivates;
    private InterceptorInfo[] preDestroys;
    private Method[] beanPostConstructs;
    private Method[] beanPostActivates;
    private Method[] beanPrePassivates;
    private Method[] beanPreDestroys;
    private Method timeoutCallbackMethod;
    private long timeoutCalllbackHash;

    public LifecycleInterceptorHandler(EJBContainer container, Class[] handledCallbacks) {
        this.container = container;
        InterceptorInfoRepository repostitory = container.getInterceptorRepository();
        for (Class clazz : handledCallbacks) {
            if (clazz == PostConstruct.class) {
                this.postConstructs = repostitory.getPostConstructInterceptors(container);
                this.beanPostConstructs = repostitory.getBeanClassPostConstructs(container);
                continue;
            }
            if (clazz == PostActivate.class) {
                this.postActivates = repostitory.getPostActivateInterceptors(container);
                this.beanPostActivates = repostitory.getBeanClassPostActivates(container);
                continue;
            }
            if (clazz == PrePassivate.class) {
                this.prePassivates = repostitory.getPrePassivateInterceptors(container);
                this.beanPrePassivates = repostitory.getBeanClassPrePassivates(container);
                continue;
            }
            if (clazz == PreDestroy.class) {
                this.preDestroys = repostitory.getPreDestroyInterceptors(container);
                this.beanPreDestroys = repostitory.getBeanClassPreDestroys(container);
                continue;
            }
            if (clazz != Timeout.class) continue;
            this.resolveTimeoutCallback();
        }
    }

    public long getTimeoutCalllbackHash() {
        return this.timeoutCalllbackHash;
    }

    public void postConstruct(BeanContext ctx) {
        try {
            InvocationContext ic = LifecycleInvocationContextImpl.getLifecycleInvocationContext(PostConstruct.class, ctx, this.postConstructs, this.beanPostConstructs);
            ic.proceed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void preDestroy(BeanContext ctx) {
        try {
            InvocationContext ic = LifecycleInvocationContextImpl.getLifecycleInvocationContext(PreDestroy.class, ctx, this.preDestroys, this.beanPreDestroys);
            ic.proceed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void postActivate(BeanContext ctx) {
        try {
            InvocationContext ic = LifecycleInvocationContextImpl.getLifecycleInvocationContext(PostActivate.class, ctx, this.postActivates, this.beanPostActivates);
            ic.proceed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void prePassivate(BeanContext ctx) {
        try {
            InvocationContext ic = LifecycleInvocationContextImpl.getLifecycleInvocationContext(PrePassivate.class, ctx, this.prePassivates, this.beanPrePassivates);
            ic.proceed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Method getTimeoutCallback() {
        return this.timeoutCallbackMethod;
    }

    private void resolveTimeoutCallback() {
        for (Method method : this.container.getBeanClass().getMethods()) {
            if (this.container.resolveAnnotation(method, Timeout.class) == null) continue;
            if (Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(Timer.class)) {
                this.timeoutCallbackMethod = method;
                continue;
            }
            throw new RuntimeException("@Timeout methods must have the signature: public void <METHOD>(javax.ejb.Timer timer) - " + method);
        }
        try {
            if (this.timeoutCallbackMethod == null && TimedObject.class.isAssignableFrom(this.container.getBeanClass())) {
                Class[] params = new Class[]{Timer.class};
                this.timeoutCallbackMethod = this.container.getBeanClass().getMethod("ejbTimeout", params);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.timeoutCallbackMethod != null) {
            this.timeoutCalllbackHash = MethodHashing.calculateHash((Method)this.timeoutCallbackMethod);
        }
    }
}

