/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.InvocationContext;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.interceptor.InterceptorInfo;

public class InvocationContextImpl
implements InvocationContext {
    public static final String EJB3_METADATA = "jboss.ejb3.invocation.metadata";
    private int currentInterceptor;
    private int currentMethod;
    private int currentBeanMethod;
    InterceptorInfo[] interceptorInfos;
    Object[] instances;
    private Method[] beanAroundInvokes;
    private HashMap metadata;
    EJBContainerInvocation wrapped;

    public InvocationContextImpl(EJBContainerInvocation inv, InterceptorInfo[] interceptorInfos, Object[] instances, Method[] beanAroundInvokes) {
        this.wrapped = inv;
        this.beanAroundInvokes = beanAroundInvokes;
        if (interceptorInfos.length != instances.length) {
            throw new RuntimeException("interceptorInfos and instances have different length");
        }
        this.interceptorInfos = interceptorInfos;
        this.instances = instances;
    }

    public Object getBean() {
        return this.wrapped.getTargetObject();
    }

    public Method getMethod() {
        return this.wrapped.getMethod();
    }

    public Object[] getParameters() {
        return this.wrapped.getArguments();
    }

    public void setParameters(Object[] params) {
        this.wrapped.setArguments(params);
    }

    public Map getContextData() {
        if (this.metadata == null) {
            this.metadata = new HashMap();
            this.metadata.put(EJB3_METADATA, this.wrapped.getInstanceResolver());
        }
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed() throws Exception {
        if (this.currentInterceptor < this.interceptorInfos.length) {
            int oldInterceptor = this.currentInterceptor;
            int oldMethod = this.currentMethod;
            try {
                int curr = this.currentInterceptor++;
                int currMethod = this.currentMethod++;
                InterceptorInfo info = this.interceptorInfos[curr];
                if (currMethod == info.getAroundInvokes().length) {
                    curr = this.currentInterceptor;
                    this.currentMethod = 0;
                    currMethod = this.currentMethod++;
                    InterceptorInfo interceptorInfo = info = curr < this.interceptorInfos.length ? this.interceptorInfos[curr] : null;
                }
                if (info != null) {
                    try {
                        Object object = info.getAroundInvokes()[currMethod].invoke(this.instances[curr], this);
                        return object;
                    }
                    catch (InvocationTargetException e) {
                        if (e.getTargetException() instanceof Exception) {
                            throw (Exception)e.getCause();
                        }
                        throw new RuntimeException(e.getCause());
                    }
                }
            }
            finally {
                this.currentInterceptor = oldInterceptor;
                this.currentMethod = oldMethod;
            }
        }
        if (this.beanAroundInvokes != null && this.currentBeanMethod < this.beanAroundInvokes.length) {
            try {
                int curr = this.currentBeanMethod++;
                Object object = this.beanAroundInvokes[curr].invoke(this.getBean(), this);
                return object;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            finally {
                --this.currentBeanMethod;
            }
        }
        try {
            return this.wrapped.invokeNext();
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

