/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.persistence.EntityManagerFactory;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.classic.Session;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;
import org.jboss.ejb3.EJB3Util;

public class InjectedSessionFactory
implements SessionFactory,
Serializable {
    private transient EntityManagerFactory delegate;
    private String jndiName;
    private Hashtable initialContextProperties;

    public InjectedSessionFactory(EntityManagerFactory delegate, String jndiName, Hashtable initialContextProperties) {
        this.delegate = delegate;
        this.jndiName = jndiName;
        this.initialContextProperties = initialContextProperties;
    }

    public InjectedSessionFactory(EntityManagerFactory delegate, Hashtable initialContextProperties) {
        this(delegate, "java:comp.ejb3/EntityManagerFactory", initialContextProperties);
    }

    private EntityManagerFactory getDelegate() {
        if (this.delegate == null) {
            try {
                InitialContext ctx = EJB3Util.getInitialContext(this.initialContextProperties);
                this.delegate = (EntityManagerFactory)ctx.lookup(this.jndiName);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.delegate;
    }

    private SessionFactory getSessionFactory() {
        return ((HibernateEntityManagerFactory)this.getDelegate()).getSessionFactory();
    }

    public Session openSession(Connection connection) {
        return this.getSessionFactory().openSession(connection);
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        return this.getSessionFactory().openSession(interceptor);
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.getSessionFactory().openSession(connection, interceptor);
    }

    public Session openSession() throws HibernateException {
        return this.getSessionFactory().openSession();
    }

    public Session getCurrentSession() throws HibernateException {
        return this.getSessionFactory().getCurrentSession();
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getSessionFactory().getClassMetadata(persistentClass);
    }

    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return this.getSessionFactory().getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.getSessionFactory().getCollectionMetadata(roleName);
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.getSessionFactory().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.getSessionFactory().getAllCollectionMetadata();
    }

    public Statistics getStatistics() {
        return this.getSessionFactory().getStatistics();
    }

    public void close() throws HibernateException {
        throw new IllegalStateException("It is illegal to close an injected SessionFactory");
    }

    public boolean isClosed() {
        return this.getSessionFactory().isClosed();
    }

    public void evict(Class persistentClass) throws HibernateException {
        this.getSessionFactory().evict(persistentClass);
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getSessionFactory().evict(persistentClass, id);
    }

    public void evictEntity(String entityName) throws HibernateException {
        this.getSessionFactory().evictEntity(entityName);
    }

    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.getSessionFactory().evictEntity(entityName, id);
    }

    public void evictCollection(String roleName) throws HibernateException {
        this.getSessionFactory().evictCollection(roleName);
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getSessionFactory().evictCollection(roleName, id);
    }

    public void evictQueries() throws HibernateException {
        this.getSessionFactory().evictQueries();
    }

    public void evictQueries(String cacheRegion) throws HibernateException {
        this.getSessionFactory().evictQueries(cacheRegion);
    }

    public StatelessSession openStatelessSession() {
        return this.getSessionFactory().openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.getSessionFactory().openStatelessSession(connection);
    }

    public Reference getReference() throws NamingException {
        return this.getSessionFactory().getReference();
    }
}

