/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.jboss.ejb3.EJB3Util;

public class InjectedEntityManagerFactory
implements EntityManagerFactory,
Serializable {
    private transient EntityManagerFactory delegate;
    private String jndiName;
    private Hashtable initialContextProperties;

    public InjectedEntityManagerFactory(EntityManagerFactory delegate, String jndiName, Hashtable initialContextProperties) {
        this.delegate = delegate;
        this.jndiName = jndiName;
        this.initialContextProperties = initialContextProperties;
    }

    public InjectedEntityManagerFactory(EntityManagerFactory delegate, Hashtable initialContextProperties) {
        this(delegate, "java:comp.ejb3/EntityManagerFactory", initialContextProperties);
    }

    private EntityManagerFactory getDelegate() {
        if (this.delegate == null) {
            try {
                InitialContext ctx = EJB3Util.getInitialContext(this.initialContextProperties);
                this.delegate = (EntityManagerFactory)ctx.lookup(this.jndiName);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.delegate;
    }

    public EntityManager createEntityManager() {
        return this.getDelegate().createEntityManager();
    }

    public EntityManager createEntityManager(PersistenceContextType type) {
        return this.getDelegate().createEntityManager(type);
    }

    public EntityManager getEntityManager() {
        return this.getDelegate().getEntityManager();
    }

    public void close() {
        throw new IllegalStateException("It is illegal to close an injected EntityManagerFactory");
    }

    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }
}

