/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.dd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ejb.TransactionManagementType;
import org.jboss.ejb3.dd.ClusterConfig;
import org.jboss.ejb3.dd.Consumer;
import org.jboss.ejb3.dd.EjbLocalRef;
import org.jboss.ejb3.dd.EjbRef;
import org.jboss.ejb3.dd.EntityEnterpriseBean;
import org.jboss.ejb3.dd.EnvEntry;
import org.jboss.ejb3.dd.Injectable;
import org.jboss.ejb3.dd.Invoker;
import org.jboss.ejb3.dd.MessageDestinationRef;
import org.jboss.ejb3.dd.MessageDrivenBean;
import org.jboss.ejb3.dd.MethodAttributes;
import org.jboss.ejb3.dd.ResourceEnvRef;
import org.jboss.ejb3.dd.ResourceRef;
import org.jboss.ejb3.dd.SecurityIdentity;
import org.jboss.ejb3.dd.Service;
import org.jboss.ejb3.dd.SessionEnterpriseBean;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnterpriseBean
implements Injectable {
    private static final Logger log = Logger.getLogger(EnterpriseBean.class);
    public static final String BEAN = "Bean";
    public static final String CONTAINER = "Container";
    private String ejbName = null;
    private String home = null;
    private String remote = null;
    private String localHome = null;
    private String local = null;
    private String ejbClass = null;
    private List<EjbLocalRef> ejbLocalRefs = new ArrayList<EjbLocalRef>();
    private List<EjbRef> ejbRefs = new ArrayList<EjbRef>();
    private List<EnvEntry> envEntries = new ArrayList<EnvEntry>();
    private List<ResourceEnvRef> resourceEnvRefs = new ArrayList<ResourceEnvRef>();
    private List<ResourceRef> resourceRefs = new ArrayList<ResourceRef>();
    private List<Invoker> invokers = new ArrayList<Invoker>();
    private SecurityIdentity securityIdentity;
    protected TransactionManagementType tmType = null;
    private List messageDestinationRefs = new ArrayList();
    private String jndiName;
    private String localJndiName;
    private String securityDomain;
    private boolean callByValue = false;
    private ClusterConfig clusterConfig = null;
    private String aopDomainName = null;
    private MethodAttributes methodAttributes = null;
    private Collection<String> dependencies = new HashSet<String>();

    public void addDependency(String depends) {
        this.dependencies.add(depends);
    }

    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    public void mergeMessageDestinationRef(MessageDestinationRef ref) {
        String resRefName = ref.getMessageDestinationRefName();
        Iterator refs = this.messageDestinationRefs.iterator();
        boolean found = false;
        while (!found && refs.hasNext()) {
            MessageDestinationRef tmpRef = (MessageDestinationRef)refs.next();
            if (!tmpRef.getMessageDestinationRefName().equals(resRefName)) continue;
            found = true;
            tmpRef.merge(ref);
        }
    }

    public void mergeResourceRef(ResourceRef ref) {
        String resRefName = ref.getResRefName();
        Iterator<ResourceRef> refs = this.resourceRefs.iterator();
        boolean found = false;
        while (!found && refs.hasNext()) {
            ResourceRef tmpRef = refs.next();
            if (!tmpRef.getResRefName().equals(resRefName)) continue;
            found = true;
            tmpRef.merge(ref);
        }
    }

    public void mergeResourceEnvRef(ResourceEnvRef ref) {
        String resRefName = ref.getResRefName();
        Iterator<ResourceEnvRef> refs = this.resourceEnvRefs.iterator();
        boolean found = false;
        while (!found && refs.hasNext()) {
            ResourceEnvRef tmpRef = refs.next();
            if (!tmpRef.getResRefName().equals(resRefName)) continue;
            found = true;
            tmpRef.merge(ref);
        }
    }

    public void setMethodAttributes(MethodAttributes methodAttributes) {
        this.methodAttributes = methodAttributes;
    }

    public MethodAttributes getMethodAttributes() {
        return this.methodAttributes;
    }

    public void addInvoker(Invoker invoker) {
        this.invokers.add(invoker);
    }

    public List getInvokers() {
        return this.invokers;
    }

    public void updateEjbRef(EjbRef updatedRef) {
        for (EjbRef ref : this.ejbRefs) {
            if (!ref.getEjbRefName().equals(updatedRef.getEjbRefName())) continue;
            ref.setJndiName(updatedRef.getJndiName());
        }
    }

    public void updateEjbLocalRef(EjbLocalRef updatedRef) {
        for (EjbLocalRef ref : this.ejbLocalRefs) {
            if (!ref.getEjbRefName().equals(updatedRef.getEjbRefName())) continue;
            ref.setJndiName(updatedRef.getJndiName());
        }
    }

    public void setAopDomainName(String aopDomainName) {
        this.aopDomainName = aopDomainName;
    }

    public String getAopDomainName() {
        return this.aopDomainName;
    }

    public void setClusterConfig(ClusterConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
    }

    public boolean isClustered() {
        return this.clusterConfig != null;
    }

    public ClusterConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public void setRunAsPrincipal(String principal) {
        if (this.securityIdentity != null) {
            this.securityIdentity.setRunAsPrincipal(principal);
        }
    }

    public void setCallByValue(boolean callByValue) {
        this.callByValue = callByValue;
    }

    public boolean isCallByValue() {
        return this.callByValue;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    @Override
    public List<MessageDestinationRef> getMessageDestinationRefs() {
        return this.messageDestinationRefs;
    }

    public void addMessageDestinationRef(MessageDestinationRef messageDestinationRef) {
        this.messageDestinationRefs.add(messageDestinationRef);
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getLocalJndiName() {
        return this.localJndiName;
    }

    public void setLocalJndiName(String localJndiName) {
        this.localJndiName = localJndiName;
    }

    public TransactionManagementType getTransactionManagementType() {
        return this.tmType;
    }

    public void setTransactionManagementType(String transactionType) {
        if (transactionType.equals(BEAN)) {
            this.tmType = TransactionManagementType.BEAN;
        } else if (transactionType.equals(CONTAINER)) {
            this.tmType = TransactionManagementType.CONTAINER;
        }
    }

    public boolean isSessionBean() {
        return this instanceof SessionEnterpriseBean;
    }

    public boolean isConsumer() {
        return this instanceof Consumer;
    }

    public boolean isEntityBean() {
        return this instanceof EntityEnterpriseBean;
    }

    public boolean isMessageDrivenBean() {
        return this instanceof MessageDrivenBean;
    }

    public boolean isService() {
        return this instanceof Service;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getRemote() {
        return this.remote;
    }

    public void setRemote(String remote) {
        this.remote = remote;
    }

    public String getLocalHome() {
        return this.localHome;
    }

    public void setLocalHome(String localHome) {
        this.localHome = localHome;
    }

    public String getLocal() {
        return this.local;
    }

    public void setLocal(String local) {
        this.local = local;
    }

    public String getEjbClass() {
        return this.ejbClass;
    }

    public void setEjbClass(String ejbClass) {
        this.ejbClass = ejbClass;
    }

    @Override
    public List<EjbLocalRef> getEjbLocalRefs() {
        return this.ejbLocalRefs;
    }

    public void setEjbLocalRefs(List ejbLocalRefs) {
        this.ejbLocalRefs = ejbLocalRefs;
    }

    public void addEjbLocalRef(EjbLocalRef ref) {
        this.ejbLocalRefs.add(ref);
    }

    @Override
    public List<EjbRef> getEjbRefs() {
        return this.ejbRefs;
    }

    public void setEjbRefs(List ejbRefs) {
        this.ejbRefs = ejbRefs;
    }

    public void addEjbRef(EjbRef ref) {
        this.ejbRefs.add(ref);
    }

    public List getEnvEntries() {
        return this.envEntries;
    }

    public void addEnvEntry(EnvEntry entry) {
        this.envEntries.add(entry);
    }

    @Override
    public List<ResourceEnvRef> getResourceEnvRefs() {
        return this.resourceEnvRefs;
    }

    public void addResourceEnvRef(ResourceEnvRef envRef) {
        this.resourceEnvRefs.add(envRef);
    }

    @Override
    public List<ResourceRef> getResourceRefs() {
        return this.resourceRefs;
    }

    public void addResourceRef(ResourceRef envRef) {
        this.resourceRefs.add(envRef);
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public void setSecurityIdentity(SecurityIdentity securityIdentity) {
        this.securityIdentity = securityIdentity;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ejbName=").append(this.ejbName);
        sb.append(",jndiName=").append(this.jndiName);
        sb.append(",local=").append(this.local);
        sb.append(",remote=").append(this.remote);
        sb.append(",home=").append(this.home);
        sb.append(",localHome=").append(this.localHome);
        sb.append(",ejbClass=").append(this.ejbClass);
        return sb.toString();
    }
}

