/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging.jms;

import com.icesoft.net.messaging.AbstractMessageServiceAdapter;
import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.MessageServiceAdapter;
import com.icesoft.net.messaging.MessageServiceException;
import com.icesoft.net.messaging.jms.JMSProviderConfiguration;
import com.icesoft.net.messaging.jms.JMSProviderConfigurationProperties;
import com.icesoft.net.messaging.jms.JMSPublisherConnection;
import com.icesoft.net.messaging.jms.JMSSubscriberConnection;
import com.icesoft.util.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MessageFormatException;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSAdapter
extends AbstractMessageServiceAdapter
implements MessageServiceAdapter {
    private static final Log LOG = LogFactory.getLog((Class)JMSAdapter.class);
    private JMSProviderConfiguration[] jmsProviderConfigurations;
    private int index;
    private InitialContext initialContext;
    private TopicConnectionFactory topicConnectionFactory;
    private ExecutorService executorService;

    public JMSAdapter(JMSProviderConfiguration jmsProviderConfiguration) throws IllegalArgumentException {
        super(jmsProviderConfiguration);
        this.index = -1;
        this.jmsProviderConfigurations = new JMSProviderConfiguration[]{jmsProviderConfiguration};
        ThreadFactory _threadFactory = new ThreadFactory();
        _threadFactory.setPrefix("MessageReceiver Thread");
        this.executorService = Executors.newCachedThreadPool((edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory)_threadFactory);
    }

    public JMSAdapter(ServletContext servletContext) throws IllegalArgumentException {
        block10: {
            super(servletContext);
            this.index = -1;
            String _messagingProperties = servletContext.getInitParameter("com.icesoft.net.messaging.properties");
            LOG.info((Object)("Messaging Properties (web.xml): " + _messagingProperties));
            if (_messagingProperties != null) {
                try {
                    this.jmsProviderConfigurations = new JMSProviderConfiguration[]{new JMSProviderConfigurationProperties(this.getClass().getResourceAsStream(_messagingProperties))};
                }
                catch (IOException exception) {
                    if (!LOG.isErrorEnabled()) break block10;
                    LOG.error((Object)("An error occurred while reading properties: " + _messagingProperties), (Throwable)exception);
                }
            }
        }
        if (this.jmsProviderConfigurations == null) {
            String _serverInfo = servletContext.getServerInfo();
            LOG.info((Object)("Server Info: " + _serverInfo));
            if (_serverInfo.startsWith("Sun Java System Application Server")) {
                LOG.info((Object)"Messaging Properties: glassfish.properties");
                this.jmsProviderConfigurations = this.getJMSProviderConfigurations(new String[]{"glassfish.properties"});
            } else if (_serverInfo.startsWith("JBoss")) {
                LOG.info((Object)"Messaging Properties: jboss_ha.properties, jboss.properties");
                this.jmsProviderConfigurations = this.getJMSProviderConfigurations(new String[]{"jboss_ha.properties", "jboss.properties"});
            } else if (_serverInfo.startsWith("Apache Tomcat")) {
                LOG.info((Object)"Messaging Properties: activemq.properties, jboss_ha.properties, jboss.properties");
                this.jmsProviderConfigurations = this.getJMSProviderConfigurations(new String[]{"activemq.properties", "jboss_ha.properties", "jboss.properties"});
            } else {
                LOG.info((Object)"Messaging Properties: <empty>");
                this.jmsProviderConfigurations = new JMSProviderConfiguration[0];
            }
        }
        ThreadFactory _threadFactory = new ThreadFactory();
        _threadFactory.setPrefix("MessageReceiver Thread");
        this.executorService = Executors.newCachedThreadPool((edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory)_threadFactory);
    }

    public void addMessageHandler(MessageHandler messageHandler, String topicName) {
        if (messageHandler != null && topicName != null && topicName.trim().length() != 0 && this.topicSubscriberMap.containsKey(topicName)) {
            ((JMSSubscriberConnection)this.topicSubscriberMap.get(topicName)).addMessageHandler(messageHandler);
        }
    }

    public void close() throws MessageServiceException {
        if (!this.topicPublisherMap.isEmpty()) {
            Iterator _jmsPublisherConnections = this.topicPublisherMap.values().iterator();
            while (_jmsPublisherConnections.hasNext()) {
                try {
                    ((JMSPublisherConnection)_jmsPublisherConnections.next()).close();
                }
                catch (JMSException exception) {
                    throw new MessageServiceException(exception);
                }
            }
            this.topicPublisherMap.clear();
        }
        if (!this.topicSubscriberMap.isEmpty()) {
            Iterator _jmsSubscriberConnections = this.topicSubscriberMap.values().iterator();
            while (_jmsSubscriberConnections.hasNext()) {
                try {
                    ((JMSSubscriberConnection)_jmsSubscriberConnections.next()).close();
                }
                catch (JMSException exception) {
                    throw new MessageServiceException(exception);
                }
            }
            this.topicSubscriberMap.clear();
        }
        this.executorService.shutdown();
        this.topicConnectionFactory = null;
        try {
            this.initialContext.close();
        }
        catch (NamingException exception) {
            throw new MessageServiceException(exception);
        }
        this.initialContext = null;
    }

    public JMSProviderConfiguration getJMSProviderConfiguration() {
        return this.index != -1 ? this.jmsProviderConfigurations[this.index] : null;
    }

    public void publish(Message message, String topicName) throws MessageServiceException {
        if (message != null && topicName != null && topicName.trim().length() != 0) {
            JMSPublisherConnection _jmsPublisherConnection;
            if (this.topicConnectionFactory == null) {
                try {
                    this.initialize();
                }
                catch (NamingException exception) {
                    throw new MessageServiceException(exception);
                }
            }
            if (!this.topicPublisherMap.containsKey(topicName)) {
                try {
                    _jmsPublisherConnection = new JMSPublisherConnection(this.lookUpTopic(topicName), this);
                }
                catch (NamingException exception) {
                    throw new MessageServiceException(exception);
                }
                try {
                    _jmsPublisherConnection.open();
                    this.topicPublisherMap.put(topicName, _jmsPublisherConnection);
                }
                catch (JMSSecurityException exception) {
                    throw new MessageServiceException(exception);
                }
                catch (JMSException exception) {
                    throw new MessageServiceException(exception);
                }
            }
            _jmsPublisherConnection = (JMSPublisherConnection)this.topicPublisherMap.get(topicName);
            try {
                _jmsPublisherConnection.publish(message);
            }
            catch (InvalidDestinationException exception) {
                throw new MessageServiceException(exception);
            }
            catch (MessageFormatException exception) {
                throw new MessageServiceException(exception);
            }
            catch (JMSException exception) {
                throw new MessageServiceException(exception);
            }
        }
    }

    public void removeMessageHandler(MessageHandler messageHandler, String topicName) {
        if (messageHandler != null && topicName != null && topicName.trim().length() != 0 && this.topicSubscriberMap.containsKey(topicName)) {
            ((JMSSubscriberConnection)this.topicSubscriberMap.get(topicName)).removeMessageHandler(messageHandler);
        }
    }

    public void start() throws MessageServiceException {
        if (!this.topicSubscriberMap.isEmpty()) {
            Iterator _jmsSubscriberConnections = this.topicSubscriberMap.values().iterator();
            MessageServiceException _messageServiceException = null;
            while (_jmsSubscriberConnections.hasNext()) {
                try {
                    ((JMSSubscriberConnection)_jmsSubscriberConnections.next()).start();
                }
                catch (JMSException exception) {
                    if (_messageServiceException != null) continue;
                    _messageServiceException = new MessageServiceException(exception);
                }
            }
            if (_messageServiceException != null) {
                throw _messageServiceException;
            }
        }
    }

    public void stop() throws MessageServiceException {
        if (!this.topicSubscriberMap.isEmpty()) {
            Iterator _jmsSubscriberConnections = this.topicSubscriberMap.values().iterator();
            MessageServiceException _messageServiceException = null;
            while (_jmsSubscriberConnections.hasNext()) {
                try {
                    ((JMSSubscriberConnection)_jmsSubscriberConnections.next()).stop();
                }
                catch (JMSException exception) {
                    if (_messageServiceException != null) continue;
                    _messageServiceException = new MessageServiceException(exception);
                }
            }
            if (_messageServiceException != null) {
                throw _messageServiceException;
            }
        }
    }

    public void subscribe(String topicName, MessageSelector messageSelector, boolean noLocal) throws MessageServiceException {
        if (topicName != null && topicName.trim().length() != 0) {
            JMSSubscriberConnection _jmsSubscriberConnection;
            if (this.topicConnectionFactory == null) {
                try {
                    this.initialize();
                }
                catch (NamingException exception) {
                    throw new MessageServiceException(exception);
                }
            }
            if (!this.topicSubscriberMap.containsKey(topicName)) {
                try {
                    _jmsSubscriberConnection = new JMSSubscriberConnection(this.lookUpTopic(topicName), this);
                }
                catch (NamingException exception) {
                    throw new MessageServiceException(exception);
                }
                try {
                    _jmsSubscriberConnection.open();
                    this.topicSubscriberMap.put(topicName, _jmsSubscriberConnection);
                }
                catch (JMSSecurityException exception) {
                    throw new MessageServiceException(exception);
                }
                catch (JMSException exception) {
                    throw new MessageServiceException(exception);
                }
            }
            _jmsSubscriberConnection = (JMSSubscriberConnection)this.topicSubscriberMap.get(topicName);
            try {
                _jmsSubscriberConnection.subscribe(messageSelector, noLocal);
            }
            catch (InvalidDestinationException exception) {
                throw new MessageServiceException(exception);
            }
            catch (InvalidSelectorException exception) {
                throw new MessageServiceException(exception);
            }
            catch (JMSException exception) {
                throw new MessageServiceException(exception);
            }
        }
    }

    public void unsubscribe(String topicName) throws MessageServiceException {
        if (topicName != null && topicName.trim().length() != 0 && this.topicSubscriberMap.containsKey(topicName)) {
            try {
                ((JMSSubscriberConnection)this.topicSubscriberMap.get(topicName)).unsubscribe();
            }
            catch (JMSException exception) {
                throw new MessageServiceException(exception);
            }
        }
    }

    TopicConnectionFactory getTopicConnectionFactory() {
        return this.topicConnectionFactory;
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    private JMSProviderConfiguration[] getJMSProviderConfigurations(String[] properties) {
        ArrayList<JMSProviderConfigurationProperties> _jmsProviderConfigurationSet = new ArrayList<JMSProviderConfigurationProperties>();
        for (int i = 0; i < properties.length; ++i) {
            try {
                _jmsProviderConfigurationSet.add(new JMSProviderConfigurationProperties(this.getClass().getResourceAsStream(properties[i])));
                continue;
            }
            catch (IOException exception) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("An error occurred while reading properties: " + properties[i]), (Throwable)exception);
            }
        }
        return _jmsProviderConfigurationSet.toArray(new JMSProviderConfiguration[_jmsProviderConfigurationSet.size()]);
    }

    private void initialize() throws NamingException {
        Properties _environmentProperties = new Properties();
        for (int i = 0; i < this.jmsProviderConfigurations.length; ++i) {
            String _urlPackagePrefixes;
            String _providerUrl;
            String _initialContextFactory = this.jmsProviderConfigurations[i].getInitialContextFactory();
            if (_initialContextFactory != null) {
                _environmentProperties.setProperty("java.naming.factory.initial", _initialContextFactory);
            }
            if ((_providerUrl = this.jmsProviderConfigurations[i].getProviderURL()) != null) {
                _environmentProperties.setProperty("java.naming.provider.url", _providerUrl);
            }
            if ((_urlPackagePrefixes = this.jmsProviderConfigurations[i].getURLPackagePrefixes()) != null) {
                _environmentProperties.setProperty("java.naming.factory.url.pkgs", _urlPackagePrefixes);
            }
            if (LOG.isInfoEnabled()) {
                StringBuffer _environment = new StringBuffer();
                _environment.append("Trying JMS Environment:\r\n");
                Iterator<Map.Entry<Object, Object>> _properties = _environmentProperties.entrySet().iterator();
                while (_properties.hasNext()) {
                    Map.Entry<Object, Object> _property = _properties.next();
                    _environment.append("        ");
                    _environment.append(_property.getKey());
                    _environment.append(" = ");
                    _environment.append(_property.getValue());
                    _environment.append("\r\n");
                }
                LOG.info((Object)_environment.toString());
            }
            try {
                this.initialContext = new InitialContext(_environmentProperties);
                this.topicConnectionFactory = (TopicConnectionFactory)this.initialContext.lookup(this.jmsProviderConfigurations[i].getTopicConnectionFactoryName());
                this.index = i;
                break;
            }
            catch (NamingException exception) {
                LOG.error((Object)("Failed JMS Environment: " + exception.getMessage()));
                if (this.initialContext != null) {
                    try {
                        this.initialContext.close();
                    }
                    catch (NamingException e) {
                        // empty catch block
                    }
                }
                if (i + 1 != this.jmsProviderConfigurations.length) continue;
                throw exception;
            }
        }
    }

    private Topic lookUpTopic(String topicName) throws NamingException {
        String _topicNamePrefix = this.jmsProviderConfigurations[this.index].getTopicNamePrefix();
        try {
            return (Topic)this.initialContext.lookup((_topicNamePrefix == null ? "" : _topicNamePrefix) + topicName);
        }
        catch (NamingException exception) {
            try {
                if ("icefacesContextEventTopic".equals(topicName)) {
                    return (Topic)this.initialContext.lookup((_topicNamePrefix == null ? "" : _topicNamePrefix) + "icefaces.contextEventTopic");
                }
                if ("icefacesRenderTopic".equals(topicName)) {
                    return (Topic)this.initialContext.lookup((_topicNamePrefix == null ? "" : _topicNamePrefix) + "icefaces.renderTopic");
                }
                if ("icefacesResponseTopic".equals(topicName)) {
                    return (Topic)this.initialContext.lookup((_topicNamePrefix == null ? "" : _topicNamePrefix) + "icefaces.responseTopic");
                }
                throw exception;
            }
            catch (NamingException e) {
                throw exception;
            }
        }
    }
}

