/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.core.SessionExpiredException;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SessionDispatcher
implements PseudoServlet {
    private static final Log Log = LogFactory.getLog((Class)SessionDispatcher.class);
    private static final List SessionDispatchers = new ArrayList();
    private static final Map SessionMonitors = new HashMap();
    private Map sessionBoundServers = new HashMap();
    private PseudoServlet invalidRequestServlet;

    protected SessionDispatcher() {
        this(new PseudoServlet(){

            public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
                throw new SessionExpiredException();
            }

            public void shutdown() {
            }
        });
    }

    protected SessionDispatcher(PseudoServlet invalidRequestServlet) {
        this.invalidRequestServlet = invalidRequestServlet;
        SessionDispatchers.add(this);
    }

    protected abstract PseudoServlet newServlet(HttpSession var1, Monitor var2) throws Exception;

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.isRequestedSessionIdValid() || "GET".equalsIgnoreCase(request.getMethod())) {
            HttpSession session = request.getSession(true);
            SessionDispatcher.notifyIfNew(session);
            this.lookupServlet(session).service(request, response);
        } else {
            this.invalidRequestServlet.service(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyIfNew(HttpSession session) {
        Map map = SessionMonitors;
        synchronized (map) {
            if (!SessionMonitors.containsKey(session.getId())) {
                SessionDispatcher.notifySessionInitialized(session);
            }
        }
    }

    protected PseudoServlet lookupServlet(HttpSession session) {
        return this.lookupServlet(session.getId());
    }

    protected PseudoServlet lookupServlet(String sessionId) {
        return (PseudoServlet)this.sessionBoundServers.get(sessionId);
    }

    public void shutdown() {
        Iterator i = this.sessionBoundServers.values().iterator();
        while (i.hasNext()) {
            PseudoServlet server = (PseudoServlet)i.next();
            server.shutdown();
        }
    }

    private void sessionCreated(HttpSession session, Monitor monitor) {
        try {
            this.sessionBoundServers.put(session.getId(), this.newServlet(session, monitor));
        }
        catch (Exception e) {
            Log.warn((Object)e);
            throw new RuntimeException(e);
        }
        catch (Throwable t) {
            Log.warn((Object)t);
            throw new RuntimeException(t);
        }
    }

    private void sessionShutdown(HttpSession session) {
        PseudoServlet servlet = (PseudoServlet)this.sessionBoundServers.get(session.getId());
        servlet.shutdown();
    }

    private void sessionDestroy(HttpSession session) {
        this.sessionBoundServers.remove(session.getId());
    }

    private static void notifySessionInitialized(HttpSession session) {
        Monitor monitor = new Monitor(session);
        SessionMonitors.put(session.getId(), monitor);
        Iterator i = SessionDispatchers.iterator();
        while (i.hasNext()) {
            try {
                SessionDispatcher sessionDispatcher = (SessionDispatcher)i.next();
                sessionDispatcher.sessionCreated(session, monitor);
            }
            catch (Exception e) {
                Log.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifySessionShutdown(HttpSession session, boolean invalidateSession) {
        String sessionID;
        if (Log.isDebugEnabled()) {
            Log.debug((Object)("Shutting down session: " + session.getId()));
        }
        if (!SessionMonitors.containsKey(sessionID = session.getId())) {
            if (Log.isDebugEnabled()) {
                Log.debug((Object)("Session: " + sessionID + " already shutdown, skipping"));
            }
            return;
        }
        Iterator i = SessionDispatchers.iterator();
        while (i.hasNext()) {
            try {
                SessionDispatcher sessionDispatcher = (SessionDispatcher)i.next();
                sessionDispatcher.sessionShutdown(session);
            }
            catch (Exception e) {
                Log.error((Object)e);
            }
        }
        Map map = SessionMonitors;
        synchronized (map) {
            i = SessionDispatchers.iterator();
            while (i.hasNext()) {
                try {
                    SessionDispatcher sessionDispatcher = (SessionDispatcher)i.next();
                    sessionDispatcher.sessionDestroy(session);
                }
                catch (Exception e) {
                    Log.error((Object)e);
                }
            }
            SessionMonitors.remove(sessionID);
            try {
                if (invalidateSession) {
                    session.invalidate();
                }
            }
            catch (IllegalStateException e) {
                Log.info((Object)"Session already invalidated.");
            }
        }
    }

    public static PseudoServlet getSingletonSessionServlet(HttpSession session) {
        return SessionDispatcher.getSingletonSessionServlet(session.getId());
    }

    public static PseudoServlet getSingletonSessionServlet(String sessionId) {
        return ((SessionDispatcher)SessionDispatchers.get(0)).lookupServlet(sessionId);
    }

    public static class Monitor {
        private HttpSession session;
        private long lastAccess;

        private Monitor(HttpSession session) {
            this.session = session;
            this.lastAccess = session.getLastAccessedTime();
        }

        public void touchSession() {
            this.lastAccess = System.currentTimeMillis();
        }

        public Date expiresBy() {
            return new Date(this.lastAccess + (long)(this.session.getMaxInactiveInterval() * 1000));
        }

        public boolean isExpired() {
            long maxInterval;
            long elapsedInterval = System.currentTimeMillis() - this.lastAccess;
            return elapsedInterval + 15000L > (maxInterval = (long)(this.session.getMaxInactiveInterval() * 1000));
        }

        public void shutdown() {
            SessionDispatcher.notifySessionShutdown(this.session, true);
        }

        public void shutdownIfExpired() {
            if (this.isExpired()) {
                this.shutdown();
            }
        }
    }

    public static class Listener
    implements ServletContextListener,
    HttpSessionListener {
        private boolean run = true;

        public void contextInitialized(ServletContextEvent servletContextEvent) {
            Thread monitor = new Thread("Session Monitor"){

                public void run() {
                    while (Listener.this.run) {
                        try {
                            Iterator iterator = new ArrayList(SessionMonitors.values()).iterator();
                            while (iterator.hasNext()) {
                                Monitor sessionMonitor = (Monitor)iterator.next();
                                sessionMonitor.shutdownIfExpired();
                            }
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
            monitor.setDaemon(true);
            monitor.start();
        }

        public void contextDestroyed(ServletContextEvent servletContextEvent) {
            this.run = false;
        }

        public void sessionCreated(HttpSessionEvent event) {
        }

        public void sessionDestroyed(HttpSessionEvent event) {
            SessionDispatcher.notifySessionShutdown(event.getSession(), false);
        }
    }
}

