/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.SelectManyCheckboxListRenderer;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class RadioRenderer
extends SelectManyCheckboxListRenderer {
    protected void renderOption(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, boolean renderVertically, Element rootTable, Element rootTR, int counter, Object componentValue) throws IOException {
        String itemLabel;
        UISelectOne uiSelectOne = (UISelectOne)uiComponent;
        DOMContext domContext = DOMContext.getDOMContext(facesContext, (UIComponent)uiSelectOne);
        Object submittedValue = uiSelectOne.getSubmittedValue();
        if (submittedValue == null) {
            submittedValue = componentValue;
        }
        if (renderVertically) {
            rootTR = domContext.createElement("tr");
            rootTable.appendChild(rootTR);
        }
        String labelClass = null;
        boolean disabled = false;
        if (uiSelectOne.getAttributes().get("disabled") != null && uiSelectOne.getAttributes().get("disabled").equals(Boolean.TRUE)) {
            disabled = true;
        }
        if (selectItem.isDisabled()) {
            disabled = true;
        }
        if ((labelClass = (String)uiSelectOne.getAttributes().get("styleClass")) != null && disabled) {
            labelClass = labelClass + "-dis";
        }
        Element td = domContext.createElement("td");
        rootTR.appendChild(td);
        Element input = domContext.createElement("input");
        td.appendChild(input);
        input.setAttribute("type", "radio");
        if (disabled) {
            input.setAttribute("disabled", "disabled");
        }
        HashSet<String> excludes = new HashSet<String>();
        String accesskey = (String)uiComponent.getAttributes().get("accesskey");
        if (accesskey != null) {
            input.setAttribute("accesskey", accesskey);
            excludes.add("accesskey");
        }
        if (this.isValueSelected(facesContext, selectItem, (UIComponent)uiSelectOne)) {
            input.setAttribute("checked", "checked");
        } else {
            input.removeAttribute("checked");
        }
        input.setAttribute("name", uiSelectOne.getClientId(facesContext));
        String inputID = uiComponent.getClientId(facesContext) + ":_" + counter;
        input.setAttribute("id", inputID);
        input.setAttribute("value", this.formatComponentValue(facesContext, (UIComponent)uiSelectOne, selectItem.getValue()));
        excludes.add("style");
        excludes.add("readonly");
        excludes.add("disabled");
        excludes.add("onclick");
        PassThruAttributeRenderer.renderAttributes(facesContext, (UIComponent)uiSelectOne, RadioRenderer.getExcludesArray(excludes));
        Element label = domContext.createElement("label");
        td.appendChild(label);
        label.setAttribute("for", inputID);
        if (labelClass != null) {
            label.setAttribute("class", labelClass);
        }
        if ((itemLabel = selectItem.getLabel()) != null) {
            Text labelText = domContext.getDocument().createTextNode(itemLabel);
            label.appendChild(labelText);
        }
    }

    protected void renderOption(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        UIComponent forComponent = RadioRenderer.findForComponent(facesContext, uiComponent);
        if (!(forComponent instanceof UISelectOne)) {
            throw new IllegalStateException("Could not find UISelectOne component for radio button.");
        }
        String layout = (String)forComponent.getAttributes().get("layout");
        if (layout == null || !layout.equals("spread")) {
            return;
        }
        List selectItemList = this.getSelectItemList(forComponent);
        if (selectItemList.isEmpty()) {
            throw new IllegalStateException("Could not find select items for UISelectOne component.");
        }
        UISelectOne selectOne = (UISelectOne)forComponent;
        int radioIndex = (Integer)uiComponent.getAttributes().get("index");
        if (radioIndex < 0) {
            radioIndex = 0;
        }
        if (radioIndex >= selectItemList.size()) {
            radioIndex = selectItemList.size() - 1;
        }
        SelectItem selectItem = (SelectItem)selectItemList.get(radioIndex);
        String selectOneClientId = selectOne.getClientId(facesContext);
        String radioClientId = selectOneClientId + ":_" + radioIndex;
        String selectItemValue = this.formatComponentValue(facesContext, (UIComponent)selectOne, selectItem.getValue());
        String selectItemLabel = selectItem.getLabel();
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (domContext.isInitialized()) {
            DOMContext.removeChildren(domContext.getRootNode());
        } else {
            domContext.createRootElement("span");
        }
        Node rootNode = domContext.getRootNode();
        HashSet excludes = new HashSet();
        Element input = domContext.createElement("input");
        input.setAttribute("type", "radio");
        input.setAttribute("id", radioClientId);
        input.setAttribute("name", selectOneClientId);
        input.setAttribute("value", selectItemValue);
        if (selectItem.isDisabled()) {
            input.setAttribute("disabled", "disabled");
        }
        if (this.isValueSelected(facesContext, selectItem, (UIComponent)selectOne)) {
            input.setAttribute("checked", "checked");
        }
        this.addJavaScript(facesContext, (UIComponent)selectOne, input, excludes);
        Element label = domContext.createElement("label");
        label.setAttribute("for", radioClientId);
        if (selectItemLabel != null) {
            label.appendChild(domContext.createTextNode(selectItemLabel));
        }
        PassThruAttributeRenderer.renderAttributes(facesContext, (UIComponent)selectOne, input, label, RadioRenderer.getExcludesArray(excludes));
        rootNode.appendChild(input);
        rootNode.appendChild(label);
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    protected void addJavaScript(FacesContext facesContext, UIComponent uiSelectOne, Element input, Set excludes) {
    }
}

