/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.env.AcegiAuthWrapper;
import com.icesoft.faces.env.AuthenticationVerifier;
import com.icesoft.faces.env.RequestAttributes;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.Redirect;
import com.icesoft.faces.webapp.command.SetCookie;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.core.DisposeBeans;
import com.icesoft.util.SeamUtilities;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BridgeExternalContext
extends ExternalContext {
    private static final Log Log = LogFactory.getLog((Class)BridgeExternalContext.class);
    protected static Class AuthenticationClass;
    protected static final RequestAttributes NOOPRequestAttributes;
    protected static final Dispatcher CannotDispatchOnXMLHTTPRequest;
    protected static final AuthenticationVerifier UserInfoNotAvailable;
    protected static final Dispatcher RequestNotAvailable;
    private static final String SEAM_LIFECYCLE_SHORTCUT = "com.icesoft.faces.shortcutLifecycle";
    private static String PostBackKey;
    protected String viewIdentifier;
    protected CommandQueue commandQueue;
    protected boolean standardScope;
    protected Map applicationMap;
    protected Map sessionMap;
    protected Map requestMap;
    protected Map initParameterMap;
    protected Redirector redirector;
    protected CookieTransporter cookieTransporter;
    protected String requestServletPath;
    protected String requestPathInfo;
    protected Map requestParameterMap;
    protected Map requestParameterValuesMap;
    protected Map requestCookieMap;
    protected Map responseCookieMap;
    protected Map requestHeaderMap;
    protected Map requestHeaderValuesMap;

    protected BridgeExternalContext(String viewIdentifier, CommandQueue commandQueue, Configuration configuration) {
        this.viewIdentifier = viewIdentifier;
        this.commandQueue = commandQueue;
        this.standardScope = configuration.getAttributeAsBoolean("standardRequestScope", false);
    }

    public abstract String getRequestURI();

    public abstract Writer getWriter(String var1) throws IOException;

    public abstract void switchToNormalMode();

    public abstract void switchToPushMode();

    public abstract void update(HttpServletRequest var1, HttpServletResponse var2);

    public abstract void updateOnPageLoad(Object var1, Object var2);

    public void addCookie(Cookie cookie) {
        this.responseCookieMap.put(cookie.getName(), cookie);
        this.cookieTransporter.send(cookie);
    }

    public void setRequestPathInfo(String viewId) {
        this.requestPathInfo = viewId;
    }

    public void setRequestServletPath(String viewId) {
        this.requestServletPath = viewId;
    }

    public Map getApplicationSessionMap() {
        return this.sessionMap;
    }

    public Map getResponseCookieMap() {
        return this.responseCookieMap;
    }

    public Map collectBundles() {
        HashMap result = new HashMap();
        Iterator entries = this.requestMap.entrySet().iterator();
        while (entries.hasNext()) {
            String className;
            Map.Entry entry = entries.next();
            Object value = entry.getValue();
            if (value == null || (className = value.getClass().getName()).indexOf("LoadBundleTag") <= 0 && className.indexOf("BundleMap") <= 0) continue;
            result.put(entry.getKey(), value);
        }
        return result;
    }

    public void injectBundles(Map bundles) {
        this.requestMap.putAll(bundles);
    }

    protected void insertPostbackKey() {
        if (null != PostBackKey) {
            this.requestParameterMap.put(PostBackKey, "not reload");
            this.requestParameterValuesMap.put(PostBackKey, new String[]{"not reload"});
        }
    }

    protected void insertNewViewrootToken() {
        if (SeamUtilities.isSeamEnvironment()) {
            this.setSeamLifecycleShortcut();
        }
    }

    public void release() {
        this.resetRequestMap();
    }

    protected void resetRequestMap() {
        if (this.standardScope) {
            DisposeBeans.in(this.requestMap);
            this.requestMap.clear();
        }
    }

    public void dispose() {
        DisposeBeans.in(this.requestMap);
        this.requestMap.clear();
    }

    public void setSeamLifecycleShortcut() {
        this.requestParameterMap.put(SEAM_LIFECYCLE_SHORTCUT, Boolean.TRUE);
    }

    public boolean removeSeamLifecycleShortcut() {
        return this.requestParameterMap.remove(SEAM_LIFECYCLE_SHORTCUT) != null;
    }

    public boolean isSeamLifecycleShortcut() {
        return this.requestParameterMap != null && this.requestParameterMap.containsKey(SEAM_LIFECYCLE_SHORTCUT);
    }

    public Map getApplicationMap() {
        return this.applicationMap;
    }

    public Map getSessionMap() {
        return this.sessionMap;
    }

    public Map getRequestMap() {
        return this.requestMap;
    }

    public void setResponse(Object response) {
    }

    public String getInitParameter(String name) {
        return (String)this.initParameterMap.get(name);
    }

    public Map getInitParameterMap() {
        return this.initParameterMap;
    }

    public void redirect(String requestURI) throws IOException {
        String query;
        URI uri;
        if (SeamUtilities.isSeamEnvironment()) {
            SeamUtilities.switchToCurrentSeamConversation(requestURI);
        }
        String redirectURI = (uri = URI.create(SeamUtilities.encodeSeamConversationId(requestURI, this.viewIdentifier))).isAbsolute() ? uri.toString() : ((query = uri.getQuery()) == null ? uri + "?rvn=" + this.viewIdentifier : (query.matches(".*rvn=.*") ? uri.toString() : uri + "&rvn=" + this.viewIdentifier));
        this.redirector.redirect(redirectURI);
        FacesContext fc = FacesContext.getCurrentInstance();
        if (fc != null) {
            fc.responseComplete();
        }
    }

    public Map getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public Map getRequestParameterValuesMap() {
        return this.requestParameterValuesMap;
    }

    public Iterator getRequestParameterNames() {
        return this.requestParameterMap.keySet().iterator();
    }

    public Map getRequestCookieMap() {
        return this.requestCookieMap;
    }

    protected void recreateParameterAndCookieMaps() {
        this.requestParameterMap = Collections.synchronizedMap(new HashMap());
        this.requestParameterValuesMap = Collections.synchronizedMap(new HashMap());
        this.requestCookieMap = Collections.synchronizedMap(new HashMap());
        this.responseCookieMap = Collections.synchronizedMap(new HashMap());
        this.requestHeaderMap = Collections.synchronizedMap(new HashMap());
        this.requestHeaderValuesMap = Collections.synchronizedMap(new HashMap());
    }

    protected static AuthenticationVerifier createAuthenticationVerifier(final HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        if (AuthenticationClass != null && (null == principal || AuthenticationClass.isInstance(principal))) {
            return new AcegiAuthWrapper(principal);
        }
        return new AuthenticationVerifier(){

            public boolean isUserInRole(String role) {
                if (Log.isTraceEnabled()) {
                    Log.trace((Object)("request.isUserInRole(role) is " + role));
                }
                return request.isUserInRole(role);
            }

            public boolean isReusable() {
                return false;
            }
        };
    }

    protected static AuthenticationVerifier releaseVerifier(AuthenticationVerifier verifier) {
        if (verifier.isReusable()) {
            return verifier;
        }
        return UserInfoNotAvailable;
    }

    static {
        try {
            AuthenticationClass = Class.forName("org.acegisecurity.Authentication");
            Log.debug((Object)"Acegi Security detected.");
        }
        catch (Throwable t) {
            Log.debug((Object)"Acegi Security not detected.");
        }
        NOOPRequestAttributes = new RequestAttributes(){

            public Object getAttribute(String name) {
                return null;
            }

            public Enumeration getAttributeNames() {
                return Collections.enumeration(Collections.EMPTY_LIST);
            }

            public void removeAttribute(String name) {
            }

            public void setAttribute(String name, Object value) {
            }
        };
        CannotDispatchOnXMLHTTPRequest = new Dispatcher(){

            public void dispatch(String path) throws IOException, FacesException {
                throw new IOException("Cannot dispatch on XMLHTTP request.");
            }
        };
        UserInfoNotAvailable = new AuthenticationVerifier(){

            public boolean isUserInRole(String role) {
                throw new RuntimeException("Cannot determine if user in role. User information is not available.");
            }

            public boolean isReusable() {
                return true;
            }
        };
        RequestNotAvailable = new Dispatcher(){

            public void dispatch(String path) throws IOException, FacesException {
                throw new IOException("No request available for dispatch.");
            }
        };
        try {
            Field field = ResponseStateManager.class.getField("VIEW_STATE_PARAM");
            if (null != field) {
                PostBackKey = (String)field.get(ResponseStateManager.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class CommandQueueCookieTransporter
    implements CookieTransporter {
        public void send(Cookie cookie) {
            BridgeExternalContext.this.commandQueue.put(new SetCookie(cookie));
        }
    }

    public class CommandQueueRedirector
    implements Redirector {
        public void redirect(String uri) {
            BridgeExternalContext.this.commandQueue.put(new Redirect(uri));
        }
    }

    public static interface Dispatcher {
        public void dispatch(String var1) throws IOException, FacesException;
    }

    public static interface CookieTransporter {
        public void send(Cookie var1);
    }

    public static interface Redirector {
        public void redirect(String var1);
    }
}

