/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.AsyncRenderer;
import com.icesoft.faces.async.render.RenderManager;
import com.icesoft.faces.async.render.Renderable;
import com.icesoft.faces.context.View;
import com.icesoft.faces.webapp.http.servlet.MainSessionBoundServlet;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.faces.webapp.xmlhttp.RenderingException;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupAsyncRenderer
implements AsyncRenderer {
    private static final Log LOG = LogFactory.getLog((Class)GroupAsyncRenderer.class);
    protected final Set group = new CopyOnWriteArraySet();
    protected boolean broadcasted = false;
    protected String name;
    protected boolean stopRequested = false;

    public void add(Renderable renderable) {
        this.add((Object)renderable);
    }

    public void addCurrentSession() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            this.add(facesContext.getExternalContext().getSession(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set set = this.group;
        synchronized (set) {
            this.group.clear();
        }
    }

    public boolean contains(Renderable renderable) {
        return this.contains((Object)renderable);
    }

    public boolean containsCurrentSession() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext != null && this.contains(facesContext.getExternalContext().getSession(false));
    }

    public void dispose() {
        this.requestStop();
        RenderManager.getInstance().removeRenderer(this);
        this.clear();
        this.name = null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBroadcasted() {
        return this.broadcasted;
    }

    public boolean isEmpty() {
        return this.group.isEmpty();
    }

    public void remove(Renderable renderable) {
        this.remove((Object)renderable);
    }

    public void removeCurrentSession() {
        LOG.info((Object)"GroupAsyncRenderer.removeCurrentSession()");
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            this.remove(facesContext.getExternalContext().getSession(false));
        }
    }

    public void requestRender() {
        this.requestRender(true);
    }

    public void requestStop() {
        this.stopRequested = true;
    }

    public void setBroadcasted(boolean broadcasted) {
        this.broadcasted = broadcasted;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRenderManager(RenderManager renderManager) {
    }

    void requestRender(boolean allowBroadcasting) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.name + " preparing to render " + this.group.size()));
        }
        if (allowBroadcasting && this.isBroadcasted()) {
            RenderManager.getInstance().requestRender(this);
        }
        this.stopRequested = false;
        Iterator i = this.group.iterator();
        while (!this.stopRequested && i.hasNext()) {
            Object object = ((WeakReference)i.next()).get();
            if (object instanceof Renderable) {
                this.requestRender((Renderable)object);
                continue;
            }
            if (object instanceof HttpSession) {
                this.requestRender((HttpSession)object);
                continue;
            }
            if (!(object instanceof PortletSession)) continue;
            this.requestRender((PortletSession)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Object object) {
        Set set = this.group;
        synchronized (set) {
            if (!this.contains(object)) {
                if (this.group.add(new WeakReference<Object>(object))) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(this.name + " added " + object));
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)(this.name + " already contains " + object));
                }
            }
        }
    }

    private boolean contains(Object object) {
        Iterator i = this.group.iterator();
        while (i.hasNext()) {
            if (object != ((WeakReference)i.next()).get()) continue;
            return true;
        }
        return false;
    }

    private boolean isValid(HttpSession httpSession) {
        try {
            httpSession.getAttribute("nonExistentAttribute");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isValid(PortletSession portletSession) {
        try {
            portletSession.getAttribute("nonExistentAttribute");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Object object) {
        Set set = this.group;
        synchronized (set) {
            Iterator i = this.group.iterator();
            while (i.hasNext()) {
                WeakReference reference = (WeakReference)i.next();
                if (object != reference.get()) continue;
                this.group.remove(reference);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(this.name + " removing " + object));
                }
                return;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(this.name + " does not contain " + object));
            }
        }
    }

    private void requestRender(HttpSession httpSession) {
        if (this.isValid(httpSession)) {
            this.requestRender(httpSession.getId());
        } else {
            this.remove(httpSession);
        }
    }

    private void requestRender(PortletSession portletSession) {
        if (this.isValid(portletSession)) {
            this.requestRender(portletSession.getId());
        } else {
            this.remove(portletSession);
        }
    }

    private void requestRender(String sessionId) {
        PersistentFacesState suppressedViewState = FacesContext.getCurrentInstance() != null ? PersistentFacesState.getInstance() : null;
        Iterator i = ((MainSessionBoundServlet)SessionDispatcher.getSingletonSessionServlet(sessionId)).getViews().values().iterator();
        while (i.hasNext()) {
            final PersistentFacesState viewState = ((View)i.next()).getPersistentFacesState();
            if (viewState == suppressedViewState) continue;
            this.requestRender(new Renderable(){

                public PersistentFacesState getState() {
                    return viewState;
                }

                public void renderingException(RenderingException renderingException) {
                }
            });
        }
    }

    private void requestRender(Renderable renderable) {
        RenderManager.getInstance().requestRender(renderable);
    }
}

