/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.plugins.event.AbstractEventEmitter;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventFilter;
import org.jboss.kernel.spi.event.KernelEventListener;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.util.CollectionsFactory;

public class AbstractKernelController
extends AbstractController
implements KernelController,
KernelRegistryPlugin {
    protected Kernel kernel;
    protected AbstractEventEmitter emitterDelegate = new AbstractEventEmitter();
    protected Map suppliers = CollectionsFactory.createConcurrentReaderMap();

    public KernelControllerContext install(BeanMetaData beanMetaData) throws Throwable {
        AbstractKernelControllerContext abstractKernelControllerContext = new AbstractKernelControllerContext(null, beanMetaData, null);
        this.install(abstractKernelControllerContext);
        return abstractKernelControllerContext;
    }

    public KernelRegistryEntry getEntry(Object object) {
        List list = (List)this.suppliers.get(object);
        if (list != null && !list.isEmpty()) {
            return (KernelRegistryEntry)list.get(0);
        }
        return null;
    }

    public synchronized ControllerContext getContext(Object object, ControllerState controllerState) {
        ControllerContext controllerContext = super.getContext(object, controllerState);
        if (controllerContext != null) {
            return controllerContext;
        }
        if (controllerState == null || controllerState == ControllerState.INSTALLED) {
            KernelRegistry kernelRegistry = this.kernel.getRegistry();
            try {
                return kernelRegistry.getEntry(object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized void addSupplies(KernelControllerContext kernelControllerContext) {
        BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
        Set set = beanMetaData.getSupplies();
        if (set != null) {
            boolean bl = this.log.isTraceEnabled();
            if (!set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    SupplyMetaData supplyMetaData = (SupplyMetaData)iterator.next();
                    Object object = supplyMetaData.getSupply();
                    List list = (List)this.suppliers.get(object);
                    if (list == null) {
                        list = CollectionsFactory.createCopyOnWriteList();
                        this.suppliers.put(object, list);
                    }
                    list.add(kernelControllerContext);
                    if (!bl) continue;
                    this.log.trace((Object)("Suppliers of " + object + ": " + list));
                }
            }
        }
    }

    public synchronized void removeSupplies(KernelControllerContext kernelControllerContext) {
        BeanMetaData beanMetaData = kernelControllerContext.getBeanMetaData();
        Set set = beanMetaData.getSupplies();
        if (set != null) {
            boolean bl = this.log.isTraceEnabled();
            if (!set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    SupplyMetaData supplyMetaData = (SupplyMetaData)iterator.next();
                    Object object = supplyMetaData.getSupply();
                    List list = (List)this.suppliers.get(object);
                    if (list == null) continue;
                    list.remove(kernelControllerContext);
                    if (list.isEmpty()) {
                        this.suppliers.remove(object);
                    }
                    if (!bl) continue;
                    this.log.trace((Object)("Suppliers of " + object + ": " + list));
                }
            }
        }
    }

    public Kernel getKernel() {
        Kernel.checkAccess();
        return this.kernel;
    }

    public void setKernel(Kernel kernel) throws Throwable {
        Kernel.checkConfigure();
        this.kernel = kernel;
    }

    public void fireKernelEvent(KernelEvent kernelEvent) {
        this.emitterDelegate.fireKernelEvent(kernelEvent);
    }

    public void registerListener(KernelEventListener kernelEventListener, KernelEventFilter kernelEventFilter, Object object) throws Throwable {
        this.emitterDelegate.registerListener(kernelEventListener, kernelEventFilter, object);
    }

    public void unregisterListener(KernelEventListener kernelEventListener, KernelEventFilter kernelEventFilter, Object object) throws Throwable {
        this.emitterDelegate.unregisterListener(kernelEventListener, kernelEventFilter, object);
    }
}

