/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;

public class WebTestResult
implements Serializable {
    private String exceptionClassName;
    private String exceptionStackTrace;
    private String exceptionMessage;
    public static final String XML_ROOT_ELEMENT = "webresult";
    public static final String XML_EXCEPTION_ELEMENT = "exception";
    public static final String XML_EXCEPTION_CLASSNAME_ATTRIBUTE = "classname";
    public static final String XML_EXCEPTION_MESSAGE_ELEMENT = "message";
    public static final String XML_EXCEPTION_STACKTRACE_ELEMENT = "stacktrace";

    public WebTestResult() {
    }

    public WebTestResult(Throwable theException) {
        this.exceptionClassName = theException.getClass().getName();
        this.exceptionMessage = theException.getMessage();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        theException.printStackTrace(pw);
        this.exceptionStackTrace = sw.toString();
    }

    public WebTestResult(String theClassName, String theMessage, String theStackTrace) {
        this.exceptionClassName = theClassName;
        this.exceptionMessage = theMessage;
        this.exceptionStackTrace = theStackTrace;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public boolean hasException() {
        return this.exceptionClassName != null;
    }

    public String getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.hasException()) {
            buffer.append("Test failed, Exception message = [" + this.getExceptionMessage() + "]");
        } else {
            buffer.append("Test ok");
        }
        return buffer.toString();
    }

    public String toXml() {
        StringBuffer xmlText = new StringBuffer();
        xmlText.append("<webresult>");
        if (this.hasException()) {
            xmlText.append("<exception classname=\"");
            xmlText.append(this.exceptionClassName);
            xmlText.append("\">");
            xmlText.append("<message><![CDATA[");
            xmlText.append(this.exceptionMessage);
            xmlText.append("]]></message>");
            xmlText.append("<stacktrace><![CDATA[");
            xmlText.append(this.exceptionStackTrace);
            xmlText.append("]]></stacktrace>");
            xmlText.append("</exception>");
        }
        xmlText.append("</webresult>");
        return xmlText.toString();
    }
}

