/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import org.apache.cactus.AbstractTestCase;
import org.apache.cactus.WebRequest;
import org.apache.cactus.WebResponse;
import org.apache.cactus.client.AbstractHttpClient;
import org.apache.cactus.util.ChainedRuntimeException;

public abstract class AbstractWebTestCase
extends AbstractTestCase {
    static Class class$java$net$URLConnection;

    public AbstractWebTestCase(String theName) {
        super(theName);
    }

    protected void callEndMethod(WebRequest theRequest, HttpURLConnection theConnection) throws Throwable {
        Method methodToCall = null;
        Object paramObject = null;
        Method[] methods = ((Object)((Object)this)).getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(this.getEndMethodName())) {
                Class<?>[] parameters;
                if (!methods[i].getReturnType().getName().equals("void")) {
                    AbstractWebTestCase.fail((String)("The end method [" + methods[i].getName() + "] should return void and not [" + methods[i].getReturnType().getName() + "]"));
                }
                if (!Modifier.isPublic(methods[i].getModifiers())) {
                    AbstractWebTestCase.fail((String)("Method [" + methods[i].getName() + "] should be declared public"));
                }
                if ((parameters = methods[i].getParameterTypes()).length != 1) {
                    AbstractWebTestCase.fail((String)("The end method [" + methods[i].getName() + "] must only have a single parameter"));
                }
                if (parameters[0].getName().equals("com.meterware.httpunit.WebResponse")) {
                    paramObject = this.createHttpUnitWebResponse(theConnection);
                } else if (parameters[0].getName().equals("org.apache.cactus.WebResponse")) {
                    paramObject = new WebResponse(theRequest, theConnection);
                } else if (parameters[0].getName().equals("java.net.HttpURLConnection")) {
                    paramObject = theConnection;
                } else {
                    AbstractWebTestCase.fail((String)("The end method [" + methods[i].getName() + "] has a bad parameter of type [" + parameters[0].getName() + "]"));
                }
                if (methodToCall != null) {
                    AbstractWebTestCase.fail((String)("There can only be one end method per test case. Test case [" + this.getCurrentTestMethod() + "] has two at least !"));
                }
                methodToCall = methods[i];
            }
            ++i;
        }
        if (methodToCall != null) {
            try {
                methodToCall.invoke((Object)this, paramObject);
            }
            catch (InvocationTargetException e) {
                e.fillInStackTrace();
                throw e.getTargetException();
            }
            catch (IllegalAccessException e) {
                e.fillInStackTrace();
                throw e;
            }
        }
    }

    private Object createHttpUnitWebResponse(HttpURLConnection theConnection) {
        Object webResponse;
        try {
            Class<?> responseClass = Class.forName("com.meterware.httpunit.WebResponse");
            Method method = responseClass.getMethod("newResponse", class$java$net$URLConnection == null ? (class$java$net$URLConnection = AbstractWebTestCase.class$("java.net.URLConnection")) : class$java$net$URLConnection);
            webResponse = method.invoke(null, theConnection);
        }
        catch (Exception e) {
            throw new ChainedRuntimeException("Error calling [public static com.meterware.httpunit.WebResponse com.meterware.httpunit.WebResponse.newResponse(java.net.URLConnection) throws java.io.IOException]", e);
        }
        return webResponse;
    }

    protected void runGenericTest(AbstractHttpClient theHttpClient) throws Throwable {
        WebRequest request = new WebRequest();
        this.callBeginMethod(request);
        request.addParameter("Cactus_TestClass", ((Object)((Object)this)).getClass().getName(), "GET");
        request.addParameter("Cactus_TestMethod", this.getCurrentTestMethod(), "GET");
        request.addParameter("Cactus_AutomaticSession", request.getAutomaticSession() ? "true" : "false", "GET");
        if (request.getURL() != null) {
            request.getURL().saveToRequest(request);
        }
        HttpURLConnection connection = theHttpClient.doTest(request);
        this.callEndMethod(request, connection);
        connection.getInputStream().close();
    }

    static Class class$(String name$) throws NoClassDefFoundError {
        try {
            return Class.forName(name$);
        }
        catch (ClassNotFoundException exn$) {
            throw new NoClassDefFoundError(exn$.getMessage());
        }
    }
}

