/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.InitialFact;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldExtractor;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.EvaluatorFactory;
import org.drools.base.FieldFactory;
import org.drools.common.BetaNodeBinder;
import org.drools.common.InstanceEqualsConstraint;
import org.drools.common.InstanceNotEqualsConstraint;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkListFactory;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.QueryTerminalNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.rule.And;
import org.drools.rule.Column;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.Exists;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Not;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldConstraint;
import org.drools.spi.FieldValue;
import org.drools.spi.ObjectTypeResolver;

class ReteooBuilder
implements Serializable {
    private static final long serialVersionUID = 1737643968218792944L;
    private transient ReteooRuleBase ruleBase;
    private transient Rete rete;
    private transient ReteooWorkingMemory[] workingMemories;
    private final ObjectTypeResolver resolver;
    private TupleSource tupleSource;
    private ObjectSource objectSource;
    private Map declarations;
    private int id;
    private Map rules;
    private Map objectType;
    private int currentOffsetAdjustment;
    private transient ObjectSinkListFactory sinklistFactory;

    ReteooBuilder(ReteooRuleBase reteooRuleBase, ObjectTypeResolver objectTypeResolver) {
        this.ruleBase = reteooRuleBase;
        this.rete = this.ruleBase.getRete();
        this.resolver = objectTypeResolver;
        this.rules = new HashMap();
        this.id = 1;
        this.sinklistFactory = new ObjectSinkListFactory(this.ruleBase.getConfiguration());
    }

    void setRuleBase(ReteooRuleBase reteooRuleBase) {
        this.ruleBase = reteooRuleBase;
    }

    void setRete(Rete rete) {
    }

    void addRule(Rule rule) throws InvalidPatternException {
        this.workingMemories = this.ruleBase.getWorkingMemories().toArray(new ReteooWorkingMemory[this.ruleBase.getWorkingMemories().size()]);
        this.currentOffsetAdjustment = 0;
        ArrayList<BaseNode> arrayList = new ArrayList<BaseNode>();
        And[] andArray = rule.getTransformedLhs();
        for (int i = 0; i < andArray.length; ++i) {
            if (!this.hasColumns(andArray[i])) {
                this.addInitialFactMatch(andArray[i]);
            }
            this.addRule(andArray[i], rule);
            BaseNode baseNode = null;
            if (!(rule instanceof Query)) {
                if (rule.getConsequence() == null) {
                    throw new InvalidPatternException("Rule '" + rule.getName() + "' has no Consequence");
                }
                baseNode = new TerminalNode(this.id++, this.tupleSource, rule);
            } else {
                if (rule.getConsequence() != null) {
                    throw new InvalidPatternException("Query '" + rule.getName() + "' should have no Consequence");
                }
                baseNode = new QueryTerminalNode(this.id++, this.tupleSource, rule);
            }
            arrayList.add(baseNode);
            if (this.workingMemories.length == 0) {
                baseNode.attach();
                continue;
            }
            baseNode.attach(this.workingMemories);
        }
        this.rules.put(rule, arrayList.toArray(new BaseNode[arrayList.size()]));
    }

    private boolean hasColumns(GroupElement groupElement) {
        Iterator iterator = groupElement.getChildren().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Column) && (!(e instanceof GroupElement) || !this.hasColumns((GroupElement)e))) continue;
            return true;
        }
        return false;
    }

    private void addInitialFactMatch(And and) {
        And and2 = null;
        if (!and.getChildren().isEmpty()) {
            and2 = (And)and.clone();
            and.getChildren().clear();
        }
        Column column = new Column(0, new ClassObjectType(InitialFact.class));
        and.addChild(column);
        if (and2 != null) {
            and.getChildren().addAll(and2.getChildren());
        }
    }

    private void addRule(And and, Rule rule) throws InvalidPatternException {
        this.objectSource = null;
        this.tupleSource = null;
        this.declarations = new HashMap();
        this.objectType = new LinkedHashMap();
        if (rule instanceof Query) {
            this.attachQuery(rule.getName());
        }
        Iterator iterator = and.getChildren().iterator();
        while (iterator.hasNext()) {
            Column column;
            Serializable serializable;
            Object e = iterator.next();
            if (e instanceof EvalCondition) {
                serializable = (EvalCondition)e;
                this.checkUnboundDeclarations(serializable.getRequiredDeclarations());
                this.tupleSource = (TupleSource)this.attachNode(new EvalConditionNode(this.id++, this.tupleSource, (EvalCondition)serializable));
                continue;
            }
            if (e instanceof Column) {
                column = (Column)e;
                serializable = this.attachColumn((Column)e, and, true);
                if (this.tupleSource == null) {
                    this.tupleSource = (TupleSource)this.attachNode(new LeftInputAdapterNode(this.id++, this.objectSource, (BetaNodeBinder)serializable));
                    this.objectSource = null;
                }
            } else {
                GroupElement groupElement = (GroupElement)e;
                while (!(groupElement.getChildren().get(0) instanceof Column)) {
                    groupElement = (GroupElement)groupElement.getChildren().get(0);
                }
                column = (Column)groupElement.getChildren().get(0);
                if (this.tupleSource == null) {
                    this.currentOffsetAdjustment = 1;
                    this.objectSource = (ObjectSource)this.attachNode(new ObjectTypeNode(this.id++, this.sinklistFactory.newObjectSinkList(class$org$drools$reteoo$ObjectTypeNode == null ? ReteooBuilder.class$("org.drools.reteoo.ObjectTypeNode") : class$org$drools$reteoo$ObjectTypeNode), new ClassObjectType(class$org$drools$InitialFact == null ? ReteooBuilder.class$("org.drools.InitialFact") : class$org$drools$InitialFact), this.rete));
                    this.tupleSource = (TupleSource)this.attachNode(new LeftInputAdapterNode(this.id++, this.objectSource));
                    this.objectSource = null;
                }
                serializable = this.attachColumn(column, and, true);
            }
            if (e instanceof Not) {
                this.attachNot(this.tupleSource, (Not)e, this.objectSource, (BetaNodeBinder)serializable, column);
                continue;
            }
            if (e instanceof Exists) {
                this.attachExists(this.tupleSource, (Exists)e, this.objectSource, (BetaNodeBinder)serializable, column);
                continue;
            }
            if (this.objectSource == null) continue;
            this.tupleSource = (TupleSource)this.attachNode(new JoinNode(this.id++, this.tupleSource, this.objectSource, (BetaNodeBinder)serializable));
        }
    }

    public BaseNode[] getTerminalNodes(Rule rule) {
        return (BaseNode[])this.rules.remove(rule);
    }

    private void attachQuery(String string) {
        ++this.currentOffsetAdjustment;
        this.objectSource = (ObjectSource)this.attachNode(new ObjectTypeNode(this.id++, this.sinklistFactory.newObjectSinkList(ObjectTypeNode.class), new ClassObjectType(DroolsQuery.class), this.rete));
        ClassFieldExtractor classFieldExtractor = new ClassFieldExtractor(DroolsQuery.class, "name");
        FieldValue fieldValue = FieldFactory.getFieldValue(string, 180);
        Evaluator evaluator = EvaluatorFactory.getEvaluator(180, 1);
        LiteralConstraint literalConstraint = new LiteralConstraint(fieldValue, classFieldExtractor, evaluator);
        this.objectSource = (ObjectSource)this.attachNode(new AlphaNode(this.id++, this.sinklistFactory.newObjectSinkList(AlphaNode.class), literalConstraint, this.objectSource));
        this.tupleSource = (TupleSource)this.attachNode(new LeftInputAdapterNode(this.id++, this.objectSource));
        this.objectSource = null;
    }

    private BetaNodeBinder attachColumn(Column column, GroupElement groupElement, boolean bl) throws InvalidPatternException {
        Object object;
        column.adjustOffset(this.currentOffsetAdjustment);
        if (column.getDeclaration() != null) {
            object = column.getDeclaration();
            this.declarations.put(((Declaration)object).getIdentifier(), object);
        }
        BetaNodeBinder betaNodeBinder = !(object = this.attachAlphaNodes(column, bl)).isEmpty() ? new BetaNodeBinder(object.toArray(new FieldConstraint[object.size()])) : new BetaNodeBinder();
        return betaNodeBinder;
    }

    public List attachAlphaNodes(Column column, boolean bl) throws InvalidPatternException {
        Object object;
        Iterator iterator;
        Object object2;
        List list = column.getConstraints();
        Class clazz = ((ClassObjectType)column.getObjectType()).getClassType();
        this.objectSource = (ObjectSource)this.attachNode(new ObjectTypeNode(this.id++, this.sinklistFactory.newObjectSinkList(ObjectTypeNode.class), column.getObjectType(), this.rete));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            object2 = null;
            iterator = this.objectType.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                Class clazz2 = ((ClassObjectType)object.getKey()).getClassType();
                if (!clazz.isAssignableFrom(clazz2)) continue;
                object2 = (List)object.getValue();
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(new InstanceNotEqualsConstraint((Integer)iterator2.next()));
                }
            }
            if (object2 == null) {
                object2 = new ArrayList();
            }
            object2.add((Integer)new Integer(column.getFactIndex()));
            this.objectType.put(column.getObjectType(), object2);
        }
        object2 = list.iterator();
        while (object2.hasNext()) {
            iterator = object2.next();
            if (iterator instanceof Declaration) {
                object = (Declaration)((Object)iterator);
                this.declarations.put(((Declaration)object).getIdentifier(), object);
                continue;
            }
            object = (FieldConstraint)((Object)iterator);
            if (object instanceof LiteralConstraint) {
                this.objectSource = (ObjectSource)this.attachNode(new AlphaNode(this.id++, this.sinklistFactory.newObjectSinkList(class$org$drools$reteoo$AlphaNode == null ? ReteooBuilder.class$("org.drools.reteoo.AlphaNode") : class$org$drools$reteoo$AlphaNode), (FieldConstraint)object, this.objectSource));
                continue;
            }
            this.checkUnboundDeclarations(object.getRequiredDeclarations());
            arrayList.add(object);
        }
        return arrayList;
    }

    private void attachNot(TupleSource tupleSource, Not not, ObjectSource objectSource, BetaNodeBinder betaNodeBinder, Column column) {
        NotNode notNode = (NotNode)this.attachNode(new NotNode(this.id++, tupleSource, objectSource, betaNodeBinder));
        if (not.getChild() instanceof Not) {
            RightInputAdapterNode rightInputAdapterNode = (RightInputAdapterNode)this.attachNode(new RightInputAdapterNode(this.id++, column.getFactIndex(), notNode));
            this.attachNot(tupleSource, (Not)not.getChild(), rightInputAdapterNode, new BetaNodeBinder(), column);
        } else if (not.getChild() instanceof Exists) {
            RightInputAdapterNode rightInputAdapterNode = (RightInputAdapterNode)this.attachNode(new RightInputAdapterNode(this.id++, column.getFactIndex(), notNode));
            this.attachExists(tupleSource, (Exists)not.getChild(), rightInputAdapterNode, new BetaNodeBinder(), column);
        } else {
            this.tupleSource = notNode;
        }
    }

    private void attachExists(TupleSource tupleSource, Exists exists, ObjectSource objectSource, BetaNodeBinder betaNodeBinder, Column column) {
        NotNode notNode = (NotNode)this.attachNode(new NotNode(this.id++, tupleSource, objectSource, betaNodeBinder));
        RightInputAdapterNode rightInputAdapterNode = (RightInputAdapterNode)this.attachNode(new RightInputAdapterNode(this.id++, column.getFactIndex(), notNode));
        BetaNodeBinder betaNodeBinder2 = new BetaNodeBinder(new InstanceEqualsConstraint(column.getFactIndex()));
        notNode = (NotNode)this.attachNode(new NotNode(this.id++, tupleSource, rightInputAdapterNode, betaNodeBinder2));
        if (exists.getChild() instanceof Not) {
            rightInputAdapterNode = (RightInputAdapterNode)this.attachNode(new RightInputAdapterNode(this.id++, column.getFactIndex(), notNode));
            this.attachNot(tupleSource, (Not)exists.getChild(), rightInputAdapterNode, new BetaNodeBinder(), column);
        } else if (exists.getChild() instanceof Exists) {
            rightInputAdapterNode = (RightInputAdapterNode)this.attachNode(new RightInputAdapterNode(this.id++, column.getFactIndex(), notNode));
            this.attachExists(tupleSource, (Exists)exists.getChild(), rightInputAdapterNode, new BetaNodeBinder(), column);
        } else {
            this.tupleSource = notNode;
        }
    }

    private BaseNode attachNode(BaseNode baseNode) {
        BaseNode baseNode2 = null;
        if (baseNode instanceof ObjectTypeNode) {
            ObjectTypeNode objectTypeNode = (ObjectTypeNode)baseNode;
            if ((objectTypeNode = this.rete.getObjectTypeNode(objectTypeNode.getObjectType())) != null) {
                baseNode2 = objectTypeNode;
                baseNode2.addShare();
                --this.id;
            }
        } else if (this.tupleSource != null && baseNode instanceof TupleSink) {
            int n = this.tupleSource.getTupleSinks().indexOf(baseNode);
            if (n > -1) {
                baseNode2 = (BaseNode)this.tupleSource.getTupleSinks().get(n);
                baseNode2.addShare();
                --this.id;
            }
        } else if (this.objectSource != null && baseNode instanceof ObjectSink) {
            Iterator iterator = this.objectSource.getObjectSinks().iterator();
            while (iterator.hasNext()) {
                ObjectSink objectSink = (ObjectSink)iterator.next();
                if (!baseNode.equals(objectSink)) continue;
                baseNode2 = (BaseNode)((Object)objectSink);
                baseNode2.addShare();
                --this.id;
            }
        } else {
            throw new RuntimeDroolsException("This is a bug on node sharing verification. Please report to development team.");
        }
        if (baseNode2 == null) {
            baseNode2 = baseNode;
            if (this.workingMemories.length == 0) {
                baseNode2.attach();
            } else {
                baseNode2.attach(this.workingMemories);
            }
        }
        return baseNode2;
    }

    public void removeRule(Rule rule) {
        this.workingMemories = this.ruleBase.getWorkingMemories().toArray(new ReteooWorkingMemory[this.ruleBase.getWorkingMemories().size()]);
        Object v = this.rules.get(rule);
        BaseNode[] baseNodeArray = (BaseNode[])v;
        int n = baseNodeArray.length;
        for (int i = 0; i < n; ++i) {
            BaseNode baseNode = baseNodeArray[i];
            baseNode.remove(null, this.workingMemories);
        }
    }

    private void checkUnboundDeclarations(Declaration[] declarationArray) throws InvalidPatternException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = declarationArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.declarations.get(declarationArray[i].getIdentifier()) != null) continue;
            arrayList.add(declarationArray[i].getIdentifier());
        }
        if (arrayList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(arrayList.get(0));
            int n2 = arrayList.size();
            for (n = 1; n < n2; ++n) {
                stringBuffer.append(", " + arrayList.get(n));
            }
            throw new InvalidPatternException("Required Declarations not bound: '" + stringBuffer);
        }
    }
}

