/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit;

import com.thoughtworks.xstream.XStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.audit.WorkingMemoryLogger;
import org.drools.audit.event.LogEvent;

public class WorkingMemoryFileLogger
extends WorkingMemoryLogger {
    private final List events = new ArrayList();
    private String fileName = "event";
    private int maxEventsInMemory = 1000;
    private int nbOfFile = 0;

    public WorkingMemoryFileLogger(WorkingMemory workingMemory) {
        super(workingMemory);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void writeToDisk() {
        try {
            XStream xStream = new XStream();
            ObjectOutputStream objectOutputStream = xStream.createObjectOutputStream((Writer)new FileWriter(this.fileName + (this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), false));
            objectOutputStream.writeObject(this.events);
            objectOutputStream.close();
            ++this.nbOfFile;
            this.clear();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Could not create the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    public void clear() {
        this.events.clear();
    }

    public void setMaxEventsInMemory(int n) {
        this.maxEventsInMemory = n;
    }

    public void logEventCreated(LogEvent logEvent) {
        this.events.add(logEvent);
        if (this.events.size() > this.maxEventsInMemory) {
            this.writeToDisk();
        }
    }
}

