/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation.compiler;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import org.jboss.aop.annotation.compiler.AnnotationDocletTag;
import org.jboss.aop.annotation.compiler.AnnotationDocletTagFactory;
import org.jboss.aop.annotation.compiler.XmlAnnotationVisitor;

public class XmlAnnotationCompiler {
    public static void main(String[] args) throws Exception {
        XmlAnnotationCompiler c = new XmlAnnotationCompiler();
        c.compile(args);
    }

    public void usage() {
        System.err.println("Usage: annotationc <files>+");
    }

    public static void indenter(PrintWriter pw, int indent) {
        for (int i = 0; i < indent * 3; ++i) {
            pw.print(" ");
        }
    }

    public void compile(String[] args) throws Exception {
        if (args.length == 0) {
            this.usage();
            System.exit(1);
            return;
        }
        String outputFile = "metadata-aop.xml";
        JavaDocBuilder builder = new JavaDocBuilder((DocletTagFactory)new AnnotationDocletTagFactory());
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-o")) {
                outputFile = args[++i];
                continue;
            }
            if (args[i].equals("-xml")) continue;
            File f = new File(args[i]).getCanonicalFile();
            builder.addSource((Reader)new FileReader(f));
        }
        FileOutputStream os = new FileOutputStream(outputFile);
        PrintWriter pw = new PrintWriter(os);
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println("<aop>");
        for (int i = 0; i < builder.getSources().length; ++i) {
            JavaSource src = builder.getSources()[i];
            for (int j = 0; j < src.getClasses().length; ++j) {
                JavaClass clazz = src.getClasses()[j];
                this.compileClass(clazz, pw);
            }
        }
        pw.println("</aop>");
        pw.close();
        os.close();
    }

    private void compileClass(JavaClass clazz, PrintWriter pw) throws Exception {
        AnnotationDocletTag tag;
        int i;
        int indent = 1;
        for (i = 0; i < clazz.getTags().length; ++i) {
            AnnotationDocletTag tag2 = (AnnotationDocletTag)clazz.getTags()[i];
            if (tag2.getAnnotation() == null) continue;
            XmlAnnotationCompiler.indenter(pw, indent);
            pw.println("<metadata tag=\"" + tag2.getName() + "\" class=\"" + clazz.getFullyQualifiedName() + "\">");
            XmlAnnotationCompiler.indenter(pw, ++indent);
            pw.println("<class>");
            XmlAnnotationVisitor visitor = new XmlAnnotationVisitor(++indent, pw);
            if (tag2.getAnnotation().jjtGetNumChildren() > 0) {
                tag2.getAnnotation().jjtGetChild(0).jjtAccept(visitor, null);
            }
            XmlAnnotationCompiler.indenter(pw, --indent);
            pw.println("</class>");
            XmlAnnotationCompiler.indenter(pw, --indent);
            pw.println("</metadata>");
        }
        for (i = 0; i < clazz.getMethods().length; ++i) {
            JavaMethod method = clazz.getMethods()[i];
            for (int j = 0; j < method.getTags().length; ++j) {
                tag = (AnnotationDocletTag)method.getTags()[j];
                if (tag.getAnnotation() == null) continue;
                XmlAnnotationCompiler.indenter(pw, indent);
                pw.println("<metadata tag=\"" + tag.getName() + "\" class=\"" + clazz.getFullyQualifiedName() + "\">");
                ++indent;
                indent = method.isConstructor() ? this.printConstructor(pw, method, indent, tag) : this.printMethod(pw, method, indent, tag);
                XmlAnnotationCompiler.indenter(pw, --indent);
                pw.println("</metadata>");
            }
        }
        for (i = 0; i < clazz.getFields().length; ++i) {
            JavaField field = clazz.getFields()[i];
            for (int j = 0; j < field.getTags().length; ++j) {
                tag = (AnnotationDocletTag)field.getTags()[j];
                if (tag.getAnnotation() == null) continue;
                XmlAnnotationCompiler.indenter(pw, indent);
                pw.println("<metadata tag=\"" + tag.getName() + "\" class=\"" + clazz.getFullyQualifiedName() + "\">");
                this.printField(pw, field, ++indent, tag);
                XmlAnnotationCompiler.indenter(pw, --indent);
                pw.println("</metadata>");
            }
        }
    }

    private int printMethod(PrintWriter pw, JavaMethod method, int indent, AnnotationDocletTag tag) throws Exception {
        XmlAnnotationCompiler.indenter(pw, indent);
        pw.print("<method expr=\"");
        pw.print(method.getReturns().toString());
        pw.print(" " + method.getName() + "(");
        boolean first = true;
        for (int k = 0; k < method.getParameters().length; ++k) {
            JavaParameter param = method.getParameters()[k];
            if (!first) {
                pw.print(", ");
            } else {
                first = false;
            }
            pw.print(param.getType().toString());
        }
        pw.println(")\">");
        XmlAnnotationVisitor visitor = new XmlAnnotationVisitor(++indent, pw);
        if (tag.getAnnotation().jjtGetNumChildren() > 0) {
            tag.getAnnotation().jjtGetChild(0).jjtAccept(visitor, null);
        }
        XmlAnnotationCompiler.indenter(pw, --indent);
        pw.println("</method>");
        return indent;
    }

    private int printField(PrintWriter pw, JavaField field, int indent, AnnotationDocletTag tag) throws Exception {
        XmlAnnotationCompiler.indenter(pw, indent);
        pw.println("<field name=\"" + field.getName() + "\">");
        XmlAnnotationVisitor visitor = new XmlAnnotationVisitor(++indent, pw);
        if (tag.getAnnotation().jjtGetNumChildren() > 0) {
            tag.getAnnotation().jjtGetChild(0).jjtAccept(visitor, null);
        }
        XmlAnnotationCompiler.indenter(pw, --indent);
        pw.println("</field>");
        return indent;
    }

    private int printConstructor(PrintWriter pw, JavaMethod method, int indent, AnnotationDocletTag tag) throws Exception {
        XmlAnnotationCompiler.indenter(pw, indent);
        pw.print("<constructor expr=\"");
        pw.print(method.getName() + "(");
        boolean first = true;
        for (int k = 0; k < method.getParameters().length; ++k) {
            JavaParameter param = method.getParameters()[k];
            if (!first) {
                pw.print(", ");
            } else {
                first = false;
            }
            pw.print(param.getType().toString());
        }
        pw.println(")\">");
        XmlAnnotationVisitor visitor = new XmlAnnotationVisitor(++indent, pw);
        if (tag.getAnnotation().jjtGetNumChildren() > 0) {
            tag.getAnnotation().jjtGetChild(0).jjtAccept(visitor, null);
        }
        XmlAnnotationCompiler.indenter(pw, --indent);
        pw.println("</constructor>");
        return indent;
    }
}

