/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

public class TypeSelector
extends BaseExtendSelector {
    private String type = null;
    public static final String TYPE_KEY = "type";

    public String toString() {
        StringBuffer buf = new StringBuffer("{typeselector type: ");
        buf.append(this.type);
        buf.append("}");
        return buf.toString();
    }

    public void setType(FileType fileTypes) {
        this.type = fileTypes.getValue();
    }

    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                String paramname = parameters[i].getName();
                if (TYPE_KEY.equalsIgnoreCase(paramname)) {
                    FileType type = new FileType();
                    type.setValue(parameters[i].getValue());
                    this.setType(type);
                    continue;
                }
                this.setError("Invalid parameter " + paramname);
            }
        }
    }

    public void verifySettings() {
        if (this.type == null) {
            this.setError("The type attribute is required");
        }
    }

    public boolean isSelected(File basedir, String filename, File file) {
        this.validate();
        if (file.isDirectory()) {
            return this.type.equals("dir");
        }
        return this.type.equals("file");
    }

    public static class FileType
    extends EnumeratedAttribute {
        public static final String FILE = "file";
        public static final String DIR = "dir";

        public String[] getValues() {
            return new String[]{FILE, DIR};
        }
    }
}

