/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPumper
implements Runnable {
    private static final int SIZE = 128;
    private InputStream is;
    private OutputStream os;
    private boolean finished;
    private boolean closeWhenExhausted;
    private boolean autoflush = false;

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        this.is = is;
        this.os = os;
        this.closeWhenExhausted = closeWhenExhausted;
    }

    public StreamPumper(InputStream is, OutputStream os) {
        this(is, os, false);
    }

    void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block21: {
            int length;
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.finished = false;
            }
            byte[] buf = new byte[128];
            while ((length = this.is.read(buf)) > 0 && !this.finished) {
                this.os.write(buf, 0, length);
                if (!this.autoflush) continue;
                this.os.flush();
            }
            Object var5_4 = null;
            if (!this.closeWhenExhausted) break block21;
            try {
                this.os.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        StreamPumper streamPumper = this;
        synchronized (streamPumper) {
            this.finished = true;
            this.notifyAll();
        }
        {
            catch (Exception exception) {
                Object var5_5 = null;
                if (this.closeWhenExhausted) {
                    try {
                        this.os.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                StreamPumper streamPumper2 = this;
                synchronized (streamPumper2) {
                    this.finished = true;
                    this.notifyAll();
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            StreamPumper streamPumper3 = this;
            synchronized (streamPumper3) {
                this.finished = true;
                this.notifyAll();
            }
            throw throwable;
        }
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }

    synchronized void stop() {
        this.finished = true;
        this.notifyAll();
    }
}

