/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.util.List;
import org.jboss.ws.extensions.security.EncodingOperation;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Target;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.Timestamp;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampOperation
implements EncodingOperation {
    private SecurityHeader header;
    private SecurityStore store;

    public TimestampOperation(SecurityHeader header, SecurityStore store) {
        this.header = header;
        this.store = store;
    }

    @Override
    public void process(Document message, List<Target> targets, String alias, String credential, String algorithm, boolean digest, boolean useNonce, boolean useTimestamp) throws WSSecurityException {
        Integer ttl = null;
        try {
            ttl = Integer.valueOf(credential);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.header.setTimestamp(new Timestamp(ttl, message));
    }
}

