/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.xml.security.Init;
import org.jboss.ws.extensions.security.EncodingOperation;
import org.jboss.ws.extensions.security.OperationDescription;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityEncoder {
    private List<OperationDescription<EncodingOperation>> operations;
    private SecurityStore store;

    public SecurityEncoder(List<OperationDescription<EncodingOperation>> operations, SecurityStore store) {
        Init.init();
        this.operations = operations;
        this.store = store;
    }

    private void attachHeader(SecurityHeader header, Document message) {
        Element soapHeader = Util.findOrCreateSoapHeader(message.getDocumentElement());
        try {
            Element wsse = header.getElement();
            wsse.setAttributeNS(soapHeader.getNamespaceURI(), soapHeader.getPrefix() + ":mustUnderstand", "1");
            soapHeader.insertBefore(wsse, soapHeader.getFirstChild());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void encode(Document message) throws WSSecurityException {
        SecurityHeader header = new SecurityHeader(message);
        for (OperationDescription<EncodingOperation> op : this.operations) {
            EncodingOperation operation;
            try {
                Constructor<EncodingOperation> constructor = op.getOperation().getConstructor(SecurityHeader.class, SecurityStore.class);
                operation = constructor.newInstance(header, this.store);
            }
            catch (Exception e) {
                throw new WSSecurityException("Error constructing operation: " + op.getOperation());
            }
            operation.process(message, op.getTargets(), op.getCertificateAlias(), op.getCredential(), op.getAlgorithm(), op.isDigest(), op.isUseNonce(), op.isUseTimestamp());
        }
        this.attachHeader(header, message);
    }
}

