/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.xml.security.Init;
import org.jboss.ws.extensions.security.DecryptionOperation;
import org.jboss.ws.extensions.security.OperationDescription;
import org.jboss.ws.extensions.security.ReceiveUsernameOperation;
import org.jboss.ws.extensions.security.ReceiveX509Certificate;
import org.jboss.ws.extensions.security.RequireEncryptionOperation;
import org.jboss.ws.extensions.security.RequireOperation;
import org.jboss.ws.extensions.security.RequireSignatureOperation;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.SignatureVerificationOperation;
import org.jboss.ws.extensions.security.TimestampVerificationOperation;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.EncryptedKey;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.SecurityProcess;
import org.jboss.ws.extensions.security.element.Signature;
import org.jboss.ws.extensions.security.element.Timestamp;
import org.jboss.ws.extensions.security.element.Token;
import org.jboss.ws.extensions.security.element.UsernameToken;
import org.jboss.ws.extensions.security.nonce.NonceFactory;
import org.jboss.ws.metadata.wsse.Authenticate;
import org.jboss.ws.metadata.wsse.TimestampVerification;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityDecoder {
    private Element headerElement;
    private Calendar now = null;
    private SecurityHeader header;
    private Document message;
    private NonceFactory nonceFactory;
    private SecurityStore store;
    private TimestampVerification timestampVerification;
    private Authenticate authenticate;
    private HashSet<String> signedIds = new HashSet();
    private HashSet<String> encryptedIds = new HashSet();

    public SecurityDecoder(SecurityStore store, NonceFactory nonceFactory, TimestampVerification timestampVerification, Authenticate authenticate) {
        Init.init();
        this.store = store;
        this.nonceFactory = nonceFactory;
        this.timestampVerification = timestampVerification;
        this.authenticate = authenticate;
    }

    public SecurityDecoder(SecurityStore store, Calendar now, NonceFactory nonceFactory, TimestampVerification timestampVerification, Authenticate authenticate) {
        this(store, nonceFactory, timestampVerification, authenticate);
        this.now = now;
    }

    private Element getHeader(Document message) throws WSSecurityException {
        Element header = Util.findElement(message.getDocumentElement(), "Security", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (header == null) {
            throw new WSSecurityException("Expected security header was not found");
        }
        return header;
    }

    private void detachHeader() {
        this.headerElement.getParentNode().removeChild(this.headerElement);
    }

    private void decode() throws WSSecurityException {
        Timestamp timestamp = this.header.getTimestamp();
        if (timestamp != null) {
            TimestampVerificationOperation operation = this.now == null ? new TimestampVerificationOperation(this.timestampVerification) : new TimestampVerificationOperation(this.now);
            operation.process(this.message, timestamp);
        }
        if (this.authenticate == null || this.authenticate.isUsernameAuth()) {
            for (Token token : this.header.getTokens()) {
                if (!(token instanceof UsernameToken)) continue;
                new ReceiveUsernameOperation(this.header, this.store, this.nonceFactory != null ? this.nonceFactory.getStore() : null).process(this.message, token);
            }
        }
        this.signedIds.clear();
        this.encryptedIds.clear();
        SignatureVerificationOperation signatureVerifier = new SignatureVerificationOperation(this.header, this.store);
        DecryptionOperation decrypter = new DecryptionOperation(this.header, this.store);
        for (SecurityProcess process : this.header.getSecurityProcesses()) {
            Collection<String> ids;
            if (process instanceof Signature) {
                Signature signature = (Signature)process;
                Collection<String> ids2 = signatureVerifier.process(this.message, signature);
                if (ids2 != null) {
                    this.signedIds.addAll(ids2);
                }
                if (this.authenticate == null || !this.authenticate.isSignatureCertAuth()) continue;
                new ReceiveX509Certificate(this.authenticate.getSignatureCertAuth().getCertificatePrincipal()).process(this.message, signature.getSecurityToken());
                continue;
            }
            if (!(process instanceof EncryptedKey) || (ids = decrypter.process(this.message, process)) == null) continue;
            this.encryptedIds.addAll(ids);
        }
    }

    public void verify(List<OperationDescription<RequireOperation>> requireOperations) throws WSSecurityException {
        if (requireOperations == null) {
            return;
        }
        for (OperationDescription<RequireOperation> o : requireOperations) {
            RequireOperation op;
            Class<RequireOperation> operation = o.getOperation();
            HashSet<String> processedIds = null;
            if (operation.equals(RequireSignatureOperation.class)) {
                op = new RequireSignatureOperation(this.header, this.store);
                processedIds = this.signedIds;
            } else if (operation.equals(RequireEncryptionOperation.class)) {
                op = new RequireEncryptionOperation(this.header, this.store);
                processedIds = this.encryptedIds;
            } else {
                try {
                    Constructor<RequireOperation> c = operation.getConstructor(SecurityHeader.class, SecurityStore.class);
                    op = c.newInstance(this.header, this.store);
                }
                catch (Exception e) {
                    throw new WSSecurityException("Error constructing operation: " + operation);
                }
            }
            op.process(this.message, o.getTargets(), o.getCertificateAlias(), o.getCredential(), processedIds);
        }
    }

    public void decode(Document message) throws WSSecurityException {
        this.decode(message, this.getHeader(message));
    }

    public void decode(Document message, Element headerElement) throws WSSecurityException {
        this.headerElement = headerElement;
        this.header = new SecurityHeader(this.headerElement, this.store);
        this.message = message;
        this.decode();
    }

    public void complete() {
        this.detachHeader();
    }
}

