/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.handler;

import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.ws.handler.MessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.jaxws.SerializationContextJAXWS;
import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.xb.binding.NamespaceRegistry;

public abstract class MessageContextJAXWS
extends CommonMessageContext
implements MessageContext {
    private static Logger log = Logger.getLogger(MessageContextJAXWS.class);

    public MessageContextJAXWS() {
    }

    public MessageContextJAXWS(CommonMessageContext msgContext) {
        super(msgContext);
    }

    public SerializationContext createSerializationContext() {
        EndpointMetaData epMetaData = this.getEndpointMetaData();
        ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
        SerializationContextJAXWS jaxwsContext = new SerializationContextJAXWS();
        jaxwsContext.setTypeMapping(serviceMetaData.getTypeMapping());
        return jaxwsContext;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.getSerializationContext().getNamespaceRegistry();
    }

    public void setScope(String key, MessageContext.Scope scope) {
        CommonMessageContext.ScopedProperty prop = (CommonMessageContext.ScopedProperty)this.scopedProps.get(key);
        if (prop == null) {
            throw new IllegalArgumentException("Cannot find scoped property: " + key);
        }
        this.scopedProps.put(key, new CommonMessageContext.ScopedProperty(key, prop.getValue(), scope));
    }

    public MessageContext.Scope getScope(String key) {
        CommonMessageContext.ScopedProperty prop = (CommonMessageContext.ScopedProperty)this.scopedProps.get(key);
        if (prop == null) {
            throw new IllegalArgumentException("Cannot find scoped property: " + key);
        }
        return prop.getScope();
    }

    public static MessageContextJAXWS processPivot(CommonMessageContext reqContext) {
        log.debug((Object)"Begin response processing");
        Boolean outbound = (Boolean)reqContext.get("javax.xml.ws.handler.message.outbound");
        if (outbound == null) {
            throw new IllegalStateException("Cannot find property: javax.xml.ws.handler.message.outbound");
        }
        MessageContextAssociation.popMessageContext(false);
        SOAPMessageContextJAXWS resContext = new SOAPMessageContextJAXWS(reqContext);
        resContext.setSOAPMessage(null);
        resContext.put("javax.xml.ws.handler.message.outbound", (Object)new Boolean(outbound == false));
        MessageContextAssociation.pushMessageContext(resContext);
        return resContext;
    }

    public void setOperationMetaData(OperationMetaData opMetaData) {
        super.setOperationMetaData(opMetaData);
        if (opMetaData != null) {
            EndpointMetaData epMetaData = opMetaData.getEndpointMetaData();
            ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
            URL wsdlURL = serviceMetaData.getWsdlFileOrLocation();
            if (wsdlURL != null) {
                try {
                    this.put("javax.xml.ws.wsdl.description", (Object)wsdlURL.toURI());
                }
                catch (URISyntaxException e) {
                    log.warn((Object)"Cannot get the wsdl url", (Throwable)e);
                }
            }
            this.put("javax.xml.ws.wsdl.service", (Object)serviceMetaData.getServiceName());
            this.put("javax.xml.ws.wsdl.port", (Object)epMetaData.getPortName());
            this.put("javax.xml.ws.wsdl.interface", (Object)epMetaData.getPortTypeName());
            this.put("javax.xml.ws.wsdl.operation", (Object)opMetaData.getQName());
        }
    }
}

