/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.StubExt;
import org.jboss.ws.core.jaxws.client.ClientImpl;
import org.jboss.ws.core.jaxws.client.ResponseImpl;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.wsf.common.JavaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxy
implements InvocationHandler {
    private static final Logger log = Logger.getLogger(ClientProxy.class);
    private ClientImpl client;
    private List stubMethods;
    private List objectMethods;
    private ExecutorService executor;
    private static final Set<String> standardProperties = new HashSet<String>();

    public ClientProxy(ExecutorService executor, ClientImpl client) {
        this.client = client;
        this.executor = executor;
        this.stubMethods = new ArrayList<Method>(Arrays.asList(BindingProvider.class.getMethods()));
        this.stubMethods.addAll(Arrays.asList(StubExt.class.getMethods()));
        this.objectMethods = Arrays.asList(Object.class.getMethods());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (this.stubMethods.contains(method)) {
            Method stubMethod = ClientImpl.class.getMethod(methodName, method.getParameterTypes());
            return stubMethod.invoke((Object)this.client, args);
        }
        if (this.objectMethods.contains(method)) {
            Method objMethod = ClientImpl.class.getMethod(methodName, method.getParameterTypes());
            return objMethod.invoke((Object)this.client, args);
        }
        EndpointMetaData epMetaData = this.client.getEndpointMetaData();
        OperationMetaData opMetaData = epMetaData.getOperation(method);
        if (opMetaData == null) {
            throw new WSException("Cannot obtain operation meta data for: " + methodName);
        }
        QName opName = opMetaData.getQName();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Invoke method: " + method + opMetaData));
        }
        try {
            Object retObj;
            Class<?> retType = method.getReturnType();
            boolean isAsync = methodName.endsWith("Async");
            if (isAsync && JavaUtils.isAssignableFrom(Response.class, retType)) {
                retObj = this.invokeAsync(opName, args, retType);
            } else if (isAsync && JavaUtils.isAssignableFrom(Future.class, retType) && args.length > 1) {
                Object handler = args[args.length - 1];
                retObj = this.invokeAsync(opName, args, retType, (AsyncHandler)handler);
            } else {
                Map resContext = this.client.getBindingProvider().getResponseContext();
                retObj = this.invoke(opName, args, retType, resContext);
            }
            return retObj;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    private Object invoke(QName opName, Object[] args, Class retType, Map<String, Object> resContext) throws RemoteException {
        Object retObj = this.client.invoke(opName, args, resContext);
        if (retObj != null) {
            if (retType == null) {
                throw new WSException("Return value not supported by: " + opName);
            }
            if (JavaUtils.isPrimitive((Class)retType)) {
                retObj = JavaUtils.getPrimitiveValueArray((Object)retObj);
            }
        }
        return retObj;
    }

    private Response invokeAsync(QName opName, Object[] args, Class retType) {
        ResponseImpl response = new ResponseImpl();
        AsyncRunnable task = new AsyncRunnable(response, null, opName, args, retType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Schedule task " + task.getTaskID().toString()));
        }
        Future<?> future = this.executor.submit(task);
        response.setFuture(future);
        return response;
    }

    private Future invokeAsync(QName opName, Object[] args, Class retType, AsyncHandler handler) {
        ResponseImpl response = new ResponseImpl();
        AsyncRunnable task = new AsyncRunnable(response, handler, opName, args, retType);
        Future<?> future = this.executor.submit(task);
        response.setFuture(future);
        return response;
    }

    private void handleException(Exception ex) throws Throwable {
        Throwable cause;
        if (ex instanceof SOAPFaultException && (cause = ex.getCause()) instanceof Exception) {
            if (cause instanceof WebServiceException) {
                throw (WebServiceException)cause;
            }
            if (cause instanceof SOAPException) {
                throw (SOAPFaultException)ex;
            }
            if (cause instanceof RuntimeException) {
                throw (SOAPFaultException)ex;
            }
            throw (Exception)cause;
        }
        throw ex;
    }

    static {
        standardProperties.add("javax.xml.ws.service.endpoint.address");
        standardProperties.add("javax.xml.ws.session.maintain");
        standardProperties.add("javax.xml.ws.security.auth.username");
        standardProperties.add("javax.xml.ws.security.auth.password");
        standardProperties.add("javax.xml.ws.soap.http.soapaction.use");
        standardProperties.add("javax.xml.ws.soap.http.soapaction.uri");
    }

    class AsyncRunnable
    implements Runnable {
        private ResponseImpl response;
        private AsyncHandler handler;
        private QName opName;
        private Object[] args;
        private Class retType;
        private UUID uuid;

        public AsyncRunnable(ResponseImpl response, AsyncHandler handler, QName opName, Object[] args, Class retType) {
            this.response = response;
            this.handler = handler;
            this.opName = opName;
            this.args = args;
            this.retType = retType;
            this.uuid = UUID.randomUUID();
        }

        public void run() {
            try {
                Map<String, Object> resContext = this.response.getContext();
                Object result = ClientProxy.this.invoke(this.opName, this.args, this.retType, resContext);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Finished task " + this.getTaskID().toString() + ": " + result));
                }
                this.response.set(result);
            }
            catch (Exception ex) {
                this.handleAsynInvokeException(ex);
            }
            if (this.handler != null) {
                this.handler.handleResponse((Response)this.response);
            }
        }

        private void handleAsynInvokeException(Exception ex) {
            Throwable cause;
            Exception toBeWrapped = ex;
            if (ex instanceof SOAPFaultException && (cause = ex.getCause()) instanceof Exception) {
                if (cause instanceof WebServiceException) {
                    ex = (WebServiceException)cause;
                }
                if (!(cause instanceof SOAPException) && !(cause instanceof RuntimeException)) {
                    toBeWrapped = (Exception)cause;
                }
            }
            this.response.setException(toBeWrapped);
        }

        public UUID getTaskID() {
            return this.uuid;
        }
    }
}

