/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonClient;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxws.binding.BindingExt;
import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
import org.jboss.ws.core.jaxws.handler.HandlerChainExecutor;
import org.jboss.ws.core.jaxws.handler.HandlerResolverImpl;
import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointConfigMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientImpl
extends CommonClient
implements BindingProvider {
    private final ClientEndpointMetaData epMetaData;
    private EndpointConfigMetaData epConfigMetaData;
    private final HandlerResolver handlerResolver;
    private Map<UnifiedHandlerMetaData.HandlerType, HandlerChainExecutor> executorMap = new HashMap<UnifiedHandlerMetaData.HandlerType, HandlerChainExecutor>();
    private static UnifiedHandlerMetaData.HandlerType[] HANDLER_TYPES = new UnifiedHandlerMetaData.HandlerType[]{UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST};

    public ClientImpl(EndpointMetaData epMetaData, HandlerResolver handlerResolver) {
        super(epMetaData);
        this.setTargetEndpointAddress(epMetaData.getEndpointAddress());
        this.epMetaData = (ClientEndpointMetaData)epMetaData;
        this.epConfigMetaData = epMetaData.getEndpointConfigMetaData();
        this.handlerResolver = handlerResolver instanceof HandlerResolverImpl ? new HandlerResolverImpl((HandlerResolverImpl)handlerResolver) : handlerResolver;
        this.initBindingHandlerChain(false);
    }

    private void initBindingHandlerChain(boolean clearExistingHandlers) {
        BindingExt binding = (BindingExt)this.getBindingProvider().getBinding();
        PortInfo portInfo = this.epMetaData.getPortInfo();
        if (this.handlerResolver != null) {
            boolean jbossHandlerResolver = this.handlerResolver instanceof HandlerResolverImpl;
            if (jbossHandlerResolver) {
                HandlerResolverImpl impl = (HandlerResolverImpl)this.handlerResolver;
                impl.initHandlerChain(this.epConfigMetaData, UnifiedHandlerMetaData.HandlerType.PRE, clearExistingHandlers);
                impl.initHandlerChain(this.epConfigMetaData, UnifiedHandlerMetaData.HandlerType.ENDPOINT, clearExistingHandlers);
                impl.initHandlerChain(this.epConfigMetaData, UnifiedHandlerMetaData.HandlerType.POST, clearExistingHandlers);
                List<Handler> preChain = impl.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.PRE);
                List<Handler> postChain = impl.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.POST);
                binding.setHandlerChain(postChain, UnifiedHandlerMetaData.HandlerType.POST);
                binding.setHandlerChain(preChain, UnifiedHandlerMetaData.HandlerType.PRE);
            }
            List endpointChain = this.handlerResolver.getHandlerChain(portInfo);
            binding.setHandlerChain(endpointChain);
        }
    }

    @Override
    protected boolean callRequestHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
        BindingExt binding = (BindingExt)this.getBindingProvider().getBinding();
        HandlerChainExecutor executor = new HandlerChainExecutor(this.epMetaData, binding.getHandlerChain(type), false);
        this.executorMap.put(type, executor);
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        return executor.handleMessage(msgContext);
    }

    @Override
    protected boolean callResponseHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        HandlerChainExecutor executor = this.executorMap.get(type);
        return executor != null ? executor.handleMessage(msgContext) : true;
    }

    @Override
    protected boolean callFaultHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type, Exception ex) {
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        HandlerChainExecutor executor = this.executorMap.get(type);
        return executor != null ? executor.handleFault(msgContext, ex) : true;
    }

    @Override
    protected void closeHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        HandlerChainExecutor executor = this.executorMap.get(type);
        if (executor != null) {
            executor.close(msgContext);
        }
    }

    @Override
    protected void setInboundContextProperties() {
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        msgContext.put((Object)"javax.xml.ws.binding.attachments.inbound", new HashMap());
        if (msgContext.containsKey((Object)CommonMessageContext.REMOTING_METADATA)) {
            Map remotingMetadata = (Map)msgContext.get((Object)CommonMessageContext.REMOTING_METADATA);
            Integer resposeCode = (Integer)remotingMetadata.get("ResponseCode");
            if (resposeCode != null) {
                msgContext.put((Object)"javax.xml.ws.http.response.code", (Object)resposeCode);
            }
            HashMap<String, List> headers = new HashMap<String, List>();
            for (Map.Entry en : remotingMetadata.entrySet()) {
                if (!(en.getKey() instanceof String) || !(en.getValue() instanceof List)) continue;
                headers.put((String)en.getKey(), (List)en.getValue());
            }
            msgContext.put((Object)"javax.xml.ws.http.response.headers", headers);
        }
    }

    @Override
    protected void setOutboundContextProperties() {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        msgContext.put("javax.xml.ws.handler.message.outbound", (Object)Boolean.TRUE);
        msgContext.put("javax.xml.ws.binding.attachments.outbound", (Object)new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(QName opName, Object[] args, Map<String, Object> resContext) throws RemoteException {
        CommonMessageContext msgContext = new SOAPMessageContextJAXWS();
        MessageContextAssociation.pushMessageContext(msgContext);
        Map reqContext = this.getBindingProvider().getRequestContext();
        msgContext.putAll(reqContext);
        try {
            Object retObj;
            Object object = retObj = this.invoke(opName, args, false);
            return object;
        }
        catch (Exception ex) {
            OperationMetaData opMetaData = this.getOperationMetaData();
            if (opMetaData.isOneWay()) {
                this.handleOneWayException(opMetaData, ex);
            } else {
                this.handleRemoteException(opMetaData, ex);
            }
            Object var8_11 = null;
            return var8_11;
        }
        finally {
            msgContext = MessageContextAssociation.peekMessageContext();
            for (String key : msgContext.keySet()) {
                Object value = msgContext.get(key);
                resContext.put(key, value);
            }
            MessageContextAssociation.popMessageContext();
        }
    }

    @Override
    protected CommonMessageContext processPivot(CommonMessageContext reqMessageContext) {
        MessageContextJAXWS resMessageContext = MessageContextJAXWS.processPivot(reqMessageContext);
        return resMessageContext;
    }

    private void handleOneWayException(OperationMetaData opMetaData, Exception ex) {
        if (ex instanceof WebServiceException) {
            throw (WebServiceException)ex;
        }
        throw new WebServiceException((Throwable)ex);
    }

    private void handleRemoteException(OperationMetaData opMetaData, Exception ex) {
        String bindingId = opMetaData.getEndpointMetaData().getBindingId();
        if (bindingId.startsWith("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingId.startsWith("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            if (ex instanceof SOAPFaultException) {
                throw (SOAPFaultException)ex;
            }
            if (ex instanceof WebServiceException) {
                throw (WebServiceException)ex;
            }
            throw new WebServiceException((Throwable)ex);
        }
        if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingId)) {
            HTTPException wsEx = new HTTPException(-1);
            wsEx.initCause((Throwable)ex);
            throw wsEx;
        }
        throw new WebServiceException("Unsuported binding: " + bindingId, (Throwable)ex);
    }

    @Override
    public void setTargetEndpointAddress(String endpointAddress) {
        this.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpointAddress);
    }

    @Override
    public String getTargetEndpointAddress() {
        return (String)this.getRequestContext().get("javax.xml.ws.service.endpoint.address");
    }

    @Override
    protected CommonBindingProvider getCommonBindingProvider() {
        if (this.bindingProvider == null) {
            this.bindingProvider = new BindingProviderImpl(this.getEndpointMetaData());
        }
        return this.bindingProvider;
    }

    @Override
    public Map<String, Object> getRequestContext() {
        return this.getBindingProvider().getRequestContext();
    }

    public Map<String, Object> getResponseContext() {
        return this.getBindingProvider().getResponseContext();
    }

    public Binding getBinding() {
        return this.getBindingProvider().getBinding();
    }

    public BindingProvider getBindingProvider() {
        return (BindingProvider)this.getCommonBindingProvider();
    }

    public EndpointReference getEndpointReference() {
        throw new NotImplementedException();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        throw new NotImplementedException();
    }

    public EndpointConfigMetaData getEndpointConfigMetaData() {
        return this.epConfigMetaData;
    }

    @Override
    public void setConfigName(String configName, String configFile) {
        if (configName == null) {
            throw new IllegalArgumentException("Config name cannot be null");
        }
        String orgConfigName = this.epConfigMetaData.getConfigName();
        String orgConfigFile = this.epConfigMetaData.getConfigFile();
        if (configFile == null) {
            configFile = orgConfigFile;
        }
        if (!orgConfigName.equals(configName) || !orgConfigFile.equals(configFile)) {
            this.epConfigMetaData = this.epMetaData.createEndpointConfigMetaData(configName, configFile);
            this.initBindingHandlerChain(true);
        }
    }

    @Override
    public Set<QName> getHeaders() {
        HashSet<QName> headers = new HashSet<QName>();
        BindingExt binding = (BindingExt)this.getBinding();
        for (UnifiedHandlerMetaData.HandlerType type : HANDLER_TYPES) {
            for (Handler bindingHandler : binding.getHandlerChain(type)) {
                if (!(bindingHandler instanceof SOAPHandler)) continue;
                headers.addAll(((SOAPHandler)bindingHandler).getHeaders());
            }
        }
        return headers;
    }

    @Override
    protected boolean shouldMaintainSession() {
        Object bool = this.getRequestContext().get("javax.xml.ws.session.maintain");
        return Boolean.TRUE.equals(bool);
    }
}

