/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestRunner;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFailuresSuiteGenerator
implements ITestListener,
ISuiteListener {
    public static final String TESTNG_FAILURES_XML = "testng-failed.xml";
    private XmlSuite m_xmlSuite;
    private boolean m_hasFailures;
    private String m_currentTestName;
    private Map<String, XmlTest> m_testNames = new HashMap<String, XmlTest>();
    private Map<String, XmlTest> m_failedTestNames = new HashMap<String, XmlTest>();
    private Map<String, XmlTestMethods> m_testNameMethods = new HashMap<String, XmlTestMethods>();
    private Map<String, String> m_outputs = new HashMap<String, String>();
    private Map<String, Map<String, Map<Method, ITestNGMethod>>> m_suiteConfMethods = new HashMap<String, Map<String, Map<Method, ITestNGMethod>>>();

    public SimpleFailuresSuiteGenerator(XmlSuite xmlSuite) {
        this.m_xmlSuite = xmlSuite;
        for (XmlTest xt : xmlSuite.getTests()) {
            this.m_testNames.put(xt.getName(), xt);
        }
    }

    public void registerRunner(TestRunner tr) {
        Map<Method, ITestNGMethod> methods;
        String fqn;
        XmlTest xmlTest = tr.getTest();
        String testName = xmlTest.getName();
        if (!this.m_testNames.containsKey(testName)) {
            System.err.println("[ERROR]: the test " + testName + " wasn't registered!");
            this.m_testNames.put(testName, xmlTest);
        }
        this.m_outputs.put(testName, tr.getOutputDirectory());
        this.m_testNameMethods.put(testName, new XmlTestMethods(xmlTest, tr.getIClass()));
        HashMap classMethods = new HashMap();
        for (ITestNGMethod itm : tr.getBeforeSuiteMethods()) {
            fqn = itm.getRealClass().getName();
            methods = (HashMap<Method, ITestNGMethod>)classMethods.get(fqn);
            if (null == methods) {
                methods = new HashMap<Method, ITestNGMethod>();
                classMethods.put(fqn, methods);
            }
            methods.put(itm.getMethod(), itm);
        }
        for (ITestNGMethod itm : tr.getAfterSuiteMethods()) {
            fqn = itm.getRealClass().getName();
            methods = (Map)classMethods.get(fqn);
            if (null == methods) {
                methods = new HashMap();
                classMethods.put(fqn, methods);
            }
            methods.put(itm.getMethod(), itm);
        }
        this.m_suiteConfMethods.put(testName, classMethods);
    }

    @Override
    public void onStart(ISuite suite) {
    }

    @Override
    public void onFinish(ISuite suite) {
        if (!this.m_hasFailures) {
            return;
        }
        Map<String, Set<String>> testperOut = this.regroupByOutput(this.m_outputs);
        for (String outdir : testperOut.keySet()) {
            Set<String> testnames = testperOut.get(outdir);
            XmlSuite newsuite = this.generateSuite(testnames);
            if (newsuite.getTests().size() <= 0) continue;
            Utils.writeFile(outdir, TESTNG_FAILURES_XML, newsuite.toXml());
        }
    }

    @Override
    public void onTestStart(ITestResult result) {
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        if (result.getMethod().isTest()) {
            if (null != this.m_currentTestName) {
                XmlTestMethods xmlTestMethods = this.m_testNameMethods.get(this.m_currentTestName);
                if (xmlTestMethods != null) {
                    xmlTestMethods.addSuccessTestMethod(result.getMethod());
                }
            } else {
                System.err.println("ITestResult without a name");
            }
        }
    }

    private void ppp(String s) {
        System.out.println("[SimpleFailuresSuiteGenerator] " + s);
    }

    @Override
    public void onTestFailure(ITestResult result) {
        this.registerFailedTest(this.m_currentTestName, result);
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.registerFailedTest(this.m_currentTestName, result);
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        this.registerFailedTest(this.m_currentTestName, result);
    }

    @Override
    public void onStart(ITestContext context) {
        this.m_currentTestName = context.getName();
    }

    @Override
    public void onFinish(ITestContext context) {
        this.m_currentTestName = null;
    }

    private void registerFailedTest(String testName, ITestResult result) {
        XmlTestMethods xmlTestMethods;
        this.m_hasFailures = true;
        ITestNGMethod mth = result.getMethod();
        if (mth.isTest() && (xmlTestMethods = this.m_testNameMethods.get(testName)) != null) {
            xmlTestMethods.addFailedTestMethod(mth);
            this.m_failedTestNames.put(testName, this.m_testNames.get(testName));
        }
    }

    private XmlSuite generateSuite(Set<String> testnames) {
        XmlTest xmlTest;
        XmlSuite failedSuite = this.cloneSuiteDef(this.m_xmlSuite);
        for (String name : testnames) {
            if (!this.m_failedTestNames.containsKey(name)) continue;
            xmlTest = this.m_failedTestNames.get(name);
            XmlTest newtest = this.cloneTestDef(failedSuite, xmlTest);
            XmlTestMethods xmlTestMeths = this.m_testNameMethods.get(name);
            for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
                Class testClass = xmlClass.getSupportClass();
                HashMap<String, String> dependedOnMethods = new HashMap<String, String>();
                Map<String, ITestNGMethod> failedMeths = xmlTestMeths.getFailedMethods(testClass);
                for (String methodName : failedMeths.keySet()) {
                    ITestNGMethod failed = failedMeths.get(methodName);
                    for (String mName : failed.getMethodsDependedUpon()) {
                        dependedOnMethods.put(mName, mName);
                    }
                }
                Map<String, ITestNGMethod> successMeths = xmlTestMeths.getSuccessMethods(testClass);
                XmlClass newclass = this.clone(xmlClass);
                if (successMeths.size() > 0) {
                    List<String> includes = newclass.getIncludedMethods();
                    ArrayList<String> newincludes = new ArrayList<String>();
                    for (String methodName : includes) {
                        if (successMeths.containsKey(methodName) && !dependedOnMethods.containsKey(methodName)) continue;
                        newincludes.add(methodName);
                    }
                    newclass.setIncludedMethods(newincludes);
                    List<String> excludes = newclass.getExcludedMethods();
                    for (String methodName : successMeths.keySet()) {
                        if (excludes.contains(methodName) || dependedOnMethods.containsKey(methodName)) continue;
                        excludes.add(methodName);
                    }
                }
                newtest.getXmlClasses().add(newclass);
            }
        }
        if (failedSuite.getTests().size() > 0) {
            for (String testname : this.m_suiteConfMethods.keySet()) {
                if (testnames.contains(testname)) continue;
                xmlTest = this.m_testNames.get(testname);
                XmlTest newxmltest = this.cloneTestDef(failedSuite, xmlTest);
                newxmltest.setName(xmlTest.getName() + "- suite methods only");
                Map<String, Map<Method, ITestNGMethod>> classMeths = this.m_suiteConfMethods.get(testname);
                for (XmlClass suiteDefClass : xmlTest.getXmlClasses()) {
                    Map<Method, ITestNGMethod> meths = classMeths.get(suiteDefClass.getName());
                    if (null == meths) continue;
                    XmlClass newclass = this.clone(suiteDefClass);
                    for (Method m : meths.keySet()) {
                        newclass.getIncludedMethods().add(m.getName());
                    }
                    newxmltest.getXmlClasses().add(newclass);
                }
            }
        }
        return failedSuite;
    }

    private XmlSuite cloneSuiteDef(XmlSuite srcSuite) {
        XmlSuite suite = new XmlSuite();
        suite.setName("Failed Tests suite");
        suite.setAnnotations(srcSuite.getAnnotations());
        suite.setParallel(srcSuite.isParallel());
        suite.setThreadCount(srcSuite.getThreadCount());
        suite.setParameters(srcSuite.getAllParameters());
        suite.setVerbose(srcSuite.getVerbose());
        suite.setXmlPackages(srcSuite.getXmlPackages());
        suite.setBeanShellExpression(srcSuite.getExpression());
        suite.setMethodSelectors(srcSuite.getMethodSelectors());
        return suite;
    }

    private XmlTest cloneTestDef(XmlSuite suite, XmlTest source) {
        XmlTest result = new XmlTest(suite);
        result.setName(source.getName());
        result.setAnnotations(source.getAnnotations());
        result.setIncludedGroups(source.getIncludedGroups());
        result.setExcludedGroups(source.getExcludedGroups());
        result.setJUnit(source.isJUnit());
        result.setParallel(source.isParallel());
        result.setVerbose(source.getVerbose());
        result.setParameters(source.getParameters());
        result.setXmlPackages(source.getXmlPackages());
        Map<String, List<String>> metagroups = source.getMetaGroups();
        for (String groupName : metagroups.keySet()) {
            result.addMetaGroup(groupName, metagroups.get(groupName));
        }
        return result;
    }

    private XmlClass clone(XmlClass source) {
        XmlClass newclass = new XmlClass(source.getName());
        newclass.setExcludedMethods(source.getExcludedMethods());
        newclass.setIncludedMethods(source.getIncludedMethods());
        return newclass;
    }

    private Map<String, Set<String>> regroupByOutput(Map<String, String> outputs) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String testname : outputs.keySet()) {
            String outdir = outputs.get(testname);
            HashSet<String> names = (HashSet<String>)result.get(outdir);
            if (null == names) {
                names = new HashSet<String>();
                result.put(outdir, names);
            }
            names.add(testname);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XmlTestMethods
    implements Serializable {
        private XmlTest m_xmlTest;
        private Map<String, ITestClass> m_testClasses = new HashMap<String, ITestClass>();
        private Map<String, Map<Method, ITestNGMethod>> m_failedMethsOnClass = new HashMap<String, Map<Method, ITestNGMethod>>();
        private Map<String, Map<Method, ITestNGMethod>> m_successMethsOnClass = new HashMap<String, Map<Method, ITestNGMethod>>();

        public XmlTestMethods(XmlTest xmlTest, Collection<ITestClass> testClasses) {
            this.m_xmlTest = xmlTest;
            for (ITestClass itc : testClasses) {
                this.m_testClasses.put(itc.getRealClass().getName(), itc);
            }
        }

        public void addFailedTestMethod(ITestNGMethod itm) {
            String fqn = itm.getRealClass().getName();
            Map<Method, ITestNGMethod> methods = this.m_failedMethsOnClass.get(fqn);
            if (null == methods) {
                methods = new HashMap<Method, ITestNGMethod>();
                this.m_failedMethsOnClass.put(fqn, methods);
            }
            methods.put(itm.getMethod(), itm);
        }

        public void addSuccessTestMethod(ITestNGMethod itm) {
            String fqn = itm.getRealClass().getName();
            Map<Method, ITestNGMethod> methods = this.m_successMethsOnClass.get(fqn);
            if (null == methods) {
                methods = new HashMap<Method, ITestNGMethod>();
                this.m_successMethsOnClass.put(fqn, methods);
            }
            methods.put(itm.getMethod(), itm);
        }

        protected Map<String, ITestNGMethod> getSuccessMethods(Class clazz) {
            HashMap<String, ITestNGMethod> result = new HashMap<String, ITestNGMethod>();
            Map<Method, ITestNGMethod> passedMeths = this.m_successMethsOnClass.get(clazz.getName());
            if (null != passedMeths) {
                for (Method m : passedMeths.keySet()) {
                    result.put(m.getName(), passedMeths.get(m));
                }
            }
            if (null != clazz.getSuperclass() && clazz.getSuperclass() != Object.class) {
                result.putAll(this.getSuccessMethods(clazz.getSuperclass()));
            }
            return result;
        }

        protected Map<String, ITestNGMethod> getFailedMethods(Class clazz) {
            HashMap<String, ITestNGMethod> result = new HashMap<String, ITestNGMethod>();
            Map<Method, ITestNGMethod> failedMethods = this.m_failedMethsOnClass.get(clazz.getName());
            if (null != failedMethods) {
                for (Method m : failedMethods.keySet()) {
                    result.put(m.getName(), failedMethods.get(m));
                }
            }
            if (null != clazz.getSuperclass() && clazz.getSuperclass() != Object.class) {
                result.putAll(this.getFailedMethods(clazz.getSuperclass()));
            }
            return result;
        }
    }
}

