/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EngineConfig
implements LifecycleListener {
    protected static Log log = LogFactory.getLog(EngineConfig.class);
    protected Engine engine = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.engine = (Engine)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("engineConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    protected void start() {
        if (this.engine.getLogger().isDebugEnabled()) {
            this.engine.getLogger().debug((Object)sm.getString("engineConfig.start"));
        }
    }

    protected void stop() {
        if (this.engine.getLogger().isDebugEnabled()) {
            this.engine.getLogger().debug((Object)sm.getString("engineConfig.stop"));
        }
    }
}

