/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.util.CollectionsFactory;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractDependencyInfo
extends JBossObject
implements DependencyInfo {
    private Set iDependOn = CollectionsFactory.createCopyOnWriteSet();
    private Set dependsOnMe = CollectionsFactory.createCopyOnWriteSet();
    private Set unresolved = CollectionsFactory.createCopyOnWriteSet();

    public Set getIDependOn(Class clazz) {
        if (clazz == null || this.iDependOn.isEmpty()) {
            return this.iDependOn;
        }
        HashSet<DependencyItem> hashSet = new HashSet<DependencyItem>();
        Iterator iterator = this.iDependOn.iterator();
        while (iterator.hasNext()) {
            DependencyItem dependencyItem = (DependencyItem)iterator.next();
            if (!clazz.isInstance(dependencyItem)) continue;
            hashSet.add(dependencyItem);
        }
        return hashSet;
    }

    public void addIDependOn(DependencyItem dependencyItem) {
        this.iDependOn.add(dependencyItem);
        this.unresolved.add(dependencyItem);
        this.flushJBossObjectCache();
    }

    public void removeIDependOn(DependencyItem dependencyItem) {
        this.iDependOn.remove(dependencyItem);
        this.unresolved.remove(dependencyItem);
        this.flushJBossObjectCache();
    }

    public Set getDependsOnMe(Class clazz) {
        if (clazz == null || this.dependsOnMe.isEmpty()) {
            return this.dependsOnMe;
        }
        HashSet<DependencyItem> hashSet = new HashSet<DependencyItem>();
        Iterator iterator = this.dependsOnMe.iterator();
        while (iterator.hasNext()) {
            DependencyItem dependencyItem = (DependencyItem)iterator.next();
            if (!clazz.isInstance(dependencyItem)) continue;
            hashSet.add(dependencyItem);
        }
        return hashSet;
    }

    public void addDependsOnMe(DependencyItem dependencyItem) {
        this.dependsOnMe.add(dependencyItem);
        this.flushJBossObjectCache();
    }

    public void removeDependsOnMe(DependencyItem dependencyItem) {
        this.dependsOnMe.add(dependencyItem);
        this.flushJBossObjectCache();
    }

    public boolean resolveDependencies(Controller controller, ControllerState controllerState) {
        boolean bl = true;
        if (!this.unresolved.isEmpty()) {
            Iterator iterator = this.unresolved.iterator();
            while (iterator.hasNext()) {
                DependencyItem dependencyItem = (DependencyItem)iterator.next();
                if (!controllerState.equals((Object)dependencyItem.getWhenRequired()) || dependencyItem.resolve(controller)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public Set getUnresolvedDependencies() {
        return this.unresolved;
    }

    public void toString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append("idependOn=").append((Object)this.iDependOn);
        if (!this.unresolved.isEmpty()) {
            jBossStringBuilder.append(" unresolved=").append((Object)this.unresolved);
        }
    }
}

