/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceBinding;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceCreator;
import org.jboss.util.Classes;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.jboss.util.xml.DOMWriter;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ServiceConfigurator {
    private final MBeanServer server;
    private final ServiceController serviceController;
    private final ServiceCreator serviceCreator;
    private ServiceBinding serviceBinding;
    private final Logger log = Logger.getLogger(this.getClass());

    public ServiceConfigurator(MBeanServer server, ServiceController serviceController, ServiceCreator serviceCreator) {
        this.server = server;
        this.serviceController = serviceController;
        this.serviceCreator = serviceCreator;
        this.serviceBinding = null;
    }

    public void setServiceBinding(ServiceBinding serviceBinding) {
        this.serviceBinding = serviceBinding;
    }

    public List install(Element config, ObjectName loaderName) throws DeploymentException {
        ArrayList mbeans = new ArrayList();
        try {
            if (config.getTagName().equals("mbean")) {
                this.internalInstall(config, mbeans, loaderName, true);
            } else {
                NodeList nl = config.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element element;
                    if (nl.item(i).getNodeType() != 1 || !(element = (Element)nl.item(i)).getTagName().equals("mbean")) continue;
                    Element mbean = (Element)nl.item(i);
                    this.internalInstall(mbean, mbeans, loaderName, true);
                }
            }
            return mbeans;
        }
        catch (Exception e) {
            ListIterator li = mbeans.listIterator(mbeans.size());
            while (li.hasPrevious()) {
                ObjectName mbean = (ObjectName)li.previous();
                try {
                    this.serviceCreator.remove(mbean);
                }
                catch (Exception n) {
                    this.log.error((Object)("exception removing mbean after failed deployment: " + mbean), (Throwable)n);
                }
            }
            if (e instanceof DeploymentException) {
                throw (DeploymentException)((Object)e);
            }
            throw new DeploymentException(e);
        }
    }

    public String getConfiguration(ObjectName[] objectNames) throws Exception {
        StringWriter out = new StringWriter();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element serverElement = doc.createElement("server");
        for (int j = 0; j < objectNames.length; ++j) {
            Element mbeanElement = this.internalGetConfiguration(doc, objectNames[j]);
            serverElement.appendChild(mbeanElement);
        }
        doc.appendChild(serverElement);
        new DOMWriter((Writer)out).setPrettyprint(true).print((Node)doc);
        ((Writer)out).close();
        return ((Object)out).toString();
    }

    protected void configure(ObjectName objectName, ObjectName loaderName, Element mbeanElement, List mbeans) throws Exception {
        MBeanInfo info;
        try {
            info = this.server.getMBeanInfo(objectName);
        }
        catch (InstanceNotFoundException e) {
            throw new DeploymentException("trying to configure nonexistent mbean: " + objectName);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not get mbeanInfo", JMXExceptionDecoder.decode((Throwable)e));
        }
        if (info == null) {
            throw new DeploymentException("MBeanInfo is null for mbean: " + objectName);
        }
        ClassLoader cl = this.server.getClassLoader(loaderName);
        MBeanAttributeInfo[] attributes = info.getAttributes();
        HashMap<String, MBeanAttributeInfo> attributeMap = new HashMap<String, MBeanAttributeInfo>();
        for (int i = 0; i < attributes.length; ++i) {
            MBeanAttributeInfo attr = attributes[i];
            attributeMap.put(attr.getName(), attr);
        }
        NodeList attrs = mbeanElement.getChildNodes();
        for (int j = 0; j < attrs.getLength(); ++j) {
            if (attrs.item(j).getNodeType() != 1) continue;
            Element element = (Element)attrs.item(j);
            boolean replace = true;
            if (element.getTagName().equals("attribute")) {
                String trimAttr;
                String attributeName = element.getAttribute("name");
                boolean trim = true;
                String replaceAttr = element.getAttribute("replace");
                if (replaceAttr.length() > 0) {
                    replace = Boolean.valueOf(replaceAttr);
                }
                if ((trimAttr = element.getAttribute("trim")).length() > 0) {
                    trim = Boolean.valueOf(trimAttr);
                }
                String serialDataType = element.getAttribute("serialDataType");
                MBeanAttributeInfo attr = (MBeanAttributeInfo)attributeMap.get(attributeName);
                if (attr == null) {
                    throw new DeploymentException("No Attribute found with name: " + attributeName);
                }
                if (!element.hasChildNodes()) continue;
                Object value = null;
                value = serialDataType.equals("javaBean") ? this.parseJavaBeanSerialData(attr, cl, element, replace, trim) : (serialDataType.equals("jbxb") ? this.parseJbxbSerialData(attr, cl, element, replace, trim) : this.parseTextSerialData(attr, cl, element, replace, trim));
                if (this.log.isDebugEnabled()) {
                    Object outputValue = value;
                    if (attributeName.toLowerCase().indexOf("password") != -1) {
                        outputValue = "****";
                    }
                    this.log.debug((Object)(attributeName + " set to " + outputValue + " in " + objectName));
                }
                this.setAttribute(objectName, new Attribute(attributeName, value));
                continue;
            }
            if (element.getTagName().equals("depends")) {
                if (!element.hasChildNodes()) {
                    throw new DeploymentException("No ObjectName supplied for depends in  " + objectName);
                }
                String mbeanRefName = element.getAttribute("optional-attribute-name");
                mbeanRefName = "".equals(mbeanRefName) ? null : StringPropertyReplacer.replaceProperties((String)mbeanRefName);
                String proxyType = element.getAttribute("proxy-type");
                proxyType = "".equals(proxyType) ? null : StringPropertyReplacer.replaceProperties((String)proxyType);
                ObjectName dependsObjectName = this.processDependency(objectName, loaderName, element, mbeans, replace);
                this.log.debug((Object)("considering " + (mbeanRefName == null ? "<anonymous>" : mbeanRefName.toString()) + " with object name " + dependsObjectName));
                if (mbeanRefName == null) continue;
                Object attribute = dependsObjectName;
                if (proxyType != null) {
                    if (mbeanRefName == null) {
                        throw new DeploymentException("You cannot use a proxy-type without an optional-attribute-name");
                    }
                    if (proxyType.equals("attribute")) {
                        MBeanAttributeInfo attr = (MBeanAttributeInfo)attributeMap.get(mbeanRefName);
                        if (attr == null) {
                            throw new DeploymentException("No Attribute found with name: " + mbeanRefName);
                        }
                        proxyType = attr.getType();
                    }
                    Class<?> proxyClass = cl.loadClass(proxyType);
                    attribute = MBeanProxyExt.create(proxyClass, (ObjectName)dependsObjectName, (MBeanServer)this.server, (boolean)true);
                }
                this.setAttribute(objectName, new Attribute(mbeanRefName, attribute));
                continue;
            }
            if (!element.getTagName().equals("depends-list")) continue;
            String dependsListName = element.getAttribute("optional-attribute-name");
            if ("".equals(dependsListName)) {
                dependsListName = null;
            }
            NodeList dependsList = element.getChildNodes();
            ArrayList<ObjectName> dependsListNames = new ArrayList<ObjectName>();
            for (int l = 0; l < dependsList.getLength(); ++l) {
                Element dependsElement;
                if (dependsList.item(l).getNodeType() != 1 || !(dependsElement = (Element)dependsList.item(l)).getTagName().equals("depends-list-element")) continue;
                if (!dependsElement.hasChildNodes()) {
                    throw new DeploymentException("Empty depends-list-element!");
                }
                ObjectName dependsObjectName = this.processDependency(objectName, loaderName, dependsElement, mbeans, replace);
                if (dependsListNames.contains(dependsObjectName)) continue;
                dependsListNames.add(dependsObjectName);
            }
            if (dependsListName == null) continue;
            this.setAttribute(objectName, new Attribute(dependsListName, dependsListNames));
        }
        if (this.serviceBinding != null) {
            try {
                this.serviceBinding.applyServiceConfig(objectName);
            }
            catch (Exception e) {
                Throwable t = JMXExceptionDecoder.decode((Throwable)e);
                this.log.warn((Object)"Failed to apply service binding override", t);
            }
        }
    }

    private ObjectName internalInstall(Element mbeanElement, List mbeans, ObjectName loaderName, boolean replace) throws Exception {
        ObjectInstance instance = null;
        ObjectName mbeanName = this.parseObjectName(mbeanElement, replace);
        instance = this.serviceCreator.install(mbeanName, loaderName, mbeanElement);
        mbeanName = instance.getObjectName();
        mbeans.add(mbeanName);
        if (mbeanName != null) {
            ServiceContext ctx = this.serviceController.createServiceContext(mbeanName);
            try {
                this.configure(mbeanName, loaderName, mbeanElement, mbeans);
                ctx.state = 1;
                ctx.problem = null;
            }
            catch (Throwable e) {
                ctx.state = 4;
                ctx.problem = e;
                this.log.info((Object)("Problem configuring service " + mbeanName), e);
            }
        }
        return mbeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseTextSerialData(MBeanAttributeInfo attr, ClassLoader cl, Element element, boolean replace, boolean trim) throws Exception {
        String attributeName = attr.getName();
        String attributeText = this.getElementContent(element, trim, replace);
        String typeName = attr.getType();
        Class<?> typeClass = Classes.getPrimitiveTypeForName((String)typeName);
        if (typeClass == null) {
            try {
                typeClass = cl.loadClass(typeName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Class not found for attribute: " + attributeName, e);
            }
        }
        Object value = null;
        if (typeClass.equals(Element.class)) {
            NodeList nl = element.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                value = n;
                break;
            }
            if (replace) {
                PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
                if (editor == null) {
                    this.log.warn((Object)"Cannot perform property replace on Element");
                } else {
                    editor.setValue(value);
                    String text = editor.getAsText();
                    text = StringPropertyReplacer.replaceProperties((String)text);
                    editor.setAsText(text);
                    value = editor.getValue();
                }
            }
        }
        if (value == null) {
            PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
            if (editor == null) {
                throw new DeploymentException("No property editor for attribute: " + attributeName + "; type=" + typeClass);
            }
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            try {
                editor.setAsText(attributeText);
                value = editor.getValue();
                Object var15_17 = null;
                Thread.currentThread().setContextClassLoader(tcl);
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                Thread.currentThread().setContextClassLoader(tcl);
                throw throwable;
            }
        }
        return value;
    }

    private Object parseJavaBeanSerialData(MBeanAttributeInfo attr, ClassLoader cl, Element element, boolean replace, boolean trim) throws Exception {
        String attributeClassName = element.getAttribute("attributeClass");
        if (attributeClassName == null || attributeClassName.length() == 0) {
            attributeClassName = attr.getType();
        }
        Class<?> attributeClass = cl.loadClass(attributeClassName);
        Object bean = attributeClass.newInstance();
        NodeList properties = element.getElementsByTagName("property");
        Properties beanProps = new Properties();
        for (int n = 0; n < properties.getLength(); ++n) {
            Node node = properties.item(n);
            if (node.getNodeType() != 1) continue;
            Element property = (Element)node;
            String name = property.getAttribute("name");
            String value = this.getElementContent(property, trim, replace);
            beanProps.setProperty(name, value);
        }
        PropertyEditors.mapJavaBeanProperties(bean, (Properties)beanProps);
        return bean;
    }

    private Object parseJbxbSerialData(MBeanAttributeInfo attr, ClassLoader cl, Element element, boolean replace, boolean trim) throws Exception {
        StringBuffer buffer = ServiceConfigurator.getElementContent(element);
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        StringReader reader = new StringReader(buffer.toString());
        Object bean = unmarshaller.unmarshal((Reader)reader, (SchemaBindingResolver)resolver);
        return bean;
    }

    private ObjectName processDependency(ObjectName container, ObjectName loaderName, Element element, List mbeans, boolean replace) throws Exception {
        ObjectName dependsObjectName = null;
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node childNode = nl.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element child = (Element)childNode;
            if (child.getTagName().equals("mbean")) {
                dependsObjectName = this.internalInstall(child, mbeans, loaderName, replace);
                break;
            }
            throw new DeploymentException("Non mbean child element in depends tag: " + child);
        }
        if (dependsObjectName == null) {
            String name = this.getElementContent(element, true, replace);
            dependsObjectName = ObjectNameFactory.create((String)name);
        }
        if (dependsObjectName == null) {
            throw new DeploymentException("No object name found for attribute!");
        }
        this.serviceController.registerDependency(container, dependsObjectName);
        return dependsObjectName;
    }

    private void setAttribute(ObjectName name, Attribute attr) throws Exception {
        try {
            this.server.setAttribute(name, attr);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception setting attribute " + attr + " on mbean " + name, JMXExceptionDecoder.decode((Throwable)e));
        }
    }

    private Element internalGetConfiguration(Document doc, ObjectName name) throws Exception {
        Element mbeanElement = doc.createElement("mbean");
        mbeanElement.setAttribute("name", name.toString());
        MBeanInfo info = this.server.getMBeanInfo(name);
        mbeanElement.setAttribute("code", info.getClassName());
        MBeanAttributeInfo[] attributes = info.getAttributes();
        boolean trace = this.log.isTraceEnabled();
        for (int i = 0; i < attributes.length; ++i) {
            if (trace) {
                this.log.trace((Object)("considering attribute: " + attributes[i]));
            }
            if (!attributes[i].isReadable() || !attributes[i].isWritable()) continue;
            Element attributeElement = null;
            if (attributes[i].getType().equals("javax.management.ObjectName")) {
                attributeElement = doc.createElement("depends");
                attributeElement.setAttribute("optional-attribute-name", attributes[i].getName());
            } else {
                attributeElement = doc.createElement("attribute");
                attributeElement.setAttribute("name", attributes[i].getName());
            }
            Object value = this.server.getAttribute(name, attributes[i].getName());
            if (value != null) {
                if (value instanceof Element) {
                    attributeElement.appendChild(doc.importNode((Element)value, true));
                } else {
                    attributeElement.appendChild(doc.createTextNode(value.toString()));
                }
            }
            mbeanElement.appendChild(attributeElement);
        }
        ServiceContext sc = this.serviceController.getServiceContext(name);
        Iterator i = sc.iDependOn.iterator();
        while (i.hasNext()) {
            ServiceContext needs = (ServiceContext)i.next();
            Element dependsElement = doc.createElement("depends");
            dependsElement.appendChild(doc.createTextNode(needs.objectName.toString()));
            mbeanElement.appendChild(dependsElement);
        }
        return mbeanElement;
    }

    private ObjectName parseObjectName(Element element, boolean replace) throws Exception {
        String name = element.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new DeploymentException("MBean attribute 'name' must be given.");
        }
        if (replace) {
            name = StringPropertyReplacer.replaceProperties((String)name);
        }
        return new ObjectName(name);
    }

    private String getElementContent(Element element, boolean trim, boolean replace) throws Exception {
        NodeList nl = element.getChildNodes();
        String attributeText = "";
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Text)) continue;
            attributeText = attributeText + ((Text)n).getData();
        }
        if (trim) {
            attributeText = attributeText.trim();
        }
        if (replace) {
            attributeText = StringPropertyReplacer.replaceProperties((String)attributeText);
        }
        return attributeText;
    }

    public static StringBuffer getElementContent(Element element) throws IOException, TransformerException {
        NodeList children = element.getChildNodes();
        Element content = null;
        for (int n = 0; n < children.getLength(); ++n) {
            Node node = children.item(n);
            if (node.getNodeType() != 1) continue;
            content = (Element)node;
            break;
        }
        if (content == null) {
            return null;
        }
        DOMSource source = new DOMSource(content);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        sw.close();
        return sw.getBuffer();
    }

    static {
        PropertyEditors.init();
    }
}

