/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.CallerConstructorInfo;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.AdviceMethodFactory;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.InterceptorFactoryWrapper;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.MethodJoinPointGenerator;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.util.JavassistUtils;
import org.jboss.aop.util.ReflectToJavassist;

public abstract class JoinPointGenerator {
    public static final String INFO_FIELD = "info";
    public static final String INVOKE_JOINPOINT = "invokeJoinpoint";
    public static final String DISPATCH = "dispatch";
    protected static final String TARGET_FIELD = "tgt";
    protected static final String GENERATED_CLASS_ADVISOR = GeneratedClassAdvisor.class.getName();
    public static final String GENERATE_JOINPOINT_CLASS = "generateJoinPointClass";
    private static final String CURRENT_ADVICE = "super.currentInterceptor";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_";
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_";
    public static final String GENERATOR_PREFIX = "generator_";
    private static final String RETURN_VALUE = "ret";
    private static final String THROWABLE = "t";
    private JoinPointInfo oldInfo;
    protected JoinPointInfo info;
    private static int increment;
    private Class advisorClass;
    protected GeneratedClassAdvisor advisor;
    protected String joinpointClassName;
    protected String joinpointFieldName;
    private String joinpointFqn;
    private Field joinpointField;
    private Field generatorField;
    private boolean initialised;

    public JoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info) {
        this.info = info;
        this.advisor = advisor;
        this.advisorClass = advisor.getClass();
        Class<?>[] interfaces = this.advisorClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(InstanceAdvisor.class)) continue;
            this.advisorClass = this.advisorClass.getSuperclass();
            break;
        }
        this.initialiseJoinPointNames();
        this.findAdvisedField(this.advisorClass);
    }

    public void rebindJoinpoint(JoinPointInfo newInfo) {
        try {
            if (this.joinpointField == null) {
                return;
            }
            if (this.initialised && this.oldInfo != null && this.oldInfo.equalChains(newInfo)) {
                return;
            }
            this.oldInfo = this.info.copy();
            this.info = newInfo;
            this.joinpointField.set(this.advisor, null);
            if (this.info.getInterceptors() == null && this.info.getFactories() == null) {
                this.generatorField.set(this.advisor, null);
            } else {
                this.generatorField.set(this.advisor, this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void generateJoinPointClass() {
        try {
            if (this.joinpointField.get(this.advisor) != null) {
                return;
            }
            AspectManager manager = AspectManager.instance();
            ClassPool pool = manager.findClassPool(Thread.currentThread().getContextClassLoader());
            GeneratedClassInfo generatedClass = this.generateJoinpointClass(pool, this.info);
            Class clazz = this.toClass(pool, generatedClass.getGenerated());
            Object obj = this.instantiateClass(clazz, generatedClass.getAroundSetups());
            this.joinpointField.set(this.advisor, obj);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error generating joinpoint class for joinpoint " + this.info, e);
        }
        this.initialised = true;
    }

    private Class toClass(ClassPool pool, CtClass ctclass) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        if (AspectManager.debugClasses) {
            CtClass advisedClass = pool.get(this.advisor.getClazz().getName());
            TransformerCommon.compileOrLoadClass(advisedClass, ctclass, true);
            return Thread.currentThread().getContextClassLoader().loadClass(ctclass.getName());
        }
        return ctclass.toClass();
    }

    private Object instantiateClass(Class clazz, AdviceSetup[] aroundSetups) throws Exception {
        Constructor ctor = clazz.getConstructor(this.info.getClass());
        Object obj = ctor.newInstance(this.info);
        for (int i = 0; i < aroundSetups.length; ++i) {
            if (!aroundSetups[i].isNewCFlow()) continue;
            Field field = clazz.getDeclaredField("cflow" + aroundSetups[i].useCFlowFrom());
            field.setAccessible(true);
            field.set(obj, aroundSetups[i].getCFlow());
        }
        return obj;
    }

    private static synchronized int getIncrement() {
        return ++increment;
    }

    protected abstract void initialiseJoinPointNames();

    private GeneratedClassInfo generateJoinpointClass(ClassPool pool, JoinPointInfo newInfo) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        CtClass superClass = pool.get(this.joinpointFqn);
        String className = this.advisor.getClass().getPackage().getName() + "." + this.joinpointClassName + "_" + JoinPointGenerator.getIncrement();
        try {
            CtClass clazz = pool.makeClass(className);
            clazz.setSuperclass(superClass);
            JoinPointGenerator.addUntransformableInterface(pool, clazz);
            AdviceSetupsByType setups = this.initialiseAdviceInfosAndAddFields(pool, clazz);
            this.createConstructors(pool, superClass, clazz, setups);
            this.createJoinPointInvokeMethod(superClass, clazz, this.isVoid(), setups);
            this.createInvokeNextMethod(clazz, this.isVoid(), setups.getAroundSetups());
            this.overrideDispatchMethods(superClass, clazz, newInfo);
            return new GeneratedClassInfo(clazz, setups.getAroundSetups());
        }
        catch (NotFoundException e) {
            System.err.println("Exception generating " + className + ": " + e.getMessage());
            throw e;
        }
        catch (CannotCompileException e) {
            System.err.println("Exception generating " + className + ": " + e.getMessage());
            throw e;
        }
        catch (ClassNotFoundException e) {
            System.err.println("Exception generating " + className + ": " + e.getMessage());
            throw e;
        }
    }

    protected abstract boolean isVoid();

    protected abstract Class getReturnType();

    protected abstract AdviceMethodProperties getAdviceMethodProperties(AdviceSetup var1);

    protected boolean isCaller() {
        return false;
    }

    protected boolean hasCallingObject() {
        return false;
    }

    protected abstract boolean hasTargetObject();

    private boolean isStaticCall() {
        if (this.isCaller()) {
            return !this.hasCallingObject();
        }
        return !this.hasTargetObject();
    }

    private void findAdvisedField(Class advisorSuperClazz) {
        try {
            this.joinpointField = advisorSuperClazz.getDeclaredField(this.joinpointFieldName);
            this.joinpointField.setAccessible(true);
            this.joinpointFqn = advisorSuperClazz.getDeclaringClass().getName() + "$" + this.joinpointClassName;
            try {
                this.generatorField = advisorSuperClazz.getDeclaredField(this.getJoinPointGeneratorFieldName());
                this.generatorField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Found joinpoint field " + this.joinpointField.getName() + " in " + advisorSuperClazz.getName() + " but no JoinPointGenerator field called " + this.getJoinPointGeneratorFieldName());
            }
        }
        catch (NoSuchFieldException e) {
            if (!advisorSuperClazz.getName().equals(GENERATED_CLASS_ADVISOR)) {
                this.findAdvisedField(advisorSuperClazz.getSuperclass());
            }
        }
    }

    private AdviceSetupsByType initialiseAdviceInfosAndAddFields(ClassPool pool, CtClass clazz) throws ClassNotFoundException, NotFoundException, CannotCompileException {
        HashMap cflows = new HashMap();
        AdviceSetup[] setups = new AdviceSetup[this.info.getFactories().length];
        for (int i = 0; i < this.info.getFactories().length; ++i) {
            setups[i] = new AdviceSetup(i, this.info.getFactories()[i]);
            this.addAspectFieldAndGetter(pool, clazz, setups[i]);
            this.addCFlowFieldsAndGetters(pool, setups[i], clazz, cflows);
        }
        return new AdviceSetupsByType(setups);
    }

    private void addAspectFieldAndGetter(ClassPool pool, CtClass clazz, AdviceSetup setup) throws NotFoundException, CannotCompileException {
        CtClass aspectClass = setup.getAspectCtClass();
        if (!setup.shouldInvokeAspect()) {
            return;
        }
        CtField field = new CtField(aspectClass, setup.getAspectFieldName(), clazz);
        field.setModifiers(130);
        clazz.addField(field);
        CtMethod method = CtNewMethod.make((CtClass)aspectClass, (String)setup.getAspectInitialiserName(), (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], null, (CtClass)clazz);
        method.setModifiers(2);
        clazz.addMethod(method);
        if (setup.requiresInstanceAdvisor()) {
            String instanceAdvisor = this.isCaller() ? "org.jboss.aop.InstanceAdvisor ia = ((org.jboss.aop.Advised)callingObject)._getInstanceAdvisor();" : "org.jboss.aop.InstanceAdvisor ia = ((org.jboss.aop.Advised)targetObject)._getInstanceAdvisor();";
            String body = "{   " + instanceAdvisor + "   org.jboss.aop.advice.InterceptorFactoryWrapper fw = info.getFactories()[" + setup.getIndex() + "];" + "   Object o = fw.getPerInstanceAspect(info.getAdvisor(), info.getJoinpoint(), ia);" + "   return (" + setup.getAspectClass().getName() + ")o;" + "}";
            method.setBody(body);
        } else {
            String body = "{   if (" + setup.getAspectFieldName() + " != null)" + "   {" + "      return " + setup.getAspectFieldName() + ";" + "   }" + "   org.jboss.aop.advice.InterceptorFactoryWrapper fw = info.getFactories()[" + setup.getIndex() + "];" + "   Object o = fw.getAspect(info.getAdvisor(), info.getJoinpoint());" + "   return (" + setup.getAspectClass().getName() + ")o;" + "}";
            method.setBody(body);
        }
    }

    private void addCFlowFieldsAndGetters(ClassPool pool, AdviceSetup setup, CtClass clazz, HashMap cflows) throws NotFoundException, CannotCompileException {
        if (setup.getCFlowString() != null) {
            Integer useCFlowIndex = (Integer)cflows.get(setup.getCFlowString());
            if (useCFlowIndex == null) {
                useCFlowIndex = new Integer(setup.getIndex());
                cflows.put(setup.getCFlowString(), useCFlowIndex);
                CtField cflowX = new CtField(pool.get(ASTCFlowExpression.class.getName()), "cflow" + useCFlowIndex, clazz);
                clazz.addField(cflowX);
                CtField matchesCFlowX = new CtField(CtClass.booleanType, "matchesCflow" + useCFlowIndex, clazz);
                clazz.addField(matchesCFlowX);
                CtMethod initCFlowX = CtNewMethod.make((CtClass)CtClass.booleanType, (String)("getCFlow" + useCFlowIndex), (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], null, (CtClass)clazz);
                initCFlowX.setBody("{   org.jboss.aop.pointcut.CFlowMatcher matcher = new org.jboss.aop.pointcut.CFlowMatcher();   return matcher.matches(" + cflowX.getName() + ", this);" + "}");
                clazz.addMethod(initCFlowX);
            }
            setup.setUseCFlowFrom(useCFlowIndex);
        }
    }

    private void createJoinPointInvokeMethod(CtClass superClass, CtClass clazz, boolean isVoid, AdviceSetupsByType setups) throws CannotCompileException, NotFoundException {
        CtMethod superInvoke = superClass.getDeclaredMethod(INVOKE_JOINPOINT);
        CtMethod invoke = CtNewMethod.make((CtClass)superInvoke.getReturnType(), (String)superInvoke.getName(), (CtClass[])superInvoke.getParameterTypes(), (CtClass[])superInvoke.getExceptionTypes(), null, (CtClass)clazz);
        String code = null;
        try {
            code = this.createJoinpointInvokeBody(clazz, setups, superInvoke.getExceptionTypes());
            invoke.setBody(code);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Error compiling code for Joinpoint (" + this.info.getJoinpoint() + "): " + code + "\n - " + (Object)((Object)e) + "\n - " + invoke + "\n - " + clazz.getName(), e);
        }
        clazz.addMethod(invoke);
    }

    private String createJoinpointInvokeBody(CtClass joinpointClass, AdviceSetupsByType setups, CtClass[] declaredExceptions) throws NotFoundException {
        StringBuffer code = new StringBuffer();
        code.append("{");
        if (!this.isVoid()) {
            String ret = null;
            Class retType = this.getReturnType();
            if (retType.isPrimitive()) {
                if (retType.equals(Boolean.TYPE)) {
                    ret = "false";
                } else if (retType.equals(Character.TYPE)) {
                    ret = "'\\0'";
                } else if (retType.equals(Byte.TYPE)) {
                    ret = "(byte)0";
                } else if (retType.equals(Short.TYPE)) {
                    ret = "(short)0";
                } else if (retType.equals(Integer.TYPE)) {
                    ret = "(int)0";
                } else if (retType.equals(Long.TYPE)) {
                    ret = "0L";
                } else if (retType.equals(Float.TYPE)) {
                    ret = "0.0f";
                } else if (retType.equals(Double.TYPE)) {
                    ret = "0.0d";
                }
            }
            code.append("   " + ClassExpression.simpleType(this.getReturnType()) + "  " + RETURN_VALUE + " = " + ret + ";");
        }
        code.append("   try");
        code.append("   {");
        this.addBeforeInvokeCode(code, setups);
        this.addAroundInvokeCode(code, setups, joinpointClass);
        this.addAfterInvokeCode(code, setups);
        code.append("   }");
        code.append("   catch(java.lang.Throwable t)");
        code.append("   {");
        this.addThrowingInvokeCode(code, setups);
        this.addHandleExceptionCode(code, declaredExceptions);
        code.append("   }");
        if (!this.isVoid()) {
            code.append("   return ret;");
        }
        code.append("}");
        return code.toString();
    }

    private void addBeforeInvokeCode(StringBuffer code, AdviceSetupsByType setups) throws NotFoundException {
        AdviceSetup[] bsetups = setups.getBeforeSetups();
        if (bsetups != null) {
            for (int i = 0; i < bsetups.length; ++i) {
                AdviceMethodProperties properties = bsetups[i].getAdviceMethodProperties();
                if (properties == null) continue;
                code.append(bsetups[i].getAspectFieldName() + "." + bsetups[i].getAdviceName() + "(");
                this.appendAdviceCallParameters(code, properties, false);
                code.append(");");
            }
        }
    }

    private void addAroundInvokeCode(StringBuffer code, AdviceSetupsByType setups, CtClass joinpointClass) throws NotFoundException {
        if (setups.getAroundSetups() != null) {
            StringBuffer aspects = new StringBuffer();
            StringBuffer cflows = new StringBuffer();
            AdviceSetup[] asetups = setups.getAllSetups();
            for (int i = 0; i < asetups.length; ++i) {
                if (!asetups[i].requiresInstanceAdvisor()) {
                    aspects.append(", ");
                    aspects.append(asetups[i].getAspectFieldName());
                }
                if (!asetups[i].isNewCFlow()) continue;
                cflows.append(", cflow" + asetups[i].getIndex());
            }
            code.append("      if(info.getFactories() != null)");
            code.append("      {");
            code.append("         " + this.joinpointFqn + " jp = new " + joinpointClass.getName() + "(this, $$" + aspects.toString() + cflows.toString() + ");");
            if (!this.isVoid()) {
                code.append("          ret = ($r)");
            }
            code.append("jp.invokeNext();");
            code.append("      }");
            code.append("      else");
            code.append("      {");
            this.addDispatchCode(code);
            code.append("      }");
        } else {
            this.addDispatchCode(code);
        }
    }

    private void addDispatchCode(StringBuffer code) {
        if (!this.isVoid()) {
            code.append("          ret = ");
        }
        code.append("super.dispatch($$);");
    }

    private void addAfterInvokeCode(StringBuffer code, AdviceSetupsByType setups) throws NotFoundException {
        AdviceSetup[] asetups = setups.getAfterSetups();
        if (asetups != null) {
            for (int i = 0; i < asetups.length; ++i) {
                AdviceMethodProperties properties = asetups[i].getAdviceMethodProperties();
                if (properties == null) continue;
                if (!this.isVoid() && !properties.isAdviceVoid()) {
                    code.append("          ret = (" + this.getReturnType().getName() + ")");
                }
                code.append(asetups[i].getAspectFieldName() + "." + asetups[i].getAdviceName() + "(");
                this.appendAdviceCallParameters(code, properties, false);
                code.append(");");
            }
        }
    }

    private void addThrowingInvokeCode(StringBuffer code, AdviceSetupsByType setups) throws NotFoundException {
        AdviceSetup[] tsetups = setups.getThrowingSetups();
        if (tsetups != null) {
            for (int i = 0; i < tsetups.length; ++i) {
                AdviceMethodProperties properties = tsetups[i].getAdviceMethodProperties();
                if (properties == null) continue;
                code.append(tsetups[i].getAspectFieldName() + "." + tsetups[i].getAdviceName() + "(");
                this.appendAdviceCallParameters(code, properties, false);
                code.append(");");
            }
        }
    }

    private void addHandleExceptionCode(StringBuffer code, CtClass[] declaredExceptions) {
        for (int i = 0; i < declaredExceptions.length; ++i) {
            code.append("if (t instanceof " + declaredExceptions[i].getName() + ")");
            code.append("   throw (" + declaredExceptions[i].getName() + ")t;");
        }
        code.append("if (t instanceof java.lang.RuntimeException)");
        code.append("throw t;");
        code.append("throw new java.lang.RuntimeException(t);");
    }

    private void createInvokeNextMethod(CtClass jp, boolean isVoid, AdviceSetup[] aroundSetups) throws NotFoundException, CannotCompileException {
        if (aroundSetups == null) {
            return;
        }
        CtMethod method = jp.getSuperclass().getSuperclass().getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.copy((CtMethod)method, (CtClass)jp, null);
        String code = this.createInvokeNextMethodBody(jp, isVoid, aroundSetups);
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Error creating invokeNext method: " + code, e);
        }
        jp.addMethod(invokeNext);
    }

    private String createInvokeNextMethodBody(CtClass jp, boolean isVoid, AdviceSetup[] aroundSetups) throws NotFoundException {
        String returnStr = isVoid ? "" : "return ($w)";
        StringBuffer body = new StringBuffer();
        body.append("{");
        body.append("   try{");
        body.append("      switch(++super.currentInterceptor){");
        int addedAdvice = 0;
        for (int i = 0; i < aroundSetups.length; ++i) {
            AdviceMethodProperties properties;
            if (!aroundSetups[i].shouldInvokeAspect() || (properties = AdviceMethodFactory.AROUND.findAdviceMethod(this.getAdviceMethodProperties(aroundSetups[i]))) == null || properties.getAdviceMethod() == null) continue;
            body.append("      case " + ++addedAdvice + ":");
            if (aroundSetups[i].getCFlowString() != null) {
                body.append("         if (matchesCflow" + aroundSetups[i].useCFlowFrom() + ")");
                body.append("         {");
                this.appendAroundCallString(body, returnStr, aroundSetups[i], properties);
                body.append("         }");
                body.append("         else");
                body.append("         {");
                body.append("            " + returnStr + " invokeNext();");
                body.append("         }");
            } else {
                this.appendAroundCallString(body, returnStr, aroundSetups[i], properties);
            }
            body.append("      break;");
        }
        body.append("      default:");
        body.append("         " + returnStr + "this.dispatch();");
        body.append("      }");
        body.append("   }finally{");
        body.append("      --super.currentInterceptor;");
        body.append("   }");
        body.append("   return null;");
        body.append("}");
        return body.toString();
    }

    private void createConstructors(ClassPool pool, CtClass superClass, CtClass clazz, AdviceSetupsByType setups) throws NotFoundException, CannotCompileException {
        CtConstructor[] superCtors = superClass.getDeclaredConstructors();
        if (superCtors.length != 2 && !this.getClass().equals(MethodJoinPointGenerator.class)) {
            throw new RuntimeException("JoinPoints should only have 2 and only constructors, not " + superCtors.length);
        }
        if (superCtors.length != 3 && this.getClass().equals(MethodJoinPointGenerator.class)) {
            throw new RuntimeException("Method JoinPoints should only have 2 and only constructors, not " + superCtors.length);
        }
        int publicIndex = -1;
        int protectedIndex = -1;
        int defaultIndex = -1;
        for (int i = 0; i < superCtors.length; ++i) {
            int modifier = superCtors[i].getModifiers();
            if (Modifier.isPublic((int)modifier)) {
                if (superCtors[i].getParameterTypes().length == 0) {
                    defaultIndex = i;
                    continue;
                }
                publicIndex = i;
                continue;
            }
            if (!Modifier.isProtected((int)modifier)) continue;
            protectedIndex = i;
        }
        if (publicIndex < 0 || protectedIndex < 0) {
            throw new RuntimeException("One of the JoinPoint constructors should be public, the other protected");
        }
        if (defaultIndex >= 0) {
            this.createDefaultConstructor(superCtors[defaultIndex], clazz);
        }
        this.createPublicConstructor(superCtors[publicIndex], clazz, setups);
        this.createProtectedConstructor(pool, superCtors[protectedIndex], clazz, setups);
        this.createCopyConstructorAndMethod(pool, clazz);
        this.overrideGetInterceporsMethod(pool, clazz);
    }

    private void createDefaultConstructor(CtConstructor superCtor, CtClass clazz) throws CannotCompileException {
        CtConstructor ctor = CtNewConstructor.defaultConstructor((CtClass)clazz);
        clazz.addConstructor(ctor);
    }

    private void createPublicConstructor(CtConstructor superCtor, CtClass clazz, AdviceSetupsByType setups) throws CannotCompileException, NotFoundException {
        StringBuffer body = new StringBuffer();
        try {
            CtConstructor ctor = CtNewConstructor.make((CtClass[])superCtor.getParameterTypes(), (CtClass[])superCtor.getExceptionTypes(), (CtClass)clazz);
            ctor.setModifiers(superCtor.getModifiers());
            clazz.addConstructor(ctor);
            body.append("{super($$);");
            AdviceSetup[] allSetups = setups.getAllSetups();
            for (int i = 0; i < allSetups.length; ++i) {
                if (allSetups[i].requiresInstanceAdvisor()) continue;
                body.append(allSetups[i].getAspectFieldName() + " = " + allSetups[i].getAspectInitialiserName() + "();");
            }
            body.append("}");
            ctor.setBody(body.toString());
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException("Error compiling. Code \n" + body.toString(), (Throwable)e);
        }
    }

    private void createProtectedConstructor(ClassPool pool, CtConstructor superCtor, CtClass clazz, AdviceSetupsByType setups) throws CannotCompileException, NotFoundException {
        CtClass[] superParams = superCtor.getParameterTypes();
        ArrayList<AdviceSetup> aspects = new ArrayList<AdviceSetup>();
        ArrayList<Integer> cflows = new ArrayList<Integer>();
        StringBuffer adviceInit = new StringBuffer();
        AdviceSetup[] allSetups = setups.getAllSetups();
        for (int i = 0; i < allSetups.length; ++i) {
            if (!allSetups[i].shouldInvokeAspect()) continue;
            if (allSetups[i].requiresInstanceAdvisor()) {
                adviceInit.append(allSetups[i].getAspectFieldName() + " = " + allSetups[i].getAspectInitialiserName() + "();");
            } else {
                aspects.add(allSetups[i]);
            }
            if (!allSetups[i].isNewCFlow()) continue;
            cflows.add(new Integer(allSetups[i].useCFlowFrom()));
        }
        StringBuffer cflowInit = new StringBuffer();
        CtClass[] params = new CtClass[superParams.length + aspects.size() + cflows.size()];
        System.arraycopy(superParams, 0, params, 0, superParams.length);
        for (int i = 0; i < aspects.size(); ++i) {
            AdviceSetup setup = (AdviceSetup)aspects.get(i);
            params[i + superParams.length] = setup.getAspectCtClass();
            adviceInit.append("this." + setup.getAspectFieldName() + " = $" + (i + superParams.length + 1) + ";");
        }
        int aspectsLength = superParams.length + aspects.size();
        if (cflows.size() > 0) {
            CtClass astCFlowExpr = pool.get(ASTCFlowExpression.class.getName());
            for (int i = 0; i < cflows.size(); ++i) {
                params[i + aspectsLength] = astCFlowExpr;
                cflowInit.append("cflow" + cflows.get(i) + "= $" + (i + aspectsLength + 1) + ";");
                cflowInit.append("matchesCflow" + cflows.get(i) + " = getCFlow" + allSetups[i].useCFlowFrom() + "();");
            }
        }
        CtConstructor ctor = CtNewConstructor.make((CtClass[])params, (CtClass[])superCtor.getExceptionTypes(), (CtClass)clazz);
        ctor.setModifiers(superCtor.getModifiers());
        clazz.addConstructor(ctor);
        StringBuffer body = new StringBuffer("{super(");
        for (int i = 0; i < superParams.length; ++i) {
            if (i > 0) {
                body.append(", ");
            }
            body.append("$" + (i + 1));
        }
        body.append(");");
        body.append(adviceInit.toString());
        body.append(cflowInit.toString());
        body.append("}");
        ctor.setBody(body.toString());
    }

    private void createCopyConstructorAndMethod(ClassPool pool, CtClass clazz) throws NotFoundException, CannotCompileException {
        CtConstructor copyCtor = CtNewConstructor.make((CtClass[])new CtClass[]{clazz}, (CtClass[])new CtClass[0], (CtClass)clazz);
        copyCtor.setModifiers(2);
        clazz.addConstructor(copyCtor);
        StringBuffer body = new StringBuffer();
        body.append("{");
        body.append("   super($1.info);");
        for (CtClass superClass = clazz; superClass != null && !superClass.getName().equals("java.lang.Object"); superClass = superClass.getSuperclass()) {
            CtField[] fields = superClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isPrivate((int)fields[i].getModifiers()) && fields[i].getDeclaringClass() != clazz || Modifier.isFinal((int)fields[i].getModifiers()) || Modifier.isStatic((int)fields[i].getModifiers())) continue;
                body.append("   this." + fields[i].getName() + " = $1." + fields[i].getName() + ";");
            }
        }
        body.append("}");
        copyCtor.setBody(body.toString());
        CtMethod superCopy = pool.get(Invocation.class.getName()).getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)superCopy.getReturnType(), (String)superCopy.getName(), (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], null, (CtClass)clazz);
        clazz.setModifiers(1);
        copy.setBody("{   return new " + clazz.getName() + "(this);" + "}");
        clazz.addMethod(copy);
    }

    private void overrideGetInterceporsMethod(ClassPool pool, CtClass clazz) throws NotFoundException, CannotCompileException {
        CtMethod superGetInterceptors = pool.get(Invocation.class.getName()).getDeclaredMethod("getInterceptors");
        CtMethod copy = CtNewMethod.make((CtClass)superGetInterceptors.getReturnType(), (String)superGetInterceptors.getName(), (CtClass[])superGetInterceptors.getParameterTypes(), (CtClass[])superGetInterceptors.getExceptionTypes(), null, (CtClass)clazz);
        clazz.setModifiers(1);
        copy.setBody("{   if (interceptors != null) return interceptors;   if (info != null) interceptors = info.initialiseInterceptors().getInterceptors();   return interceptors;}");
        clazz.addMethod(copy);
    }

    protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, JoinPointInfo newInfo) throws CannotCompileException, NotFoundException {
    }

    protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, CallerConstructorInfo cinfo) throws NotFoundException, CannotCompileException {
        if (cinfo.getWrappingMethod() == null) {
            return;
        }
        CtMethod[] superDispatches = JavassistUtils.getDeclaredMethodsWithName(superClass, DISPATCH);
        if (superDispatches.length > 2 && AspectManager.verbose) {
            System.out.println("[warn] - Too many dispatch() methods found in " + superClass.getName());
        }
        for (int i = 0; i < superDispatches.length; ++i) {
            CtMethod dispatch = CtNewMethod.make((CtClass)superDispatches[i].getReturnType(), (String)superDispatches[i].getName(), (CtClass[])superDispatches[i].getParameterTypes(), (CtClass[])superDispatches[i].getExceptionTypes(), null, (CtClass)clazz);
            dispatch.setModifiers(superDispatches[i].getModifiers());
            CtMethod wrapperMethod = ReflectToJavassist.methodToJavassist(cinfo.getWrappingMethod());
            CtClass[] params = wrapperMethod.getParameterTypes();
            StringBuffer parameters = new StringBuffer("(");
            if (superDispatches[i].getParameterTypes().length == 0) {
                for (int j = 0; j < params.length; ++j) {
                    if (j > 0) {
                        parameters.append(", ");
                    }
                    parameters.append("arg" + j);
                }
            } else {
                int offset = this.hasCallingObject() ? 1 : 0;
                for (int j = 0; j < params.length; ++j) {
                    if (j > 0) {
                        parameters.append(", ");
                    }
                    parameters.append("$" + (j + offset + 1));
                }
            }
            parameters.append(")");
            String body = "{ return " + cinfo.getConstructor().getDeclaringClass().getName() + "." + cinfo.getWrappingMethod().getName() + parameters + ";}";
            try {
                dispatch.setBody(body);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + dispatch, e);
            }
            clazz.addMethod(dispatch);
        }
    }

    protected static void addUntransformableInterface(Instrumentor instrumentor, CtClass clazz) throws NotFoundException {
        JoinPointGenerator.addUntransformableInterface(instrumentor.getClassPool(), clazz);
    }

    protected static void addUntransformableInterface(ClassPool pool, CtClass clazz) throws NotFoundException {
        CtClass untransformable = pool.get(Untransformable.class.getName());
        clazz.addInterface(untransformable);
    }

    protected abstract String getJoinPointGeneratorFieldName();

    public void appendAroundCallString(StringBuffer invokeNextBody, String returnStr, AdviceSetup setup, AdviceMethodProperties properties) {
        boolean firstParamIsInvocation;
        Integer[] args = properties.getArgs();
        boolean bl = firstParamIsInvocation = args.length >= 1 && args[0].equals(AdviceMethodProperties.INVOCATION_ARG);
        if (!firstParamIsInvocation) {
            invokeNextBody.append("try{");
            invokeNextBody.append("   org.jboss.aop.joinpoint.CurrentInvocation.push(this); ");
        }
        invokeNextBody.append("   " + returnStr + " " + setup.getAspectFieldName() + "." + properties.getAdviceName() + "(");
        this.appendAdviceCallParameters(invokeNextBody, properties, true);
        invokeNextBody.append(");");
        if (!firstParamIsInvocation) {
            invokeNextBody.append("}finally{");
            invokeNextBody.append("   org.jboss.aop.joinpoint.CurrentInvocation.pop(); ");
            invokeNextBody.append("}");
        }
    }

    private void appendAdviceCallParameters(StringBuffer invokeNextBody, AdviceMethodProperties properties, boolean isAround) {
        Integer[] args = properties.getArgs();
        Class[] adviceParams = properties.getAdviceMethod().getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                invokeNextBody.append(", ");
            }
            if (args[i].equals(AdviceMethodProperties.INVOCATION_ARG)) {
                invokeNextBody.append(this.castToAdviceProperties(i, adviceParams) + "this");
                continue;
            }
            if (args[i].equals(AdviceMethodProperties.JOINPOINT_ARG)) {
                invokeNextBody.append(this.castToAdviceProperties(i, adviceParams) + INFO_FIELD);
                continue;
            }
            if (args[i].equals(AdviceMethodProperties.RETURN_ARG)) {
                invokeNextBody.append(this.castToAdviceProperties(i, adviceParams) + RETURN_VALUE);
                continue;
            }
            if (args[i].equals(AdviceMethodProperties.THROWABLE_ARG)) {
                invokeNextBody.append(this.castToAdviceProperties(i, adviceParams) + THROWABLE);
                continue;
            }
            if (isAround) {
                invokeNextBody.append(this.castToAdviceProperties(i, adviceParams) + "this.arg" + args[i]);
                continue;
            }
            int offset = 1;
            if (this.hasTargetObject()) {
                ++offset;
            }
            if (this.hasCallingObject()) {
                ++offset;
            }
            invokeNextBody.append(this.castToAdviceProperties(i, adviceParams) + "$" + (args[i] + offset));
        }
    }

    private String castToAdviceProperties(int i, Class[] args) {
        return "(" + ClassExpression.simpleType(args[i]) + ")";
    }

    private class AdviceSetupsByType {
        AdviceSetup[] allSetups;
        AdviceSetup[] beforeSetups;
        AdviceSetup[] afterSetups;
        AdviceSetup[] throwingSetups;
        AdviceSetup[] aroundSetups;

        AdviceSetupsByType(AdviceSetup[] setups) {
            this.allSetups = setups;
            ArrayList<AdviceSetup> beforeAspects = null;
            ArrayList<AdviceSetup> afterAspects = null;
            ArrayList<AdviceSetup> throwingAspects = null;
            ArrayList<AdviceSetup> aroundAspects = null;
            for (int i = 0; i < setups.length; ++i) {
                AdviceMethodProperties properties;
                if (setups[i].isBefore()) {
                    if (beforeAspects == null) {
                        beforeAspects = new ArrayList<AdviceSetup>();
                    }
                    if ((properties = AdviceMethodFactory.BEFORE.findAdviceMethod(JoinPointGenerator.this.getAdviceMethodProperties(setups[i]))) != null) {
                        setups[i].setAdviceMethodProperties(properties);
                        beforeAspects.add(setups[i]);
                        continue;
                    }
                } else if (setups[i].isAfter()) {
                    if (afterAspects == null) {
                        afterAspects = new ArrayList<AdviceSetup>();
                    }
                    if ((properties = AdviceMethodFactory.AFTER.findAdviceMethod(JoinPointGenerator.this.getAdviceMethodProperties(setups[i]))) != null) {
                        setups[i].setAdviceMethodProperties(properties);
                        afterAspects.add(setups[i]);
                        continue;
                    }
                } else if (setups[i].isThrowing()) {
                    if (throwingAspects == null) {
                        throwingAspects = new ArrayList<AdviceSetup>();
                    }
                    if ((properties = AdviceMethodFactory.THROWING.findAdviceMethod(JoinPointGenerator.this.getAdviceMethodProperties(setups[i]))) != null) {
                        setups[i].setAdviceMethodProperties(properties);
                        throwingAspects.add(setups[i]);
                        continue;
                    }
                } else {
                    if (aroundAspects == null) {
                        aroundAspects = new ArrayList<AdviceSetup>();
                    }
                    if ((properties = AdviceMethodFactory.AROUND.findAdviceMethod(JoinPointGenerator.this.getAdviceMethodProperties(setups[i]))) != null) {
                        setups[i].setAdviceMethodProperties(properties);
                        aroundAspects.add(setups[i]);
                        continue;
                    }
                }
                if (!AspectManager.verbose) continue;
                System.out.println("[warn] No matching advice called '" + setups[i].getAdviceName() + "' could be found in " + setups[i].getAspectClass().getName() + " for joinpoint " + JoinPointGenerator.this.info);
            }
            this.beforeSetups = beforeAspects == null ? null : beforeAspects.toArray(new AdviceSetup[beforeAspects.size()]);
            this.afterSetups = afterAspects == null ? null : afterAspects.toArray(new AdviceSetup[afterAspects.size()]);
            this.throwingSetups = throwingAspects == null ? null : throwingAspects.toArray(new AdviceSetup[throwingAspects.size()]);
            this.aroundSetups = aroundAspects == null ? null : aroundAspects.toArray(new AdviceSetup[aroundAspects.size()]);
        }

        public AdviceSetup[] getAllSetups() {
            return this.allSetups;
        }

        public AdviceSetup[] getAfterSetups() {
            return this.afterSetups;
        }

        public AdviceSetup[] getAroundSetups() {
            return this.aroundSetups;
        }

        public AdviceSetup[] getBeforeSetups() {
            return this.beforeSetups;
        }

        public AdviceSetup[] getThrowingSetups() {
            return this.throwingSetups;
        }
    }

    private class GeneratedClassInfo {
        CtClass generated;
        AdviceSetup[] aroundSetups;

        GeneratedClassInfo(CtClass generated, AdviceSetup[] aroundSetups) {
            this.generated = generated;
            this.aroundSetups = aroundSetups;
        }

        CtClass getGenerated() {
            return this.generated;
        }

        AdviceSetup[] getAroundSetups() {
            return this.aroundSetups == null ? new AdviceSetup[]{} : this.aroundSetups;
        }
    }

    protected class AdviceSetup {
        int index;
        Class aspectClass;
        CtClass aspectCtClass;
        String adviceName;
        Scope scope;
        String registeredName;
        String cflowString;
        ASTCFlowExpression cflowExpr;
        int cflowIndex;
        boolean isBefore;
        boolean isAfter;
        boolean isThrowing;
        AdviceMethodProperties adviceMethodProperties;

        AdviceSetup(int index, InterceptorFactoryWrapper ifw) throws ClassNotFoundException, NotFoundException {
            this.index = index;
            this.scope = ifw.getScope();
            this.adviceName = ifw.getAdviceName();
            this.registeredName = ifw.getRegisteredName();
            this.cflowString = ifw.getCFlowString();
            this.cflowExpr = ifw.getCflowExpression();
            if (ifw.isAspectFactory()) {
                Object aspectInstance = JoinPointGenerator.this.info.getFactories()[index].getAspect(JoinPointGenerator.this.info.getAdvisor(), JoinPointGenerator.this.info.getJoinpoint());
                this.aspectClass = aspectInstance.getClass();
            } else {
                this.aspectClass = Thread.currentThread().getContextClassLoader().loadClass(ifw.getAspectClassName());
            }
            this.aspectCtClass = ReflectToJavassist.classToJavassist(this.aspectClass);
            this.isBefore = ifw.isBefore();
            this.isAfter = ifw.isAfter();
            this.isThrowing = ifw.isThrowing();
        }

        String getAdviceName() {
            return this.adviceName;
        }

        Class getAspectClass() {
            return this.aspectClass;
        }

        CtClass getAspectCtClass() {
            return this.aspectCtClass;
        }

        Scope getScope() {
            return this.scope;
        }

        int getIndex() {
            return this.index;
        }

        String getRegisteredName() {
            return this.registeredName;
        }

        String getAspectFieldName() {
            StringBuffer name = new StringBuffer();
            if (this.isAround()) {
                name.append("around");
            } else if (this.isBefore()) {
                name.append("before");
            } else if (this.isAfter()) {
                name.append("after");
            } else if (this.isThrowing()) {
                name.append("throwing");
            } else if (AspectManager.verbose) {
                System.out.println("[warn] Unsupported type of advice");
            }
            name.append(this.index + 1);
            return name.toString();
        }

        String getAspectInitialiserName() {
            StringBuffer name = new StringBuffer();
            if (this.isAround()) {
                name.append("getAround");
            } else if (this.isBefore()) {
                name.append("getBefore");
            } else if (this.isAfter()) {
                name.append("getAfter");
            } else if (this.isThrowing()) {
                name.append("getThrowing");
            } else if (AspectManager.verbose) {
                System.out.println("[warn] Unsupported type of advice");
            }
            name.append(this.index + 1);
            return name.toString();
        }

        boolean isPerInstance() {
            return this.scope == Scope.PER_INSTANCE;
        }

        boolean isPerJoinpoint() {
            return this.scope == Scope.PER_JOINPOINT;
        }

        boolean shouldInvokeAspect() {
            return !this.isPerInstance() || !JoinPointGenerator.this.isStaticCall();
        }

        boolean requiresInstanceAdvisor() {
            return this.isPerInstance() || this.isPerJoinpoint() && !JoinPointGenerator.this.isStaticCall();
        }

        String getCFlowString() {
            return this.cflowString;
        }

        ASTCFlowExpression getCFlow() {
            return this.cflowExpr;
        }

        void setUseCFlowFrom(int index) {
            this.cflowIndex = index;
        }

        int useCFlowFrom() {
            return this.cflowIndex;
        }

        boolean isNewCFlow() {
            return this.getCFlowString() != null && this.index == this.cflowIndex;
        }

        boolean isAfter() {
            return this.isAfter;
        }

        boolean isBefore() {
            return this.isBefore;
        }

        boolean isThrowing() {
            return this.isThrowing;
        }

        boolean isAround() {
            return !this.isAfter && !this.isBefore && !this.isThrowing;
        }

        public AdviceMethodProperties getAdviceMethodProperties() {
            return this.adviceMethodProperties;
        }

        public void setAdviceMethodProperties(AdviceMethodProperties adviceMethodProperties) {
            this.adviceMethodProperties = adviceMethodProperties;
        }
    }
}

