/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.AbstractProxyPushSupplier;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.SequenceProxyPushSupplierImplMBean;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetAdapter;
import org.jacorb.notification.util.PropertySetListener;
import org.omg.CORBA.ORB;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierPOATie;
import org.omg.CosNotifyComm.SequencePushConsumer;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.TimeBase.TimeTHelper;

public class SequenceProxyPushSupplierImpl
extends AbstractProxyPushSupplier
implements SequenceProxyPushSupplierOperations,
SequenceProxyPushSupplierImplMBean {
    private final Runnable timerTask_;
    private SequencePushConsumer sequencePushConsumer_;
    private ScheduledFuture taskId_;
    private final AtomicInteger maxBatchSize_ = new AtomicInteger(1);
    private final AtomicLong pacingInterval_ = new AtomicLong(0L);
    private long timeSpent_ = 0L;

    public SequenceProxyPushSupplierImpl(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(iAdmin, oRB, pOA, configuration, taskProcessor, pushTaskExecutorFactory, offerManager, subscriptionManager, consumerAdmin);
        this.configureMaxBatchSize();
        this.configurePacingInterval();
        this.timerTask_ = new Runnable(){

            public void run() {
                if (SequenceProxyPushSupplierImpl.this.isEnabled()) {
                    SequenceProxyPushSupplierImpl.this.scheduleFlush();
                }
            }
        };
        this.qosSettings_.addPropertySetListener("MaximumBatchSize", (PropertySetListener)new PropertySetAdapter(){

            public void actionPropertySetChanged(PropertySet propertySet) {
                SequenceProxyPushSupplierImpl.this.configureMaxBatchSize();
            }
        });
        this.qosSettings_.addPropertySetListener("PacingInterval", (PropertySetListener)new PropertySetAdapter(){

            public void actionPropertySetChanged(PropertySet propertySet) {
                SequenceProxyPushSupplierImpl.this.configurePacingInterval();
            }
        });
    }

    public ProxyType MyType() {
        return ProxyType.PUSH_SEQUENCE;
    }

    public boolean pushEvent() {
        Message[] messageArray = this.getAtLeastMessages(this.maxBatchSize_.get());
        return this.pushMessages(messageArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPendingEvents() {
        block9: {
            try {
                while (true) {
                    boolean bl;
                    if (!(bl = this.pushSync_.tryAcquire(1000L, TimeUnit.MILLISECONDS))) {
                        continue;
                    }
                    try {
                        boolean bl2;
                        Message[] messageArray = this.getUpToMessages(this.maxBatchSize_.get());
                        if (messageArray != null && messageArray.length != 0 && (bl2 = this.pushMessages(messageArray))) continue;
                        break block9;
                    }
                    finally {
                        this.pushSync_.release();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {}
            {
            }
        }
    }

    private boolean pushMessages(Message[] messageArray) {
        if (messageArray == null) {
            return false;
        }
        if (messageArray.length == 0) {
            return false;
        }
        StructuredEvent[] structuredEventArray = new StructuredEvent[messageArray.length];
        for (int i = 0; i < messageArray.length; ++i) {
            structuredEventArray[i] = messageArray[i].toStructuredEvent();
            messageArray[i].dispose();
        }
        try {
            this.deliverPendingMessagesInternal(structuredEventArray);
            return true;
        }
        catch (Exception exception) {
            PushSequenceOperation pushSequenceOperation = new PushSequenceOperation(structuredEventArray);
            this.handleFailedPushOperation(pushSequenceOperation, exception);
            return false;
        }
    }

    private void deliverPendingMessagesInternal(StructuredEvent[] structuredEventArray) throws Disconnected {
        long l = System.currentTimeMillis();
        this.sequencePushConsumer_.push_structured_events(structuredEventArray);
        this.timeSpent_ += System.currentTimeMillis() - l;
        this.resetErrorCounter();
    }

    public void connect_sequence_push_consumer(SequencePushConsumer sequencePushConsumer) throws AlreadyConnected, TypeError {
        this.logger_.debug("connect_sequence_push_consumer");
        this.checkIsNotConnected();
        this.sequencePushConsumer_ = sequencePushConsumer;
        this.connectClient(sequencePushConsumer);
        this.startTimerTask();
    }

    protected void connectionResumed() {
        this.scheduleFlush();
        this.startTimerTask();
    }

    protected void connectionSuspended() {
        this.stopTimerTask();
    }

    public void disconnect_sequence_push_supplier() {
        this.destroy();
    }

    protected void disconnectClient() {
        this.stopTimerTask();
        this.sequencePushConsumer_.disconnect_sequence_push_consumer();
        this.sequencePushConsumer_ = null;
    }

    private void startTimerTask() {
        if (this.pacingInterval_.get() > 0L && this.taskId_ == null) {
            long l = this.timeT2millis();
            this.taskId_ = this.getTaskProcessor().executeTaskPeriodically(l, this.timerTask_, true);
        }
    }

    public long timeT2millis() {
        long l = this.pacingInterval_.get();
        return SequenceProxyPushSupplierImpl.time2millis(l);
    }

    public static long time2millis(long l) {
        return l / 10000L;
    }

    private synchronized void stopTimerTask() {
        if (this.taskId_ != null) {
            this.taskId_.cancel(true);
            this.taskId_ = null;
        }
    }

    private void checkTimerTask() {
        if (this.getConnected() && this.pacingInterval_.get() > 0L) {
            this.stopTimerTask();
            this.startTimerTask();
        } else {
            this.stopTimerTask();
        }
    }

    private boolean configurePacingInterval() {
        if (this.qosSettings_.containsKey("PacingInterval")) {
            long l = TimeTHelper.extract(this.qosSettings_.get("PacingInterval"));
            if (this.pacingInterval_.get() != l) {
                if (this.logger_.isInfoEnabled()) {
                    this.logger_.info("set PacingInterval=" + l);
                }
                this.pacingInterval_.set(l);
                this.checkTimerTask();
                return true;
            }
        }
        return false;
    }

    private boolean configureMaxBatchSize() {
        if (this.qosSettings_.containsKey("MaximumBatchSize")) {
            int n = this.qosSettings_.get("MaximumBatchSize").extract_long();
            if (this.maxBatchSize_.get() != n) {
                if (this.logger_.isInfoEnabled()) {
                    this.logger_.info("set MaxBatchSize=" + n);
                }
                this.maxBatchSize_.set(n);
                return true;
            }
        }
        return false;
    }

    public Servant newServant() {
        return new SequenceProxyPushSupplierPOATie(this);
    }

    protected long getCost() {
        return this.timeSpent_;
    }

    private class PushSequenceOperation
    implements PushOperation {
        private final StructuredEvent[] structuredEvents_;

        public PushSequenceOperation(StructuredEvent[] structuredEventArray) {
            this.structuredEvents_ = structuredEventArray;
        }

        public void invokePush() throws Disconnected {
            SequenceProxyPushSupplierImpl.this.deliverPendingMessagesInternal(this.structuredEvents_);
        }

        public void dispose() {
        }
    }
}

