/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax.xmlfilter.tidy;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.ajax4jsf.framework.ajax.xmlfilter.HtmlParser;
import org.ajax4jsf.framework.util.message.Messages;
import org.ajax4jsf.org.w3c.tidy.Tidy;
import org.ajax4jsf.org.w3c.tidy.TidyMessage;
import org.ajax4jsf.org.w3c.tidy.TidyMessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TidyParser
implements TidyMessageListener,
HtmlParser {
    private static final Log log = LogFactory.getLog((Class)TidyParser.class);
    private Tidy tidy = new Tidy();
    private Set _scripts;
    private Set _styles;
    private String _viewState;
    private String _encoding;
    private String _outputEncoding;
    private static final String[] _htmlTypes = new String[]{"text/html"};
    private static final String[] _xmlTypes = new String[]{"text/xml"};
    private static final String[] _xhtmlTypes = new String[]{"application/xhtml+xml"};
    private static final String TIDY_MARK = "[TIDY_MESSAGE]";

    public TidyParser(Properties props) {
        this.tidy.setConfigurationFromProps(props);
        PrintWriter errout = new PrintWriter(new ErrorWriter());
        this.tidy.setErrout(errout);
        this.tidy.setForceOutput(true);
        this.tidy.setHideEndTags(false);
        this.tidy.setMessageListener(this);
    }

    public Document parseHtmlByTidy(Object input, Writer output) throws IOException {
        Document document = this.tidy.parseDOM(input, null);
        if (null != document) {
            Element documentElement = document.getDocumentElement();
            if (null != documentElement) {
                NodeList inputs = documentElement.getElementsByTagName("span");
                for (int i = 0; i < inputs.getLength(); ++i) {
                    Element node = (Element)inputs.item(i);
                    if (!"org.ajax4jsf.view.state".equals(node.getAttribute("id")) || !"org.ajax4jsf.view.state".equals(node.getAttribute("name"))) continue;
                    Node parentNode = node.getParentNode();
                    if (null != this._viewState) {
                        parentNode.replaceChild(document.createCDATASection(this._viewState), node);
                        continue;
                    }
                    if (node.hasChildNodes()) {
                        int j;
                        Node nextSibling = node.getNextSibling();
                        NodeList childNodes = node.getChildNodes();
                        Node[] childArray = new Node[childNodes.getLength()];
                        for (j = 0; j < childArray.length; ++j) {
                            childArray[j] = childNodes.item(j);
                        }
                        for (j = 0; j < childArray.length; ++j) {
                            parentNode.insertBefore(childArray[j], nextSibling);
                        }
                    }
                    parentNode.removeChild(node);
                }
                if (null != this._scripts || null != this._styles || null != this._viewState) {
                    String url;
                    String nodeName;
                    Node head = documentElement.getElementsByTagName("head").item(0);
                    if (null == head) {
                        head = document.createElement("head");
                        documentElement.insertBefore(head, documentElement.getFirstChild());
                    }
                    NodeList headChildren = head.getChildNodes();
                    Node child = null;
                    for (int i = 0; i < headChildren.getLength() && (!((child = headChildren.item(i)) instanceof Element) || "title".equalsIgnoreCase(nodeName = ((Element)child).getNodeName()) || "base".equalsIgnoreCase(nodeName)); ++i) {
                        child = null;
                    }
                    if (null != this._styles) {
                        Iterator iter = this._styles.iterator();
                        while (iter.hasNext()) {
                            url = (String)iter.next();
                            Element style = document.createElement("link");
                            style.setAttribute("type", "text/css");
                            style.setAttribute("rel", "stylesheet");
                            style.setAttribute("href", url);
                            head.insertBefore(style, child);
                        }
                    }
                    if (null != this._scripts) {
                        Iterator iter = this._scripts.iterator();
                        while (iter.hasNext()) {
                            url = (String)iter.next();
                            Element script = document.createElement("script");
                            script.setAttribute("type", "text/javascript");
                            script.setAttribute("src", url);
                            head.insertBefore(script, child);
                        }
                    }
                }
            }
            if (null != output) {
                this.tidy.pprint(document, output);
            }
        }
        return document;
    }

    public void parseHtml(InputStream input, Writer output) throws IOException {
        this.parseHtmlByTidy(input, output);
    }

    public void parseHtml(Reader input, Writer output) throws IOException {
        this.parseHtmlByTidy(input, output);
    }

    public void messageReceived(TidyMessage message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("MESSAGE_PARSING_INFO", message.getMessage()));
        }
    }

    public void setInputEncoding(String encoding) {
        if (null != encoding) {
            this._encoding = encoding;
            if (null != encoding) {
                this.tidy.setInputEncoding(encoding);
            }
        }
    }

    public void setOutputEncoding(String encoding) {
        if (null != encoding) {
            this._outputEncoding = encoding;
            if (null != encoding) {
                this.tidy.setOutputEncoding(encoding);
            }
        }
    }

    public boolean setMime(String mimeType) {
        if (null != mimeType) {
            String mime;
            int i;
            for (i = 0; i < _htmlTypes.length; ++i) {
                mime = _htmlTypes[i];
                if (!mimeType.startsWith(mime)) continue;
                this.tidy.setXHTML(false);
                this.tidy.setXmlOut(false);
                return true;
            }
            for (i = 0; i < _xhtmlTypes.length; ++i) {
                mime = _xhtmlTypes[i];
                if (!mimeType.startsWith(mime)) continue;
                this.tidy.setXHTML(true);
                this.tidy.setXmlOut(false);
                return true;
            }
            for (i = 0; i < _xmlTypes.length; ++i) {
                mime = _xmlTypes[i];
                if (!mimeType.startsWith(mime)) continue;
                this.tidy.setXHTML(true);
                this.tidy.setXmlOut(true);
                this.tidy.setXmlPi(true);
                this.tidy.setEscapeCdata(false);
                this.tidy.setNumEntities(true);
                return true;
            }
        }
        return false;
    }

    public void setMoveElements(boolean move) {
        this.tidy.setMoveElements(move);
    }

    public void setScripts(Set scripts) {
        this._scripts = scripts;
    }

    public void setStyles(Set styles) {
        this._styles = styles;
    }

    public void setDoctype(String doctype) {
        this.tidy.setDocType(doctype);
    }

    public void setViewState(String viewState) {
        this._viewState = viewState;
    }

    private static class ErrorWriter
    extends Writer {
        private ErrorWriter() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

