/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class URLLoaderAdapter
implements UnifiedVirtualFile {
    private URL rootURL;
    private URL resourceURL;
    private transient URLClassLoader loader;

    public URLLoaderAdapter(URL rootURL) {
        this.rootURL = rootURL;
    }

    private URLLoaderAdapter(URL rootURL, URLClassLoader loader, URL resourceURL) {
        this.rootURL = rootURL;
        this.resourceURL = resourceURL;
        this.loader = loader;
    }

    public UnifiedVirtualFile findChild(String resourcePath) throws IOException {
        URL resourceURL = null;
        if (resourcePath != null) {
            try {
                resourceURL = new URL(resourcePath);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (resourceURL == null) {
                try {
                    File file = new File(resourcePath);
                    if (file.exists()) {
                        resourceURL = file.toURL();
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (resourceURL == null) {
                try {
                    resourceURL = this.getResourceLoader().getResource(resourcePath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (resourceURL == null) {
            throw new IOException("Cannot get URL for: " + resourcePath);
        }
        return new URLLoaderAdapter(this.rootURL, this.loader, resourceURL);
    }

    public URL toURL() {
        if (this.resourceURL != null) {
            return this.resourceURL;
        }
        return this.rootURL;
    }

    private URLClassLoader getResourceLoader() {
        if (this.loader == null) {
            this.loader = new URLClassLoader(new URL[]{this.rootURL});
        }
        return this.loader;
    }
}

