/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task.config;

import java.io.File;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.jboss.tools.buildmagic.task.MissingAttributeException;
import org.jboss.tools.buildmagic.task.util.TaskLogger;
import org.jboss.util.DirectoryBuilder;

public class Library
extends Task {
    protected final TaskLogger log = new TaskLogger(this);
    protected String vendor;
    protected String name;
    protected File root;
    protected FileSet classpathSet;
    protected Path classpath;

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRoot(File root) {
        this.root = root;
    }

    public void setIncludes(String include) {
        FileSet fs = this.createClasspath();
        PatternSet.NameEntry entry = fs.createInclude();
        entry.setName(include);
    }

    public void setExcludes(String exclude) {
        FileSet fs = this.createClasspath();
        PatternSet.NameEntry entry = fs.createExclude();
        entry.setName(exclude);
    }

    public FileSet createClasspath() {
        if (this.classpathSet == null) {
            this.classpathSet = new FileSet();
        }
        return this.classpathSet;
    }

    public PatternSet.NameEntry createInclude() {
        return this.createClasspath().createInclude();
    }

    public PatternSet.NameEntry createExclude() {
        return this.createClasspath().createExclude();
    }

    protected void validate() throws BuildException {
        if (this.vendor == null) {
            throw new MissingAttributeException("vendor", this);
        }
        if (this.name == null) {
            throw new MissingAttributeException("name", this);
        }
        if (this.root == null) {
            throw new MissingAttributeException("root", this);
        }
    }

    protected File getVendorDir() {
        DirectoryBuilder builder = new DirectoryBuilder(this.root);
        builder.cd(this.vendor).cd(this.name);
        File dir = builder.get();
        return dir;
    }

    protected File getLibraryDir() {
        DirectoryBuilder builder = new DirectoryBuilder(this.getVendorDir());
        builder.cd("lib");
        File dir = builder.get();
        return dir;
    }

    public void execute() throws BuildException {
        if (this.classpath != null) {
            return;
        }
        this.validate();
        this.log.debug("vendor: " + this.vendor);
        this.log.debug("name: " + this.name);
        this.log.debug("root: " + this.root);
        File vendorDir = this.getVendorDir();
        this.project.setProperty(this.vendor + "." + this.name + ".root", vendorDir.toString());
        this.log.debug("vendorDir: " + vendorDir);
        File libDir = this.getLibraryDir();
        this.project.setProperty(this.vendor + "." + this.name + ".lib", libDir.toString());
        this.log.debug("libDir: " + libDir);
        if (this.classpathSet == null) {
            this.setIncludes("*");
        }
        this.log.debug("classpathSet: " + this.classpathSet);
        this.classpathSet.setDir(libDir);
        this.classpath = new Path(this.project);
        this.classpath.addFileset(this.classpathSet);
        this.log.debug("classpath: " + this.classpath);
        Hashtable refs = this.project.getReferences();
        refs.put(this.vendor + "." + this.name + ".classpath", this.classpath);
        this.vendor = null;
        this.name = null;
        this.root = null;
        this.classpathSet = null;
    }

    public Path getClasspath() {
        return this.classpath;
    }
}

