/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.reflect;

import java.lang.reflect.Modifier;

class StringMaker {
    boolean shortTypeNames = true;
    boolean includeArgs = true;
    boolean includeThrows = false;
    boolean includeModifiers = false;
    boolean shortPrimaryTypeNames = false;
    boolean includeJoinPointTypeName = true;
    boolean includeEnclosingPoint = true;
    boolean shortKindName = true;
    static StringMaker shortStringMaker = new StringMaker();
    static StringMaker middleStringMaker;
    static StringMaker longStringMaker;

    StringMaker() {
    }

    String makeKindName(String name) {
        int dash = name.lastIndexOf(45);
        if (dash == -1) {
            return name;
        }
        return name.substring(dash + 1);
    }

    String makeModifiersString(int modifiers) {
        if (!this.includeModifiers) {
            return "";
        }
        String str = Modifier.toString(modifiers);
        if (str.length() == 0) {
            return "";
        }
        return str + " ";
    }

    String stripPackageName(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return name;
        }
        return name.substring(dot + 1);
    }

    String makeTypeName(Class type, boolean shortName) {
        if (type == null) {
            return "ANONYMOUS";
        }
        if (type.isArray()) {
            return this.makeTypeName(type.getComponentType(), shortName) + "[]";
        }
        if (shortName) {
            return this.stripPackageName(type.getName()).replace('$', '.');
        }
        return type.getName().replace('$', '.');
    }

    public String makeTypeName(Class type) {
        return this.makeTypeName(type, this.shortTypeNames);
    }

    public String makePrimaryTypeName(Class type) {
        return this.makeTypeName(type, this.shortPrimaryTypeNames);
    }

    public void addTypeNames(StringBuffer buf, Class[] types) {
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.makeTypeName(types[i]));
            ++i;
        }
    }

    public void addSignature(StringBuffer buf, Class[] types) {
        if (types == null) {
            return;
        }
        if (!this.includeArgs) {
            if (types.length == 0) {
                buf.append("()");
                return;
            }
            buf.append("(..)");
            return;
        }
        buf.append("(");
        this.addTypeNames(buf, types);
        buf.append(")");
    }

    public void addThrows(StringBuffer buf, Class[] types) {
        if (!this.includeThrows || types == null || types.length == 0) {
            return;
        }
        buf.append(" throws ");
        this.addTypeNames(buf, types);
    }

    static {
        StringMaker.shortStringMaker.shortTypeNames = true;
        StringMaker.shortStringMaker.includeArgs = false;
        StringMaker.shortStringMaker.includeThrows = false;
        StringMaker.shortStringMaker.includeModifiers = false;
        StringMaker.shortStringMaker.shortPrimaryTypeNames = true;
        StringMaker.shortStringMaker.includeJoinPointTypeName = false;
        StringMaker.shortStringMaker.includeEnclosingPoint = false;
        middleStringMaker = new StringMaker();
        StringMaker.middleStringMaker.shortTypeNames = true;
        StringMaker.middleStringMaker.includeArgs = true;
        StringMaker.middleStringMaker.includeThrows = false;
        StringMaker.middleStringMaker.includeModifiers = false;
        StringMaker.middleStringMaker.shortPrimaryTypeNames = false;
        longStringMaker = new StringMaker();
        StringMaker.longStringMaker.shortTypeNames = false;
        StringMaker.longStringMaker.includeArgs = true;
        StringMaker.longStringMaker.includeThrows = false;
        StringMaker.longStringMaker.includeModifiers = true;
        StringMaker.longStringMaker.shortPrimaryTypeNames = false;
        StringMaker.longStringMaker.shortKindName = false;
    }
}

